/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.field;

import com.github.manasmods.tensura.entity.magic.field.AreaField;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GravityField
extends AreaField {
    public GravityField(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public GravityField(Level level, LivingEntity entity) {
        this((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.GRAVITY_FIELD.get()), level);
        this.m_5602_((Entity)entity);
    }

    @Override
    public void applyEffect(LivingEntity target, boolean instant) {
        LivingEntity owner;
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity && (target.m_7307_((Entity)(owner = (LivingEntity)entity)) || target == owner)) {
            target.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 100, 1, false, true), this.m_37282_());
            target.m_147207_(new MobEffectInstance(MobEffects.f_19591_, 100, 0, false, true), this.m_37282_());
        } else {
            Player player;
            if (target instanceof Player && (player = (Player)target).m_7500_()) {
                return;
            }
            target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), 100, 0, false, true), this.m_37282_());
            target.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 100, 1, false, true), this.m_37282_());
        }
    }

    @Override
    public void ambientParticles() {
        if (this.getVisualRadius() == this.getRadius() && this.f_19797_ % 5 != 0) {
            return;
        }
        Level level = this.m_9236_();
        float radius = this.getVisualRadius();
        Vec3 pos = this.m_20182_().m_82520_(0.0, (double)this.getRadius(), 0.0);
        int ySteps = (int)(3.2 * (double)radius);
        int xSteps = (int)(6.4 * (double)radius);
        float yDeg = 180.0f / (float)ySteps * ((float)Math.PI / 180);
        float xDeg = 360.0f / (float)xSteps * ((float)Math.PI / 180);
        for (int x = 0; x < xSteps; ++x) {
            for (int y = -ySteps; y < ySteps; ++y) {
                double dx = level.f_46441_.m_188500_() * 0.05 - 0.05;
                double dy = level.f_46441_.m_188500_() * 0.05 - 0.05;
                double dz = level.f_46441_.m_188500_() * 0.05 - 0.05;
                Vec3 offset = new Vec3(0.0, 0.0, (double)radius).m_82524_((float)y * yDeg).m_82496_((float)x * xDeg).m_82535_(-1.5707964f).m_82542_(1.0, (double)0.85f, 1.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123783_, pos.f_82479_ + offset.f_82479_ + dx, pos.f_82480_ + 1.0 + offset.f_82480_ + dy, pos.f_82481_ + offset.f_82481_ + dz, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123790_, pos.f_82479_ + offset.f_82479_ + dx, pos.f_82480_ + 1.0 + offset.f_82480_ + dy, pos.f_82481_ + offset.f_82481_ + dz, 0.0, 0.0, 0.0);
            }
        }
    }
}

