/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.field.cloud;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.field.cloud.AreaCloud;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class BloodMistCloud
extends AreaCloud {
    public BloodMistCloud(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BloodMistCloud(Level level, LivingEntity entity) {
        this((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.BLOOD_MIST.get()), level);
        this.m_5602_((Entity)entity);
    }

    @Override
    public void applyEffect(LivingEntity target, boolean instant) {
        DamageSource source;
        LivingEntity living;
        if (RaceHelper.hasNoBlood(target)) {
            return;
        }
        Entity owner = this.m_37282_();
        if (owner instanceof LivingEntity && (target.m_7307_((Entity)(living = (LivingEntity)owner)) || target.m_7306_((Entity)living))) {
            return;
        }
        DamageSource damageSource = source = owner == null ? TensuraDamageSources.BLOOD_DRAIN : TensuraDamageSources.bloodDrain(owner);
        if (target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(source, this.getMpCost() / 30.0, this.getSkill()), this.getDamage()) && owner instanceof LivingEntity) {
            LivingEntity living2 = (LivingEntity)owner;
            living2.m_5634_(this.getDamage());
        }
    }

    public void bloodExplosion() {
        if (!this.m_9236_().m_5776_()) {
            List targets = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
            for (LivingEntity target : targets) {
                LivingEntity living;
                Entity owner;
                if (!this.m_5603_((Entity)target) || !(target.m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_()) < (double)(this.getRadius() * this.getRadius())) || (owner = this.m_37282_()) instanceof LivingEntity && (target.m_7307_((Entity)(living = (LivingEntity)owner)) || target.m_7306_((Entity)living))) continue;
                DamageSource source = owner == null ? TensuraDamageSources.BLOOD_DRAIN : TensuraDamageSources.bloodDrain(owner);
                target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(source, this.getMpCost(), this.getSkill()), this.getDamage() * 10.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
            }
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.08, 0.08, 0.08, 0.15);
            TensuraParticleHelper.serverParticleCloud(this.m_9236_(), this.f_19796_, (ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.01, 0.5, 4.0);
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            TensuraParticleHelper.particleCloud(this.m_9236_(), this.f_19796_, (ParticleOptions)DustParticleOptions.f_123656_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.01, 0.15, this.getVisualRadius());
        }
    }
}

