/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.lightning;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.lightning.TenuraLightningBolt;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class BlackLightningBolt
extends TenuraLightningBolt {
    public BlackLightningBolt(Level pLevel) {
        super((EntityType<? extends LightningBolt>)((EntityType)TensuraEntityTypes.BLACK_LIGHTNING_BOLT.get()), pLevel);
    }

    public BlackLightningBolt(Level pLevel, Entity owner) {
        super((EntityType<? extends LightningBolt>)((EntityType)TensuraEntityTypes.BLACK_LIGHTNING_BOLT.get()), pLevel, owner);
    }

    @Override
    protected BlockState getFireBlock() {
        return ((Block)TensuraBlocks.BLACK_FIRE.get()).m_49966_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            return;
        }
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:black_strike"), this.m_19879_(), 0.0, -1.0, 0.0, true));
        if (this.f_20860_ != 1) {
            return;
        }
        for (int i = 0; i < this.getAdditionalVisual(); ++i) {
            double xOff = this.f_19796_.m_188501_() * 2.0f - 1.0f;
            double zOff = this.f_19796_.m_188501_() * 2.0f - 1.0f;
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:light_strike"), this.m_19879_(), xOff, -1.0, zOff, true));
        }
    }

    @Override
    protected void doAoEDamage() {
        float electricRadius = this.m_20072_() ? this.getRadius() * 1.5f : this.getRadius();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82400_((double)electricRadius), entity -> this.canHit((Entity)entity) && entity.m_20270_((Entity)this) < electricRadius);
        DamageSource damageSource = this.getOwner() == null ? TensuraDamageSources.BLACK_LIGHTNING : TensuraDamageSources.blackLightning(this.getOwner());
        for (Entity entity2 : list) {
            TensuraParticleHelper.addServerParticlesAroundSelf(entity2, (ParticleOptions)TensuraParticles.BLACK_LIGHTNING_SPARK.get(), 1.0);
            DamageSourceHelper.dealSplitElementalDamage(entity2, DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost(), this.getSkill()), 0.9f, this.getTensuraDamage());
            Level level = this.f_19853_;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            entity2.m_8038_(serverLevel, (LightningBolt)this);
        }
        if (TensuraGameRules.canSkillGrief(this.f_19853_)) {
            this.placeFireAndMeltGlass(this.m_20182_(), (int)this.getRadius());
        }
    }
}

