/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.misc;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChaosEaterProjectile
extends TensuraProjectile {
    private static final EntityDataAccessor<Boolean> REACHED = SynchedEntityData.m_135353_(ChaosEaterProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> START_OFFSET_X = SynchedEntityData.m_135353_(ChaosEaterProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_OFFSET_Y = SynchedEntityData.m_135353_(ChaosEaterProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_OFFSET_Z = SynchedEntityData.m_135353_(ChaosEaterProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_DISTANCE = SynchedEntityData.m_135353_(ChaosEaterProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> MAX_COUNT = SynchedEntityData.m_135353_(ChaosEaterProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> NUMBER = SynchedEntityData.m_135353_(ChaosEaterProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int capturedTarget = 0;
    @Nullable
    private LivingEntity target;

    public ChaosEaterProjectile(EntityType<? extends ChaosEaterProjectile> entityType, Level level) {
        super(entityType, level);
        this.setSize(1.25f);
    }

    public ChaosEaterProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.CHAOS_EATER.get()), levelIn);
        this.m_5602_((Entity)shooter);
        this.setSize(1.25f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(REACHED, (Object)false);
        this.f_19804_.m_135372_(START_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_OFFSET_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_DISTANCE, (Object)Float.valueOf(2.0f));
        this.f_19804_.m_135372_(MAX_COUNT, (Object)4);
        this.f_19804_.m_135372_(NUMBER, (Object)0);
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Reached", this.isReached());
        compound.m_128350_("xStart", (float)this.getStartOffset().m_7096_());
        compound.m_128350_("yStart", (float)this.getStartOffset().m_7098_());
        compound.m_128350_("zStart", (float)this.getStartOffset().m_7094_());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setReached(compound.m_128471_("Reached"));
        this.setStartOffset(compound.m_128457_("xStart"), compound.m_128457_("yStart"), compound.m_128457_("zStart"));
    }

    public boolean isReached() {
        return (Boolean)this.f_19804_.m_135370_(REACHED);
    }

    public void setReached(boolean reached) {
        this.f_19804_.m_135381_(REACHED, (Object)reached);
    }

    public void setStartOffset(float x, float y, float z) {
        this.m_20088_().m_135381_(START_OFFSET_X, (Object)Float.valueOf(x));
        this.m_20088_().m_135381_(START_OFFSET_Y, (Object)Float.valueOf(y));
        this.m_20088_().m_135381_(START_OFFSET_Z, (Object)Float.valueOf(z));
    }

    public Vec3 getStartOffset() {
        return new Vec3((double)((Float)this.m_20088_().m_135370_(START_OFFSET_X)).floatValue(), (double)((Float)this.m_20088_().m_135370_(START_OFFSET_Y)).floatValue(), (double)((Float)this.m_20088_().m_135370_(START_OFFSET_Z)).floatValue());
    }

    public float getStartDistance() {
        return ((Float)this.f_19804_.m_135370_(START_DISTANCE)).floatValue();
    }

    public void setStartDistance(float distance) {
        this.f_19804_.m_135381_(START_DISTANCE, (Object)Float.valueOf(distance));
    }

    public int getMaxCount() {
        return (Integer)this.f_19804_.m_135370_(MAX_COUNT);
    }

    public void setMaxCount(int count) {
        this.f_19804_.m_135381_(MAX_COUNT, (Object)count);
    }

    public int getCount() {
        return (Integer)this.f_19804_.m_135370_(NUMBER);
    }

    public void setCount(int count) {
        this.f_19804_.m_135381_(NUMBER, (Object)count);
    }

    public void setUpStartPos(int maxCount, int count, float startDistance) {
        this.setMaxCount(maxCount);
        this.setCount(count);
        this.setStartDistance(startDistance);
    }

    @Nullable
    public LivingEntity getTarget() {
        Entity entity;
        if (this.target == null && (entity = this.m_37282_()) instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.m_5448_();
        }
        return this.target;
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        this.target = pTarget;
    }

    @Override
    public boolean piercingBlock() {
        return true;
    }

    @Override
    public boolean piercingEntity() {
        return true;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    public void m_7332_(@NotNull Entity entity) {
        if (!this.m_20363_(entity)) {
            return;
        }
        entity.m_183634_();
        entity.m_6034_(this.m_20185_(), this.m_20186_() - (double)(entity.m_20206_() / 2.0f), this.m_20189_());
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("tensura", "textures/blank_texture.png")};
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        Entity owner;
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get());
        }
        if ((owner = this.m_37282_()) == null) {
            return;
        }
        double distance = Math.sqrt(this.m_20238_(owner.m_146892_()));
        if (!this.m_20197_().isEmpty() && !this.f_19853_.m_5776_()) {
            if (this.capturedTarget > 0) {
                --this.capturedTarget;
                if (this.capturedTarget <= 0) {
                    this.m_20153_();
                }
            } else if (distance <= 2.0) {
                this.m_20153_();
            }
        }
        if ((target = this.getTarget()) != null && !target.m_6084_()) {
            this.setTarget(null);
        }
        this.updateStartPos(owner);
        if (target != null && !this.isReached()) {
            double f = this.m_20270_((Entity)target);
            double d0 = (target.m_20185_() - this.m_20185_()) / f;
            double d1 = (target.m_20186_() + (double)(target.m_20206_() / 2.0f) - this.m_20186_()) / f;
            double d2 = (target.m_20189_() - this.m_20189_()) / f;
            this.m_20256_(new Vec3(d0, d1, d2));
            if (distance >= 50.0) {
                this.setReached(true);
            }
        } else if (!this.isReached() && owner instanceof Player) {
            Player player = (Player)owner;
            Vec3 result = SkillHelper.getPlayerPOVHitResult(this.f_19853_, (Entity)player, ClipContext.Fluid.ANY, 20.0).m_82450_();
            double f = Math.sqrt(this.m_20238_(result));
            double d0 = (result.f_82479_ - this.m_20185_()) / f;
            double d1 = (result.f_82480_ - this.m_20186_()) / f;
            double d2 = (result.f_82481_ - this.m_20189_()) / f;
            this.m_20256_(new Vec3(d0, d1, d2));
            if (distance >= 20.0 || f <= 0.5) {
                this.setReached(true);
            }
        } else {
            float multiplier = this.m_20197_().isEmpty() ? 1.0f : 0.4f;
            double d0 = (owner.m_20185_() - this.m_20185_()) / distance * (double)multiplier;
            double d1 = (owner.m_20188_() - this.m_20186_()) / distance * (double)multiplier;
            double d2 = (owner.m_20189_() - this.m_20189_()) / distance * (double)multiplier;
            this.m_20256_(new Vec3(d0, d1, d2));
            if (distance <= 2.5 && !this.f_19853_.m_5776_()) {
                this.m_146870_();
            }
            for (ItemEntity item : owner.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(2.0))) {
                item.m_146884_(this.m_20182_());
            }
        }
    }

    protected void updateStartPos(Entity owner) {
        int rot = 360 / this.getMaxCount();
        for (int i = 0; i < this.getMaxCount(); ++i) {
            Vec3 offset = new Vec3(0.0, (double)this.getStartDistance(), 0.0).m_82535_(((float)(rot * i) - (float)rot / 2.0f) * ((float)Math.PI / 180)).m_82496_(-owner.m_146909_() * ((float)Math.PI / 180)).m_82524_(-owner.m_146908_() * ((float)Math.PI / 180));
            if (this.getCount() != i) continue;
            this.setStartOffset((float)offset.f_82479_, (float)offset.f_82480_, (float)offset.f_82481_);
        }
        if (this.f_19797_ % 5 == 0) {
            TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, this.f_19853_, owner.m_146892_().m_82549_(this.getStartOffset()), (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get(), 0.5);
        }
    }

    @Override
    protected void hitEntity(Entity entity) {
        LivingEntity living;
        entity.m_20254_(Math.max(this.getBurnTicks(), 0));
        if (this.knockForce > 0.0f) {
            this.knockBack(entity, this.getKnockForce(), (double)this.getKnockForce() / 3.0);
        }
        if (this.getMobEffect() != null && entity instanceof LivingEntity && !this.isAlly(living = (LivingEntity)entity)) {
            SkillHelper.checkThenAddEffectSource(living, this.m_37282_(), this.getMobEffect());
        }
        this.dealDamage(entity);
    }

    @Override
    protected void dealDamage(Entity target) {
        DamageSource damagesource;
        LivingEntity living;
        if (target.f_19853_.m_5776_()) {
            return;
        }
        if (this.isReached() && target == this.m_37282_()) {
            this.m_146870_();
        }
        if (this.getTarget() == null || this.getTarget() == target) {
            this.setReached(true);
        }
        if (this.damage <= 0.0f) {
            return;
        }
        if (target instanceof LivingEntity && this.isAlly(living = (LivingEntity)target)) {
            return;
        }
        if (target.m_20202_() == this) {
            return;
        }
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.FULL_GRAVITY_CONTROL)) {
            return;
        }
        DamageSource damageSource = damagesource = this.m_37282_() != null ? TensuraDamageSources.corrosion(this.m_37282_()) : TensuraDamageSources.CORROSION;
        if (target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(damagesource, this.getMpCost(), this.getSkill()), this.getDamage()) && this.capturedTarget <= 0 && !(target.m_20202_() instanceof ChaosEaterProjectile)) {
            target.m_7998_((Entity)this, true);
            this.capturedTarget = 40;
        }
    }

    @Override
    public void applyEffectAround(double inflateRadius) {
        if (this.getMobEffect() == null) {
            return;
        }
        List livingEntityList = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(inflateRadius), entity -> !this.isAlly((LivingEntity)entity));
        if (livingEntityList.isEmpty()) {
            return;
        }
        for (LivingEntity entity2 : livingEntityList) {
            Entity entity3 = this.m_37282_();
            if (entity3 instanceof LivingEntity) {
                LivingEntity player = (LivingEntity)entity3;
                entity2.m_6703_(player);
            }
            SkillHelper.checkThenAddEffectSource(entity2, this.m_37282_(), this.getMobEffect());
        }
    }

    public boolean isAlly(LivingEntity entity) {
        if (entity == this.m_37282_()) {
            return true;
        }
        return this.m_37282_() != null && this.m_37282_().m_7307_((Entity)entity);
    }

    @Override
    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123765_, x, y, z, 10, 0.5, 0.5, 0.5, 0.1, false);
    }

    @Override
    public void flyingParticles() {
    }
}

