/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.misc;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class DeathStormTornado
extends Entity {
    @Nullable
    private Entity owner = null;
    private float newDamage = 5.0f;
    private float radius = 2.0f;
    protected double mpCost = 0.0;
    protected ManasSkillInstance skill = null;
    public int life = 200;

    public DeathStormTornado(Level pLevel) {
        super((EntityType)TensuraEntityTypes.DEATH_STORM_TORNADO.get(), pLevel);
    }

    public DeathStormTornado(Level pLevel, Entity owner) {
        super((EntityType)TensuraEntityTypes.DEATH_STORM_TORNADO.get(), pLevel);
        this.setOwner(owner);
    }

    protected void m_8097_() {
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128347_("MPCost", this.getMpCost());
        if (this.skill != null) {
            pCompound.m_128365_("skill", (Tag)this.skill.toNBT());
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        Tag tag;
        this.setMpCost(pCompound.m_128459_("MPCost"));
        if (pCompound.m_128441_("skill") && (tag = pCompound.m_128423_("skill")) instanceof CompoundTag) {
            CompoundTag tag2 = (CompoundTag)tag;
            this.skill = ManasSkillInstance.fromNBT((CompoundTag)tag2);
        }
    }

    public SoundSource m_5720_() {
        return SoundSource.WEATHER;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_6673_(DamageSource pSource) {
        return !pSource.f_19328_;
    }

    private boolean isTarget(Entity entity) {
        Player player;
        if (entity == this) {
            return false;
        }
        if (entity == this.getOwner()) {
            return false;
        }
        if (this.owner != null && this.owner.m_7307_(entity)) {
            return false;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return entity.m_6084_();
    }

    public void m_8119_() {
        AABB aabb;
        List list;
        super.m_8119_();
        if (this.f_19853_.m_5776_() && this.life % 20 == 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f, false);
        }
        if (!(list = this.f_19853_.m_6249_((Entity)this, aabb = this.m_20191_().m_82377_((double)this.radius, 30.0, (double)this.radius).m_82363_(0.0, 50.0, 0.0), this::isTarget)).isEmpty()) {
            for (Entity entity : list) {
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.1, 0.0));
                entity.f_19864_ = true;
                entity.f_19812_ = true;
                if (this.f_19797_ % 10 != 0) continue;
                DamageSource damageSource = this.getOwner() == null ? TensuraDamageSources.DEATH_TORNADO : TensuraDamageSources.deathTornado(this.getOwner());
                DamageSourceHelper.dealSplitElementalDamage(entity, DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost(), this.getSkill()), 0.9f, this.getNewDamage());
            }
        }
        --this.life;
        if (this.life < 0) {
            this.m_146870_();
        }
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (this.f_19797_ == 1) {
            this.launchBlocks((int)this.radius);
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:death_tornado"), this.m_19879_(), 0.0, 0.0, 0.0, false));
        }
    }

    protected void launchBlocks(int radius) {
        Level level = this.m_9236_();
        if (!TensuraGameRules.canSkillGrief(level)) {
            return;
        }
        SkillHelper.launchBlock(this, this.m_20182_(), radius + 1, 1, (float)radius / 6.0f, (float)radius / 9.0f, blockState -> {
            if (this.f_19796_.m_188503_(3) != 1) {
                return false;
            }
            return blockState.m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY);
        }, blockPos -> true, this.getSkill());
    }

    @Nullable
    public Entity getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable Entity owner) {
        this.owner = owner;
    }

    public float getNewDamage() {
        return this.newDamage;
    }

    public void setNewDamage(float newDamage) {
        this.newDamage = newDamage;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public double getMpCost() {
        return this.mpCost;
    }

    public void setMpCost(double mpCost) {
        this.mpCost = mpCost;
    }

    public ManasSkillInstance getSkill() {
        return this.skill;
    }

    public void setSkill(ManasSkillInstance skill) {
        this.skill = skill;
    }
}

