/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.misc;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.skill.FlameOrbProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MadOgreOrbsEntity
extends Mob
implements IAnimatable {
    private static final EntityDataAccessor<Integer> SPHERES_NUMBERS = SynchedEntityData.m_135353_(MadOgreOrbsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_COOLDOWN = SynchedEntityData.m_135353_(MadOgreOrbsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> INIT_SIZE = SynchedEntityData.m_135353_(MadOgreOrbsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected float speed = 0.0f;
    protected float damage = 0.0f;
    protected float explosionRadius = 0.0f;
    protected float knockForce = 0.0f;
    protected int burnTicks = 0;
    protected double mpCost = 0.0;
    protected ManasSkillInstance skill = null;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public MadOgreOrbsEntity(EntityType<? extends MadOgreOrbsEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public MadOgreOrbsEntity(Level pLevel, @Nullable LivingEntity pOwner) {
        this((EntityType<? extends MadOgreOrbsEntity>)((EntityType)TensuraEntityTypes.MAD_OGRE_ORBS.get()), pLevel);
        this.f_19794_ = true;
        this.setOwner((Entity)pOwner);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22265_();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity owner = this.getLivingOwner();
            if (this.f_19797_ % 100 == 0 && this.getSpheres() < 6) {
                this.setSpheres(this.getSpheres() + 1);
            }
            if (owner == null) {
                this.m_146870_();
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity owner = this.getLivingOwner();
        if (owner != null && owner.m_6084_()) {
            this.m_146922_(Math.abs(-90.0f - owner.m_146908_()));
            this.f_19859_ = this.m_146908_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
        }
    }

    private LivingEntity getLivingOwner() {
        if (this.f_19797_ > 0 && this.f_19797_ % 12000 == 0) {
            return null;
        }
        Entity entity = this.getOwner();
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity owner = (LivingEntity)entity;
        if (this.m_20202_() != owner) {
            return null;
        }
        if (!owner.m_21023_((MobEffect)TensuraMobEffects.MAD_OGRE.get())) {
            return null;
        }
        return owner;
    }

    public void shootOrbs(LivingEntity owner) {
        if (this.getSpheres() <= 0) {
            return;
        }
        this.setSpheres(this.getSpheres() - 1);
        FlameOrbProjectile orb = new FlameOrbProjectile(this.m_9236_(), owner);
        orb.m_20242_(true);
        orb.setSpeed(this.m_6113_());
        orb.setDamage(this.getDamage());
        orb.setExplosionRadius(this.getExplosionRadius());
        orb.setBurnTicks(this.getBurnTicks());
        orb.setKnockForce(this.getKnockForce());
        orb.setMpCost(this.getMpCost());
        orb.setSkill(this.getSkill());
        orb.setPosAndShoot(owner);
        if (this.getSpheres() == 0 || this.getSpheres() == 2 || this.getSpheres() == 5) {
            orb.setPosDirection(owner, TensuraProjectile.PositionDirection.LEFT);
        }
        this.m_9236_().m_7967_((Entity)orb);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 0.5f, 0.5f);
    }

    public boolean m_6673_(DamageSource source) {
        return this.m_213877_() || source != DamageSource.f_19317_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPHERES_NUMBERS, (Object)6);
        this.f_19804_.m_135372_(SHOOT_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(INIT_SIZE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Speed", this.m_6113_());
        pCompound.m_128350_("Damage", this.getDamage());
        pCompound.m_128350_("ExplosionRadius", this.getExplosionRadius());
        pCompound.m_128405_("BurnTicks", this.getBurnTicks());
        pCompound.m_128350_("KnockBack", this.getKnockForce());
        pCompound.m_128347_("MPCost", this.getMpCost());
        pCompound.m_128376_("Cooldown", (short)this.getShootCooldown());
        pCompound.m_128376_("Spheres", (short)this.getSpheres());
        pCompound.m_128350_("Size", this.getInitSize());
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        if (this.skill != null) {
            pCompound.m_128365_("skill", (Tag)this.skill.toNBT());
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        Tag tag;
        super.m_7378_(pCompound);
        this.m_7910_(pCompound.m_128457_("Speed"));
        this.setDamage(pCompound.m_128457_("Damage"));
        this.setExplosionRadius(pCompound.m_128457_("ExplosionRadius"));
        this.setBurnTicks(pCompound.m_128451_("BurnTicks"));
        this.setKnockForce(pCompound.m_128457_("KnockBack"));
        this.setMpCost(pCompound.m_128459_("MPCost"));
        this.setShootCooldown(pCompound.m_128448_("Cooldown"));
        this.setSpheres(pCompound.m_128448_("Spheres"));
        this.setInitSize(pCompound.m_128457_("Size"));
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
        if (pCompound.m_128441_("skill") && (tag = pCompound.m_128423_("skill")) instanceof CompoundTag) {
            CompoundTag tag2 = (CompoundTag)tag;
            this.skill = ManasSkillInstance.fromNBT((CompoundTag)tag2);
        }
    }

    public void setSpheres(int pLife) {
        this.f_19804_.m_135381_(SPHERES_NUMBERS, (Object)pLife);
    }

    public int getSpheres() {
        return (Integer)this.f_19804_.m_135370_(SPHERES_NUMBERS);
    }

    public void setShootCooldown(int i) {
        this.f_19804_.m_135381_(SHOOT_COOLDOWN, (Object)i);
    }

    public int getShootCooldown() {
        return (Integer)this.f_19804_.m_135370_(SHOOT_COOLDOWN);
    }

    public void setInitSize(float size) {
        this.f_19804_.m_135381_(INIT_SIZE, (Object)Float.valueOf(size));
    }

    public float getInitSize() {
        return ((Float)this.f_19804_.m_135370_(INIT_SIZE)).floatValue();
    }

    public void setOwner(@Nullable Entity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
            if (pOwner.m_20089_().equals((Object)Pose.STANDING)) {
                this.setInitSize(pOwner.m_20206_() / 3.2f);
            }
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.f_19853_ instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    protected boolean ownedBy(Entity pEntity) {
        return pEntity.m_20148_().equals(this.ownerUUID);
    }

    public Packet<?> m_5654_() {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((LivingEntity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        Entity entity = this.f_19853_.m_6815_(pPacket.m_131509_());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public float m_6113_() {
        return this.speed;
    }

    public void m_7910_(float speed) {
        this.speed = speed;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getExplosionRadius() {
        return this.explosionRadius;
    }

    public void setExplosionRadius(float explosionRadius) {
        this.explosionRadius = explosionRadius;
    }

    public float getKnockForce() {
        return this.knockForce;
    }

    public void setKnockForce(float knockForce) {
        this.knockForce = knockForce;
    }

    public int getBurnTicks() {
        return this.burnTicks;
    }

    public void setBurnTicks(int burnTicks) {
        this.burnTicks = burnTicks;
    }

    public double getMpCost() {
        return this.mpCost;
    }

    public void setMpCost(double mpCost) {
        this.mpCost = mpCost;
    }

    public ManasSkillInstance getSkill() {
        return this.skill;
    }

    public void setSkill(ManasSkillInstance skill) {
        this.skill = skill;
    }
}

