/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.projectile;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.lightning.LightningBolt;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class LightningSphereProjectile
extends TensuraProjectile {
    protected static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/lightning_sphere/lightning_ball_0.png"), new ResourceLocation("tensura", "textures/entity/projectiles/lightning_sphere/lightning_ball_1.png"), new ResourceLocation("tensura", "textures/entity/projectiles/lightning_sphere/lightning_ball_2.png"), new ResourceLocation("tensura", "textures/entity/projectiles/lightning_sphere/lightning_ball_3.png"), new ResourceLocation("tensura", "textures/entity/projectiles/lightning_sphere/lightning_ball_4.png"), new ResourceLocation("tensura", "textures/entity/projectiles/lightning_sphere/lightning_ball_5.png")};

    public LightningSphereProjectile(EntityType<? extends LightningSphereProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public LightningSphereProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.LIGHTNING_SPHERE.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public String getMagic() {
        return "tensura.lightning_attack";
    }

    @Override
    public boolean piercingEntity() {
        return true;
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return TEXTURES;
    }

    protected void m_6532_(@NotNull HitResult hitresult) {
        ServerPlayer serverPlayer;
        super.m_6532_(hitresult);
        Entity entity = this.m_37282_();
        LightningBolt bolt = new LightningBolt(this.f_19853_, entity);
        bolt.m_20879_(entity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null);
        bolt.setMpCost(this.getMpCost());
        bolt.setTensuraDamage(this.getDamage());
        bolt.setSkill(this.getSkill());
        float radius = this.getSize();
        bolt.setAdditionalVisual((int)radius);
        bolt.setRadius(radius);
        bolt.m_146884_(this.m_20182_());
        this.f_19853_.m_7967_((Entity)bolt);
    }

    @Override
    public void applyEffectAround(double inflateRadius) {
        List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(inflateRadius), entityData -> this.m_37282_() == null || !entityData.m_7307_(this.m_37282_()) && !entityData.m_7306_(this.m_37282_()));
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity target : list) {
            if (this.getMobEffect() != null) {
                SkillHelper.checkThenAddEffectSource(target, this.m_37282_(), this.getMobEffect());
            }
            DamageSource damagesource = TensuraDamageSources.indirectElementalAttack(this.getMagic(), (Entity)this, this.m_37282_(), this.getMpCost() / 10.0, this.getSkill(), false);
            DamageSourceHelper.dealSplitElementalDamage((Entity)target, damagesource, 0.9f, this.getDamage() / 10.0f);
        }
    }

    @Override
    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_12089_);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get(), x, y, z, 10, 0.5, 0.5, 0.5, 0.1, false);
    }

    @Override
    public void flyingParticles() {
        if ((double)this.f_19796_.m_188501_() <= 0.8) {
            double dx = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double dy = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double dz = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double x = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            double y = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            double z = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            this.f_19853_.m_7106_((ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get(), this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, dx, dy, dz);
        }
    }
}

