/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.projectile;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class WindSphereProjectile
extends TensuraProjectile {
    protected static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/wind_sphere/wind_sphere_0.png"), new ResourceLocation("tensura", "textures/entity/projectiles/wind_sphere/wind_sphere_1.png"), new ResourceLocation("tensura", "textures/entity/projectiles/wind_sphere/wind_sphere_2.png"), new ResourceLocation("tensura", "textures/entity/projectiles/wind_sphere/wind_sphere_3.png"), new ResourceLocation("tensura", "textures/entity/projectiles/wind_sphere/wind_sphere_4.png")};

    public WindSphereProjectile(EntityType<? extends WindSphereProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public WindSphereProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.WIND_SPHERE.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public String getMagic() {
        return "tensura.wind_attack";
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return TEXTURES;
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.0), LivingEntity::m_6084_);
        if (!list.isEmpty()) {
            for (LivingEntity target : list) {
                target.m_5997_(0.0, 1.0, 0.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.GUST.get(), 2.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 2.0);
                Entity entity = this.m_37282_();
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                target.m_6598_(player);
            }
        }
        super.m_8060_(blockHitResult);
    }

    @Override
    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_12317_);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.GUST.get(), 3.0);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), x, y, z, 20, 0.1, 0.1, 0.1, 0.15, true);
    }

    @Override
    public void flyingParticles() {
        double dx = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
        double dy = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
        double dz = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
        double x = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
        double y = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
        double z = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
        this.f_19853_.m_7106_((ParticleOptions)TensuraParticles.SMALL_GUST.get(), this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, dx, dy, dz);
    }
}

