/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.spike;

import com.github.manasmods.tensura.ability.skill.unique.AntiSkill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.spike.SpikeEntity;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Optional;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class PillarEntity
extends SpikeEntity {
    private static final EntityDataAccessor<Optional<BlockState>> STATE = SynchedEntityData.m_135353_(PillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(PillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public PillarEntity(EntityType<? extends PillarEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PillarEntity(Level pLevel, LivingEntity pOwner) {
        this((EntityType<? extends PillarEntity>)((EntityType)TensuraEntityTypes.EARTH_PILLAR.get()), pLevel);
        this.setOwner((Entity)pOwner);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(STATE, Optional.of(Blocks.f_50493_.m_49966_()));
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setHealth(pCompound.m_128457_("Health"));
        this.setBlockState(NbtUtils.m_129241_((CompoundTag)pCompound.m_128469_("BlockState")));
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Health", this.getHealth());
        if (this.getBlockState().isPresent()) {
            pCompound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.getBlockState().get()));
        }
    }

    public void setBlockState(BlockState state) {
        this.f_19804_.m_135381_(STATE, Optional.of(state));
        this.setHealth(state.m_60734_().m_155943_() * 100.0f);
    }

    public Optional<BlockState> getBlockState() {
        return (Optional)this.f_19804_.m_135370_(STATE);
    }

    public void setHealth(float pDamageTaken) {
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(pDamageTaken));
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    @Override
    public boolean shouldPushUp() {
        return true;
    }

    @Override
    public void applyEffect(LivingEntity target) {
        if (this.getTickCount() > this.getExtendingTick()) {
            return;
        }
        DamageSource damageSource = TensuraDamageSources.indirectElementalAttack("tensura.earth_attack", this, this.getOwner(), true);
        target.m_6469_(damageSource, this.getDamage());
    }

    @Override
    public void onBreak() {
        if (this.getBlockState().isPresent()) {
            BlockState state = this.getBlockState().get();
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, state);
            TensuraParticleHelper.addServerParticlesAroundSelf(this, (ParticleOptions)particle);
            TensuraParticleHelper.addServerParticlesAroundSelf(this, (ParticleOptions)particle);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), state.m_60734_().m_49962_(state).m_56775_(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.m_146870_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.f_19853_.m_5776_() && !this.m_213877_()) {
            Entity entity = pSource.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (((AntiSkill)((Object)UniqueSkills.ANTI_SKILL.get())).isInSlot(attacker)) {
                    pAmount = this.getHealth();
                } else if (attacker.m_21205_().m_41720_() instanceof PickaxeItem) {
                    pAmount *= 2.0f;
                }
            }
            this.setHealth(this.getHealth() - pAmount);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            if (this.getHealth() <= 0.0f) {
                this.onBreak();
            } else if (this.getBlockState().isPresent()) {
                BlockState state = this.getBlockState().get();
                TensuraParticleHelper.addServerParticlesAroundSelf(this, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state));
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), state.m_60734_().m_49962_(state).m_56778_(), this.m_5720_(), 2.0f, 1.0f);
            }
        }
        return true;
    }
}

