/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.projectile;

import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class UnicornHornProjectile
extends AbstractArrow {
    private int life;

    public UnicornHornProjectile(EntityType<? extends UnicornHornProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public UnicornHornProjectile(Level pLevel, LivingEntity pShooter) {
        super((EntityType)TensuraEntityTypes.UNICORN_HORN.get(), pShooter, pLevel);
        this.m_36781_(this.m_36789_() + 2.75);
    }

    public UnicornHornProjectile(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)TensuraEntityTypes.UNICORN_HORN.get(), pX, pY, pZ, pLevel);
        this.m_36781_(this.m_36789_() + 2.75);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Life", this.life);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.life = pCompound.m_128451_("Life");
    }

    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)TensuraMobDropItems.UNICORN_HORN.get());
    }

    protected float m_6882_() {
        return 0.55f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.life == 0 && !this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11932_, SoundSource.AMBIENT, 3.0f, 1.0f);
        }
        ++this.life;
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (!this.f_19853_.m_5776_()) {
            LivingEntity living;
            Entity entity = pResult.m_82443_();
            this.explode(entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
        }
        super.m_5790_(pResult);
    }

    protected void m_8060_(BlockHitResult pResult) {
        BlockPos blockpos = new BlockPos((Vec3i)pResult.m_82425_());
        this.f_19853_.m_8055_(blockpos).m_60682_(this.f_19853_, blockpos, (Entity)this);
        if (!this.f_19853_.m_5776_()) {
            this.explode(null);
        }
        super.m_8060_(pResult);
    }

    private void explode(@Nullable LivingEntity living) {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11930_, SoundSource.AMBIENT, 3.0f, 1.0f);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11934_, SoundSource.AMBIENT, 2.0f, 1.0f);
        this.f_19853_.m_7605_((Entity)this, (byte)17);
        this.m_146852_(GameEvent.f_157812_, this.m_37282_());
        this.dealExplosionDamage(living);
        this.m_146870_();
    }

    private void dealExplosionDamage(@Nullable LivingEntity living) {
        Vec3 vec3 = this.m_20182_();
        for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(5.0))) {
            if (!(this.m_20280_((Entity)livingentity) <= 25.0) || livingentity == living) continue;
            boolean flag = false;
            for (int i = 0; i < 2; ++i) {
                Vec3 vec31 = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5 * (double)i), livingentity.m_20189_());
                BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (hitresult.m_6662_() != HitResult.Type.MISS) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            float f1 = 15.0f * (float)Math.sqrt((5.0 - (double)this.m_20270_((Entity)livingentity)) / 5.0);
            livingentity.m_6469_(TensuraDamageSources.unicornHorn(this, this.m_37282_()), f1);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 17 && this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19796_.m_188503_(3) + 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.05, 0.005, this.f_19796_.m_188583_() * 0.05);
            }
        }
        super.m_7822_(pId);
    }
}

