/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.variant;

import com.github.manasmods.tensura.entity.GoblinEntity;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class GoblinVariant {

    public static enum Bottom {
        SHORTS(0, "shorts_white"),
        PANTS(1, "pants_white"),
        PANTS_TORN_RIGHT(2, "pants_torn_right"),
        PANTS_TORN_LEFT(3, "pants_torn_left");

        private static final Bottom[] BY_ID;
        private final int id;
        private final String location;

        private Bottom(int id, String name) {
            this.id = id;
            this.location = name;
        }

        public static ResourceLocation getTextureLocation(GoblinEntity entity) {
            return new ResourceLocation("tensura", "textures/entity/goblin/unisex/bottom/legs_" + entity.getBottom().getLocation() + ".png");
        }

        public static Bottom byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public static int getRandom(GoblinEntity entity) {
            return ((Bottom)((Object)Util.m_214670_((Object[])Bottom.values(), (RandomSource)entity.m_217043_()))).getId();
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        static {
            BY_ID = (Bottom[])Arrays.stream(Bottom.values()).sorted(Comparator.comparingInt(Bottom::getId)).toArray(Bottom[]::new);
        }
    }

    public static enum Top {
        T_SHIRT(0, "tshirt_white"),
        VEST(1, "vest_white"),
        V_BROKEN_RIGHT(2, "vest_broken_right_white"),
        V_BROKEN_LEFT(3, "vest_broken_left_white");

        private static final Top[] BY_ID;
        private final int id;
        private final String location;

        private Top(int id, String name) {
            this.id = id;
            this.location = name;
        }

        public static ResourceLocation getTextureLocation(GoblinEntity entity) {
            return new ResourceLocation("tensura", "textures/entity/goblin/unisex/top/chest_" + entity.getTop().getLocation() + ".png");
        }

        public static Top byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public static int getRandom(GoblinEntity entity) {
            return ((Top)((Object)Util.m_214670_((Object[])Top.values(), (RandomSource)entity.m_217043_()))).getId();
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        static {
            BY_ID = (Top[])Arrays.stream(Top.values()).sorted(Comparator.comparingInt(Top::getId)).toArray(Top[]::new);
        }
    }

    public static enum Head {
        WHITE(0, "white"),
        WHITE_FULL(1, "full_white");

        private static final Head[] BY_ID;
        private final int id;
        private final String location;

        private Head(int id, String name) {
            this.id = id;
            this.location = name;
        }

        public static ResourceLocation getTextureLocation(GoblinEntity entity) {
            return new ResourceLocation("tensura", "textures/entity/goblin/unisex/head/head_bandana_" + entity.getHead().getLocation() + ".png");
        }

        public static Head byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public static int getRandom(GoblinEntity entity) {
            return ((Head)((Object)Util.m_214670_((Object[])Head.values(), (RandomSource)entity.m_217043_()))).getId();
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        static {
            BY_ID = (Head[])Arrays.stream(Head.values()).sorted(Comparator.comparingInt(Head::getId)).toArray(Head[]::new);
        }
    }

    public static enum Clothing {
        GREY(0, "_grey"),
        TAN(1, "_tan"),
        BROWN(2, "_brown"),
        BLACK(3, "_black"),
        DARK_GREY(4, "_dark_grey"),
        WHITE(5, "_white");

        private static final Clothing[] BY_ID;
        private final int id;
        private final String location;

        private Clothing(int id, String name) {
            this.id = id;
            this.location = name;
        }

        public static ResourceLocation getTextureLocation(GoblinEntity entity) {
            String gender = entity.getGender().getLocation();
            return new ResourceLocation("tensura", "textures/entity/goblin/" + gender + "/clothing/loin_" + gender + entity.getClothing().getLocation() + ".png");
        }

        public static Clothing byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public static int getRandom(GoblinEntity entity) {
            return ((Clothing)((Object)Util.m_214670_((Object[])Clothing.values(), (RandomSource)entity.m_217043_()))).getId();
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        static {
            BY_ID = (Clothing[])Arrays.stream(Clothing.values()).sorted(Comparator.comparingInt(Clothing::getId)).toArray(Clothing[]::new);
        }
    }

    public static enum Hair {
        BANDANA_BLACK(0, "bandana_black_"),
        BANDANA_BROWN(1, "bandana_brown_"),
        BANDANA_GREY(2, "bandana_grey_"),
        BANDANA_WHITE(3, "bandana_white_"),
        LONG_BLACK(4, "long_black_"),
        LONG_BROWN(5, "long_brown_"),
        LONG_GREY(6, "long_grey_"),
        LONG_WHITE(7, "long_white_"),
        SHORT_BLACK(8, "short_black_"),
        SHORT_BROWN(9, "short_brown_"),
        SHORT_GREY(10, "short_grey_"),
        SHORT_WHITE(11, "short_white_");

        private static final Hair[] BY_ID;
        private final int id;
        private final String location;

        private Hair(int id, String name) {
            this.id = id;
            this.location = name;
        }

        public static ResourceLocation getTextureLocation(GoblinEntity entity) {
            String gender = entity.getGender().getLocation();
            return new ResourceLocation("tensura", "textures/entity/goblin/" + gender + "/hair/" + entity.getHair().getLocation() + gender + ".png");
        }

        public static Hair byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public static int getRandom(GoblinEntity entity) {
            return ((Hair)((Object)Util.m_214670_((Object[])Hair.values(), (RandomSource)entity.m_217043_()))).getId();
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        static {
            BY_ID = (Hair[])Arrays.stream(Hair.values()).sorted(Comparator.comparingInt(Hair::getId)).toArray(Hair[]::new);
        }
    }

    public static enum Face {
        FACE_A(0, "unisex/face/face_a", Gender.OTHER),
        FACE_B(1, "unisex/face/face_b", Gender.OTHER),
        FACE_C(2, "male/face/face_c", Gender.MALE),
        FACE_D(3, "unisex/face/face_d", Gender.OTHER),
        FACE_E(4, "unisex/face/face_e", Gender.OTHER);

        private static final Face[] BY_ID;
        private static final List<Integer> MALE_LIST;
        private static final List<Integer> FEMALE_LIST;
        private final int id;
        private final String location;
        private final Gender gender;

        private Face(int id, String name, Gender gender) {
            this.id = id;
            this.location = name;
            this.gender = gender;
        }

        public ResourceLocation getTextureLocation() {
            return new ResourceLocation("tensura", "textures/entity/goblin/" + this.getLocation() + ".png");
        }

        public static Face byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public static int getRandom(Gender gender, GoblinEntity entity) {
            if (gender.equals((Object)Gender.FEMALE)) {
                return FEMALE_LIST.get(entity.m_217043_().m_188503_(FEMALE_LIST.size()));
            }
            return MALE_LIST.get(entity.m_217043_().m_188503_(MALE_LIST.size()));
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public Gender getGender() {
            return this.gender;
        }

        static {
            BY_ID = (Face[])Arrays.stream(Face.values()).sorted(Comparator.comparingInt(Face::getId)).toArray(Face[]::new);
            MALE_LIST = Arrays.stream(Face.values()).filter(skin -> skin.getGender() != Gender.FEMALE).map(Face::getId).toList();
            FEMALE_LIST = Arrays.stream(Face.values()).filter(skin -> skin.getGender() != Gender.MALE).map(Face::getId).toList();
        }
    }

    public static enum Skin {
        MEDIUM(0, "mid_"),
        LIGHT(1, "light_"),
        DARK(2, "dark_");

        private static final Skin[] BY_ID;
        private final int id;
        private final String location;

        private Skin(int id, String name) {
            this.id = id;
            this.location = name;
        }

        public static ResourceLocation getTextureLocation(GoblinEntity entity) {
            String gender = entity.getGender().getLocation();
            return new ResourceLocation("tensura", "textures/entity/goblin/" + gender + "/skin/" + entity.getSkin().getLocation() + gender + ".png");
        }

        public static Skin byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public static int getRandom(GoblinEntity entity) {
            return ((Skin)((Object)Util.m_214670_((Object[])Skin.values(), (RandomSource)entity.m_217043_()))).getId();
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        static {
            BY_ID = (Skin[])Arrays.stream(Skin.values()).sorted(Comparator.comparingInt(Skin::getId)).toArray(Skin[]::new);
        }
    }

    public static enum Gender {
        MALE(0, "male"),
        FEMALE(1, "female"),
        OTHER(2, "unisex");

        private static final Gender[] BY_ID;
        private final int id;
        private final String location;

        private Gender(int id, String location) {
            this.id = id;
            this.location = location;
        }

        public static Gender byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        static {
            BY_ID = (Gender[])Arrays.stream(Gender.values()).sorted(Comparator.comparingInt(Gender::getId)).toArray(Gender[]::new);
        }
    }
}

