/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.data.pack.EntityEPCount;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.event.NamingEvent;
import com.github.manasmods.tensura.event.SpiritLevelUpdateEvent;
import com.github.manasmods.tensura.event.UpdateEPEvent;
import com.github.manasmods.tensura.menu.RaceSelectionMenu;
import com.github.manasmods.tensura.network.play2server.RequestNamingGUIPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEPHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void initialEP(EntityJoinLevelEvent e) {
        if (e.getLevel().m_5776_()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (TensuraEPCapability.getEP(living) > 0.0) {
            return;
        }
        if (living instanceof Player) {
            return;
        }
        RaceHelper.updateSpiritualHP(living);
        TensuraEPCapability.getFrom(living).ifPresent(cap -> {
            if (living.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
                cap.setMajin(true);
            }
            for (EntityEPCount entityEP : TensuraData.getEntityEP()) {
                AttributeInstance aura;
                if (!entityEP.getEntity().equals((Object)EntityType.m_20613_((EntityType)living.m_6095_()))) continue;
                int minEP = entityEP.getMinEP();
                int maxEP = entityEP.getMaxEP() <= minEP ? minEP + 1 : entityEP.getMaxEP() + 1;
                double energy = living.m_217043_().m_216339_(0, maxEP - minEP);
                AttributeInstance magicule = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                if (magicule != null) {
                    magicule.m_22100_((double)((float)minEP / 2.0f));
                    energy += magicule.m_22135_();
                }
                if ((aura = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) != null) {
                    aura.m_22100_((double)((float)minEP / 2.0f));
                    energy += aura.m_22135_();
                }
                cap.setEP(living, energy);
                for (ResourceLocation skillID : entityEP.getSkills()) {
                    ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillID);
                    if (skill == null) continue;
                    TensuraSkillInstance instance = new TensuraSkillInstance(skill);
                    SkillAPI.getSkillsFrom((Entity)living).learnSkill((ManasSkillInstance)instance);
                    if (!instance.canBeToggled(living)) continue;
                    instance.setToggled(true);
                }
                RaceSelectionMenu.grantLearningResistance(living);
                break;
            }
            if (cap.getEP() <= 0.0) {
                AttributeInstance aura;
                double energy = 100.0f * living.m_21233_();
                AttributeInstance magicule = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                if (magicule != null) {
                    energy += magicule.m_22135_();
                }
                if ((aura = living.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) != null) {
                    energy += aura.m_22135_();
                }
                cap.setEP(living, energy);
            }
        });
    }

    @SubscribeEvent
    public static void onUpdateEP(UpdateEPEvent e) {
        double newEP;
        double oldEP = e.getOldEP();
        if (oldEP >= (newEP = e.getNewEP())) {
            return;
        }
        LivingEntity entity = e.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        int humanKill = (Integer)TensuraConfig.INSTANCE.awakeningConfig.massNamingHuman.get();
        if (!(entity instanceof ServerPlayer)) {
            if (oldEP != 0.0) {
                EntityEPHandler.addStatOnEPGain(entity, newEP - oldEP);
            }
            if (TensuraEPCapability.getHumanKill(entity) >= humanKill && TensuraEPCapability.getName(entity) == null) {
                RequestNamingGUIPacket.name(entity, null, RequestNamingGUIPacket.NamingType.LOW, String.valueOf(entity.m_7755_()));
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (TensuraEPCapability.isNameable((LivingEntity)player) && (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12950_)) >= (Integer)TensuraConfig.INSTANCE.awakeningConfig.massNamingRaid.get() || TensuraEPCapability.getHumanKill((LivingEntity)player) >= humanKill)) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.INFAMY_FAMOUS);
            if (TensuraEPCapability.getName((LivingEntity)player) == null) {
                RequestNamingGUIPacket.name((LivingEntity)player, null, RequestNamingGUIPacket.NamingType.LOW, player.m_7755_().getString());
            }
        }
        if (newEP >= 1000.0) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.D_RANK);
        }
        if (newEP >= 3000.0) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.C_RANK);
        }
        if (newEP >= 6000.0) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.B_RANK);
        }
        if (newEP >= 10000.0) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.A_RANK);
        }
        if (newEP >= 100000.0) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.SA_RANK);
        }
        if (newEP >= 400000.0) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.S_RANK);
        }
        if (newEP >= 800000.0) {
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.SS_RANK);
        }
        if (newEP > TensuraPlayerCapability.getBaseEP((Player)player)) {
            return;
        }
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            if (TensuraEPCapability.isMajin((LivingEntity)player) && !cap.isTrueHero() && !cap.isDemonLordSeed() && !cap.isTrueDemonLord() && newEP >= (double)level.m_46469_().m_46215_(TensuraGameRules.DEMON_LORD_SEED)) {
                cap.setDemonLordSeed(true);
                player.m_5661_((Component)Component.m_237115_((String)"tensura.evolve.demon_lord.seed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
        for (ManasSkill manasSkill : SkillAPI.getSkillRegistry().getValues()) {
            if (!(manasSkill instanceof TensuraSkill)) continue;
            TensuraSkill skill = (TensuraSkill)manasSkill;
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
            if (storage.getSkill((ManasSkill)skill).isPresent() || !skill.meetEPRequirement((Player)player, newEP)) continue;
            TensuraSkillInstance instance = new TensuraSkillInstance(skill);
            instance.setMastery(skill.getMasteryOnEPAcquirement((Player)player));
            if (!storage.learnSkill((ManasSkillInstance)instance)) continue;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    @SubscribeEvent
    public static void mpRestoreOnWake(PlayerWakeUpEvent e) {
        Player player = e.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (e.wakeImmediately() || e.updateLevel()) {
            return;
        }
        if (player.m_9236_().m_46470_()) {
            return;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get())) {
            player.m_21195_((MobEffect)TensuraMobEffects.RAMPAGE.get());
        }
        TensuraEPCapability.setSpiritualHealth((LivingEntity)player, player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
            if (cap.getMagicule() < maxMP) {
                double newMagicule = cap.getMagicule() + (double)Math.round(maxMP / 6.0);
                cap.setMagicule(Math.min(newMagicule, maxMP));
            }
        });
    }

    private static void addStatOnEPGain(LivingEntity entity, double difference) {
        TensuraEPCapability.getFrom(entity).ifPresent(cap -> {
            cap.setGainedEP(cap.getGainedEP() + difference);
            double gainedEP = cap.getGainedEP();
            double points = (int)gainedEP / 10000;
            if (points > 0.0) {
                AttributeInstance SHP;
                AttributeInstance HP;
                AttributeInstance attack;
                cap.setGainedEP(gainedEP - points * 10000.0);
                AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
                if (armor != null) {
                    armor.m_22100_(armor.m_22115_() + points);
                }
                if ((attack = entity.m_21051_(Attributes.f_22281_)) != null) {
                    attack.m_22100_(attack.m_22115_() + points);
                }
                if ((HP = entity.m_21051_(Attributes.f_22276_)) != null) {
                    HP.m_22100_(HP.m_22115_() + points * 10.0);
                }
                if ((SHP = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())) != null) {
                    SHP.m_22100_(SHP.m_22115_() + points * 20.0);
                }
                entity.m_5634_((float)points * 10.0f);
            }
            TensuraEPCapability.sync(entity);
        });
    }

    @SubscribeEvent
    public static void onUpdateSpiritLevel(SpiritLevelUpdateEvent e) {
        Player player = e.getEntity();
        MagicElemental elemental = e.getElemental();
        SpiritualMagic.SpiritLevel level = e.getSpiritLevel();
        if (MagicElemental.getCommonElementals().contains((Object)elemental)) {
            if (level.getId() >= 2) {
                SkillAPI.getSkillsFrom((Entity)player).learnSkill((ManasSkillInstance)new TensuraSkillInstance((ManasSkill)SpiritualMagics.SUMMON_MEDIUM_ELEMENTAL.get()));
            }
            if (level.getId() >= 3) {
                SkillAPI.getSkillsFrom((Entity)player).learnSkill((ManasSkillInstance)new TensuraSkillInstance((ManasSkill)SpiritualMagics.SUMMON_GREATER_ELEMENTAL.get()));
            }
        }
        int greaterLevel = (Integer)TensuraConfig.INSTANCE.awakeningConfig.heroSpiritLevel.get();
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            int greater = 0;
            for (MagicElemental magicElemental : MagicElemental.values()) {
                if (cap.getSpiritLevel(magicElemental.getId()) >= greaterLevel) {
                    ++greater;
                    continue;
                }
                if (magicElemental.getId() != elemental.getId() || level.getId() < greaterLevel) continue;
                ++greater;
            }
            if (greater >= 7 && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.BLESSED_ONE);
            }
            if (greater < (Integer)TensuraConfig.INSTANCE.awakeningConfig.heroSpiritNumber.get()) {
                return;
            }
            TensuraPlayerCapability.getFrom(player).ifPresent(playerCap -> {
                Race race = playerCap.getRace();
                if (race == null) {
                    return;
                }
                if (race.isMajin() && !TensuraEPCapability.isChaos((LivingEntity)player)) {
                    return;
                }
                if (playerCap.isHeroEgg()) {
                    return;
                }
                if (playerCap.isTrueHero()) {
                    return;
                }
                if (playerCap.isTrueDemonLord()) {
                    return;
                }
                playerCap.setHeroEgg(true);
                player.m_5661_((Component)Component.m_237115_((String)"tensura.evolve.hero.egg").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ManasSkill skill = (ManasSkill)IntrinsicSkills.EYE_OF_TRUTH.get();
                if (SkillUtils.learnSkill((LivingEntity)player, skill)) {
                    playerCap.addIntrinsicSkill(skill);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                TensuraPlayerCapability.sync(player);
            });
        });
    }

    @SubscribeEvent
    public static void onNaming(NamingEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity instanceof IRanking) {
            IRanking ranking = (IRanking)entity;
            ranking.onNamed(e);
        }
    }
}

