/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.AvoidFearedEntityGoal;
import com.github.manasmods.tensura.api.entity.ai.AvoidMagicEngineGoal;
import com.github.manasmods.tensura.api.entity.ai.FollowSwarmLeaderGoal;
import com.github.manasmods.tensura.api.entity.ai.PassiveMeleeAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.TensuraOwnerHurtByTargetGoal;
import com.github.manasmods.tensura.api.entity.ai.TensuraOwnerHurtGoal;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.GiantCodEntity;
import com.github.manasmods.tensura.entity.GiantSalmonEntity;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.registry.entity.TensuraVillagers;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.items.TensuraSmithingSchematicItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityGoalHandler {
    @SubscribeEvent
    public static void onJoinWorld(EntityJoinLevelEvent e) {
        Cod cod;
        if (e.getLevel().m_5776_()) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof Salmon) {
            Salmon salmon = (Salmon)entity;
            salmon.f_21345_.m_25352_(6, (Goal)new FollowSwarmLeaderGoal((AbstractSchoolingFish)salmon, GiantSalmonEntity.class));
        } else {
            entity = e.getEntity();
            if (entity instanceof Cod) {
                cod = (Cod)entity;
                cod.f_21345_.m_25352_(6, (Goal)new FollowSwarmLeaderGoal((AbstractSchoolingFish)cod, GiantCodEntity.class));
            }
        }
        cod = e.getEntity();
        if (cod instanceof Mob) {
            Mob mob = (Mob)cod;
            if (mob instanceof PathfinderMob) {
                PathfinderMob entity2 = (PathfinderMob)mob;
                if (mob.m_21051_(Attributes.f_22281_) == null) {
                    boolean addMelee = true;
                    for (WrappedGoal goal : mob.f_21345_.m_148105_()) {
                        if (!(goal.m_26015_() instanceof TargetGoal)) continue;
                        addMelee = false;
                    }
                    if (addMelee) {
                        float speed = entity2 instanceof Villager ? 0.75f : 1.5f;
                        mob.f_21345_.m_25352_(2, (Goal)new PassiveMeleeAttackGoal(entity2, speed, false));
                    }
                }
                if (!mob.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_FEAR)) {
                    mob.f_21345_.m_25352_(0, (Goal)new AvoidFearedEntityGoal(entity2, 30.0f, 1.5, 2.0));
                }
                if (mob.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
                    mob.f_21345_.m_25352_(0, (Goal)new AvoidMagicEngineGoal(entity2, 27.0f, 1.0, 1.5));
                    mob.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal(entity2, HinataSakaguchiEntity.class, 40.0f, 1.0, 3.0));
                }
            }
            mob.f_21345_.m_25352_(1, (Goal)new TensuraOwnerHurtByTargetGoal(mob));
            mob.f_21345_.m_25352_(1, (Goal)new TensuraOwnerHurtGoal(mob));
        }
    }

    @SubscribeEvent
    public static void onCodHurt(LivingHurtEvent e) {
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Cod)) {
            return;
        }
        Cod cod = (Cod)livingEntity;
        if (cod.f_19853_.m_5776_()) {
            return;
        }
        Entity entity = e.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity damageSource = (LivingEntity)entity;
        if (!damageSource.m_6084_()) {
            return;
        }
        if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
            return;
        }
        List giantCods = cod.f_19853_.m_45976_(GiantCodEntity.class, cod.m_20191_().m_82400_((double)((Integer)SpawnRateConfig.INSTANCE.giantFishAwarenessRange.get()).intValue()));
        giantCods.forEach(giantCod -> {
            if (SkillHelper.isSubordinate(damageSource, (LivingEntity)giantCod)) {
                return;
            }
            giantCod.m_6710_(damageSource);
        });
    }

    @SubscribeEvent
    public static void onSalmonHurt(LivingHurtEvent e) {
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Salmon)) {
            return;
        }
        Salmon salmon = (Salmon)livingEntity;
        if (salmon.f_19853_.m_5776_()) {
            return;
        }
        Entity entity = e.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity damageSource = (LivingEntity)entity;
        if (!damageSource.m_6084_()) {
            return;
        }
        if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
            return;
        }
        List giantSalmons = salmon.f_19853_.m_45976_(GiantSalmonEntity.class, salmon.m_20191_().m_82400_((double)((Integer)SpawnRateConfig.INSTANCE.giantFishAwarenessRange.get()).intValue()));
        giantSalmons.forEach(giantSalmon -> {
            if (SkillHelper.isSubordinate(damageSource, (LivingEntity)giantSalmon)) {
                return;
            }
            giantSalmon.m_6710_(damageSource);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDragonDeath(LivingDeathEvent e) {
        if (e.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        if (dragon.f_19853_.m_5776_()) {
            return;
        }
        if (!dragon.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            return;
        }
        dragon.m_19998_((ItemLike)TensuraMobDropItems.DRAGON_ESSENCE.get());
    }

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades;
        if (event.getType() == VillagerProfession.f_35588_) {
            trades = event.getTrades();
            TreasureMapForHighCrystals labyrinthMap = new TreasureMapForHighCrystals(40, 64, TensuraTags.Structures.ON_LABYRINTH_EXPLORER_MAPS, "tensura.map.labyrinth", MapDecoration.Type.RED_X, 1, 5, (Double)TensuraConfig.INSTANCE.entitiesConfig.labyrinthMapChance.get());
            ((List)trades.get(5)).add(labyrinthMap);
            TreasureMapForHighCrystals hellGateMap = new TreasureMapForHighCrystals(40, 64, TensuraTags.Structures.ON_HELL_GATE_EXPLORER_MAPS, "tensura.map.hell_gate", MapDecoration.Type.RED_X, 1, 5, (Double)TensuraConfig.INSTANCE.entitiesConfig.hellGateMapChance.get());
            ((List)trades.get(5)).add(hellGateMap);
        }
        if (event.getType() == TensuraVillagers.GEARSMITH.get()) {
            trades = event.getTrades();
            int emeraldsPrice = 7;
            EntityGoalHandler.addSingleTrade(1, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.SILVER_INGOT.get(), (ItemLike)Items.f_42616_, 4, 1, 32, 2, 0.9f);
            EntityGoalHandler.addDoubleTrade(1, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)Items.f_42454_, (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.LEATHER_GEAR.get(), 1, emeraldsPrice, 1, 8, 2, 0.9f);
            EntityGoalHandler.addDoubleTrade(1, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)Items.f_42416_, (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.IRON_GEAR.get(), 1, emeraldsPrice, 1, 8, 2, 0.9f);
            EntityGoalHandler.addDoubleTrade(1, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)Items.f_42417_, (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.GOLD_GEAR.get(), 1, emeraldsPrice, 1, 8, 2, 0.9f);
            EntityGoalHandler.addDoubleTrade(1, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.SILVER_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.SILVER_GEAR.get(), 1, emeraldsPrice, 1, 8, 2, 0.9f);
            emeraldsPrice = 12;
            EntityGoalHandler.addSingleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.LOW_QUALITY_MAGIC_CRYSTAL.get(), (ItemLike)Items.f_42616_, 10, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.MONSTER_LEATHER_A.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.MONSTER_LEATHER_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.MONSTER_LEATHER_B.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.MONSTER_LEATHER_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.MONSTER_LEATHER_C.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.MONSTER_LEATHER_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.MONSTER_LEATHER_D.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.MONSTER_LEATHER_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.MONSTER_LEATHER_SPECIAL_A.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.MONSTER_LEATHER_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.KNIGHT_SPIDER_CARAPACE.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.KNIGHT_SPIDER_CARAPACE_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.GIANT_ANT_CARAPACE.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.ANT_CARAPACE_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            EntityGoalHandler.addDoubleTrade(2, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.SERPENT_SCALE.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.SERPENT_SCALEMAIL_GEAR.get(), 1, emeraldsPrice, 1, 32, 3, 0.9f);
            emeraldsPrice = 25;
            EntityGoalHandler.addSingleTrade(3, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.MEDIUM_QUALITY_MAGIC_CRYSTAL.get(), (ItemLike)Items.f_42616_, 5, 1, 32, 4, 0.9f);
            EntityGoalHandler.addDoubleTrade(3, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)Items.f_42415_, (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.DIAMOND_GEAR.get(), 1, emeraldsPrice, 1, 32, 4, 0.9f);
            EntityGoalHandler.addDoubleTrade(3, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.LOW_MAGISTEEL_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.LOW_MAGISTEEL_GEAR.get(), 1, emeraldsPrice, 1, 32, 4, 0.9f);
            EntityGoalHandler.addDoubleTrade(3, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.HIGH_MAGISTEEL_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.HIGH_MAGISTEEL_GEAR.get(), 1, emeraldsPrice, 1, 32, 4, 0.9f);
            EntityGoalHandler.addDoubleTrade(3, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.ARMOURSAURUS_SHELL.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.ARMOURSAURUS_SCALEMAIL_GEAR.get(), 1, emeraldsPrice, 1, 32, 4, 0.9f);
            emeraldsPrice = 36;
            EntityGoalHandler.addSingleTrade(4, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.HIGH_QUALITY_MAGIC_CRYSTAL.get(), (ItemLike)Items.f_42616_, 2, 1, 32, 5, 0.9f);
            EntityGoalHandler.addDoubleTrade(4, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.MITHRIL_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.MITHRIL_GEAR.get(), 1, emeraldsPrice, 1, 32, 5, 0.9f);
            EntityGoalHandler.addDoubleTrade(4, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.ORICHALCUM_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.ORICHALCUM_GEAR.get(), 1, emeraldsPrice, 1, 32, 5, 0.9f);
            EntityGoalHandler.addDoubleTrade(4, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.PURE_MAGISTEEL_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.PURE_MAGISTEEL_GEAR.get(), 1, emeraldsPrice, 1, 32, 5, 0.9f);
            EntityGoalHandler.addDoubleTrade(4, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMobDropItems.CHARYBDIS_SCALE.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.CHARYBDIS_SCALEMAIL_GEAR.get(), 1, emeraldsPrice, 1, 32, 5, 0.9f);
            emeraldsPrice = 49;
            EntityGoalHandler.addDoubleTrade(5, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.ADAMANTITE_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.ADAMANTITE_GEAR.get(), 1, emeraldsPrice, 1, 32, 6, 0.9f);
            EntityGoalHandler.addDoubleTrade(5, (Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (ItemLike)TensuraMaterialItems.HIHIIROKANE_INGOT.get(), (ItemLike)Items.f_42616_, (ItemLike)TensuraSmithingSchematicItems.HIHIIROKANE_GEAR.get(), 1, emeraldsPrice, 1, 32, 6, 0.9f);
        }
    }

    private static void addSingleTrade(int villagerLevel, Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, ItemLike what, ItemLike forWhat, int consumeCount, int receiveCount, int maxUses, int xp, float multiplier) {
        ((List)trades.get(villagerLevel)).add((trader, random) -> new MerchantOffer(new ItemStack(what, consumeCount), new ItemStack(forWhat, receiveCount), maxUses, xp, multiplier));
    }

    private static void addDoubleTrade(int villagerLevel, Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, ItemLike what1, ItemLike what2, ItemLike forWhat, int consumeCount1, int consumeCount2, int receiveCount, int maxUses, int xp, float multiplier) {
        ((List)trades.get(villagerLevel)).add((trader, random) -> new MerchantOffer(new ItemStack(what1, consumeCount1), new ItemStack(what2, consumeCount2), new ItemStack(forWhat, receiveCount), maxUses, xp, multiplier));
    }

    static class TreasureMapForHighCrystals
    implements VillagerTrades.ItemListing {
        private final int costMin;
        private final int costMax;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;
        private final double chance;

        public TreasureMapForHighCrystals(int pEmeraldCostMin, int pEmeraldCostMax, TagKey<Structure> pDestination, String pDisplayName, MapDecoration.Type pDestinationType, int pMaxUses, int pVillagerXp, double chance) {
            this.costMin = pEmeraldCostMin;
            this.costMax = pEmeraldCostMax;
            this.destination = pDestination;
            this.displayName = pDisplayName;
            this.destinationType = pDestinationType;
            this.maxUses = pMaxUses;
            this.villagerXp = pVillagerXp;
            this.chance = chance;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity pTrader, RandomSource pRandom) {
            Level level = pTrader.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel level2 = (ServerLevel)level;
            if ((double)pRandom.m_188501_() >= this.chance) {
                return null;
            }
            BlockPos pos = level2.m_215011_(this.destination, pTrader.m_20183_(), 100, true);
            if (pos == null) {
                return null;
            }
            ItemStack map = MapItem.m_42886_((Level)level2, (int)pos.m_123341_(), (int)pos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)level2, (ItemStack)map);
            MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)pos, (String)"+", (MapDecoration.Type)this.destinationType);
            map.m_41714_((Component)Component.m_237115_((String)this.displayName));
            return new MerchantOffer(new ItemStack((ItemLike)TensuraMobDropItems.HIGH_QUALITY_MAGIC_CRYSTAL.get(), pRandom.m_216339_(this.costMin, this.costMax)), new ItemStack((ItemLike)Items.f_42522_), map, this.maxUses, this.villagerXp, 0.2f);
        }
    }
}

