/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.world.chunk.LevelChunkTickEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.api.magicule.MagiculeAPI;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.magicule.MagiculeChunkCapability;
import com.github.manasmods.tensura.capability.magicule.MagiculeChunkCapabilityImpl;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.effect.InsanityEffect;
import com.github.manasmods.tensura.entity.ElementalColossusEntity;
import com.github.manasmods.tensura.entity.magic.misc.WarpPortalEntity;
import com.github.manasmods.tensura.event.EnergyRegenerateTickEvent;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestDimensionUpdatePacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.github.manasmods.tensura.world.savedata.LabyrinthSaveData;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OnTickHandler {
    public static final int SLEEP_TICK = 20;
    public static final int ENERGY_REGEN = 10;
    public static final int SPIRITUAL_REGEN = 20;

    @SubscribeEvent
    static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (player.f_19797_ % 10 != 0) {
            return;
        }
        if (player.f_19797_ % 20 == 0) {
            OnTickHandler.respawnColossus(player, player.m_9236_());
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                if (cap.getSpiritCooldown() == 0) {
                    return;
                }
                cap.setSpiritCooldown(Math.max(0, cap.getSpiritCooldown() - 1));
                TensuraSkillCapability.sync(player);
            });
        }
        TensuraEffectsCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
            float height = RaceHelper.getSkillSizeMultiplier((LivingEntity)player);
            if (height == cap.getHeightUpdate()) {
                return;
            }
            cap.setHeightUpdate(height);
            player.m_6210_();
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new RequestDimensionUpdatePacket(player.m_19879_()));
            TensuraEffectsCapability.sync((LivingEntity)player);
        });
    }

    @SubscribeEvent
    static void onTick(LivingEvent.LivingTickEvent event) {
        ServerPlayer player;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_7654_() == null) {
            return;
        }
        OnTickHandler.fallOffLabyrinth(entity, level);
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            InsanityEffect.onServerTick(player);
        }
        if (level.m_7654_().m_129921_() % 20 == 0) {
            Race race;
            OnTickHandler.spiritualRegeneration(entity);
            if (entity instanceof Player && (race = TensuraPlayerCapability.getRace((LivingEntity)(player = (Player)entity))) != null) {
                race.raceTick((Player)player);
            }
        }
        if (level.m_7654_().m_129921_() % 10 != 0) {
            return;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new EnergyRegenerateTickEvent(entity))) {
            OnTickHandler.energyRegen(entity);
        }
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
            if (cap.getWarpPortalTime() <= 0) {
                return;
            }
            List list = level.m_6443_(WarpPortalEntity.class, entity.m_20191_().m_82400_((double)0.2f), portal -> portal.f_19797_ > 20 || portal.getDestination() != null);
            if (!list.isEmpty()) {
                return;
            }
            cap.setWarpPortalTime(-1);
            TensuraEffectsCapability.sync(entity);
        });
    }

    private static void spiritualRegeneration(LivingEntity entity) {
        Player player;
        Race race;
        double multiplier = entity instanceof Player ? ((race = TensuraPlayerCapability.getRace((LivingEntity)(player = (Player)entity))) != null ? race.getSpiritualHealthMultiplier() : 1.0) : (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.HERO_BOSS) ? 10.0 : (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.SPIRITUAL) ? 5.0 : 1.0));
        TensuraEPCapability.healSpiritualHealth(entity, 2.0 * multiplier);
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
            if (cap.getSeveranceAmount() <= 0.0) {
                return;
            }
            if ((Integer)TensuraConfig.INSTANCE.skillsConfig.severanceRemoveSec.get() == -1) {
                return;
            }
            cap.setSeveranceRemoveSec(cap.getSeveranceRemoveSec() - 1);
            if (cap.getSeveranceRemoveSec() <= 0) {
                cap.setSeveranceAmount(0.0);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123760_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123760_, 2.0);
            }
        });
    }

    private static void fallOffLabyrinth(LivingEntity entity, Level level) {
        Player player;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (level.m_46472_() != TensuraDimensions.LABYRINTH) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return;
        }
        if ((double)entity.m_20097_().m_123342_() > LabyrinthSaveData.get(serverLevel.m_7654_().m_129783_()).getStartFallOffY()) {
            return;
        }
        entity.m_183634_();
        entity.m_19877_();
        entity.m_20219_(LabyrinthSaveData.get(serverLevel.m_7654_().m_129783_()).getFallOffPos());
        entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
    }

    private static void respawnColossus(Player player, Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (level.m_46472_() != TensuraDimensions.LABYRINTH) {
            return;
        }
        if (!serverLevel.m_46469_().m_46207_(TensuraGameRules.COLOSSUS_RESPAWN)) {
            return;
        }
        LabyrinthSaveData saveData = LabyrinthSaveData.get(serverLevel.m_7654_().m_129783_());
        if (saveData.isHavingColossus()) {
            return;
        }
        if (TensuraEffectsCapability.isColossusWon((LivingEntity)player)) {
            return;
        }
        Vec3 colossusPos = saveData.getColossusPos();
        if (player.m_20238_(colossusPos) > 1600.0) {
            return;
        }
        ElementalColossusEntity colossus = new ElementalColossusEntity(serverLevel, colossusPos, MobSpawnType.TRIGGERED);
        level.m_7967_((Entity)colossus);
        saveData.setHavingColossus(true);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)colossus, (ParticleOptions)ParticleTypes.f_123812_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)colossus, (ParticleOptions)ParticleTypes.f_123767_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)colossus, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
        colossus.m_9236_().m_6263_(null, colossus.m_20185_(), colossus.m_20186_(), colossus.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 2.0f, 1.0f);
        colossus.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @SubscribeEvent
    static void onChunkTick(LevelChunkTickEvent e) {
        LevelChunk chunk = e.getChunk();
        if (chunk.m_62953_().m_5776_()) {
            return;
        }
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        MagiculeChunkCapability cap = MagiculeChunkCapabilityImpl.get(chunk);
        ((MagiculeChunkCapabilityImpl)cap).tick();
    }

    public static void energyRegen(LivingEntity entity) {
        if (!(entity instanceof ServerPlayer)) {
            TensuraEPCapability.getFrom(entity).ifPresent(cap -> {
                if (cap.getEP() < 0.0 || cap.getCurrentEP() < 0.0) {
                    entity.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, entity.m_21233_() * 10.0f);
                } else if (cap.getCurrentEP() < cap.getEP()) {
                    double mana = SkillHelper.mpRegen(entity, cap.getEP(), MagiculeAPI.getMagicule(entity) * 0.01);
                    double newEP = cap.getCurrentEP() + SkillHelper.apRegen(entity, cap.getEP(), 2.0) + mana;
                    cap.setCurrentEP(entity, Math.min(newEP, cap.getEP()));
                }
            });
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            if (cap.getRace() == null) {
                return;
            }
            if (!player.m_150110_().f_35934_ && (cap.getAura() < 0.0 || cap.getMagicule() < 0.0)) {
                player.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, player.m_21233_());
                return;
            }
            boolean shouldSync = false;
            if (cap.getSleepMode() > 0) {
                cap.setSleepMode(cap.getSleepMode() - 1);
                player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SLEEP_MODE.get(), 20, 0, false, false, false));
                shouldSync = true;
            } else if (player.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get())) {
                player.m_21195_((MobEffect)TensuraMobEffects.SLEEP_MODE.get());
            }
            if (cap.getMagicule() <= 0.0) {
                cap.setSleepMode(20);
                if (cap.getMagicule() < 0.0) {
                    player.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, player.m_21233_() * 10.0f);
                    return;
                }
            }
            double maxAura = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
            double maxMagicule = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
            int difference = (int)(MagiculeAPI.getMagicule((LivingEntity)player) / ((maxMagicule + maxAura) * 4.0));
            if (!(difference <= OnTickHandler.getMagiculePoisonResistance((Player)player) || player.m_5833_() || player.m_7500_() || player.m_9236_().m_46472_() == TensuraDimensions.HELL && cap.getRace().getRespawnDimension() == TensuraDimensions.HELL)) {
                player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGICULE_POISON.get(), 100, difference - 1, false, false));
            }
            if (cap.isSpiritualForm() && !player.m_7500_() && !player.m_5833_() && player.m_9236_().m_46472_() != TensuraDimensions.HELL && player.m_9236_().m_46472_() != TensuraDimensions.LABYRINTH) {
                cap.setMagicule(Math.max(cap.getMagicule() - 115.0, -1.0));
                shouldSync = true;
            } else {
                double mana = MagiculeAPI.getMagicule((LivingEntity)player) * (Double)TensuraConfig.INSTANCE.magiculeConfig.manaRegen.get();
                if (cap.getMagicule() > maxMagicule) {
                    if (cap.getMagicule() > maxMagicule * 1.25) {
                        double extraMP = cap.getMagicule() - maxMagicule * 1.25;
                        int poisonLevel = (int)(extraMP / (maxMagicule * 0.25));
                        player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGICULE_POISON.get(), 100, poisonLevel, false, false));
                    }
                    cap.setMagicule(Math.max(cap.getMagicule() - (Double)TensuraConfig.INSTANCE.magiculeConfig.auraRegen.get(), maxMagicule));
                    shouldSync = true;
                } else if (cap.getMagicule() < maxMagicule) {
                    double newMana = cap.getMagicule() + SkillHelper.mpRegen((LivingEntity)player, maxMagicule, mana);
                    cap.setMagicule(Math.min(newMana, maxMagicule));
                    shouldSync = true;
                }
            }
            if (cap.getAura() <= 0.0) {
                OnTickHandler.auraPenalties((Player)player);
            }
            if (cap.getAura() < maxAura) {
                double newAura = cap.getAura() + SkillHelper.apRegen((LivingEntity)player, maxAura, (Double)TensuraConfig.INSTANCE.magiculeConfig.auraRegen.get());
                cap.setAura(Math.min(newAura, maxAura));
                shouldSync = true;
            } else if (cap.getAura() > maxAura) {
                if (cap.getAura() > maxAura * 1.25) {
                    double extraAP = cap.getAura() - maxAura * 1.25;
                    int insaneLevel = 1 + 2 * (int)(extraAP / (maxAura * 0.25));
                    player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), 100, insaneLevel, false, false));
                }
                cap.setAura(Math.max(cap.getAura() - (Double)TensuraConfig.INSTANCE.magiculeConfig.auraRegen.get(), maxAura));
                shouldSync = true;
            }
            if (shouldSync) {
                TensuraPlayerCapability.sync((Player)player);
            }
        });
    }

    private static int getMagiculePoisonResistance(Player player) {
        int level = 0;
        if (TensuraEPCapability.isMajin((LivingEntity)player)) {
            ++level;
        }
        if (SkillUtils.isSkillToggled((Entity)player, (ManasSkill)ResistanceSkills.MAGIC_RESISTANCE.get())) {
            level += 2;
        }
        return level;
    }

    private static void auraPenalties(Player player) {
        player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FRAGILITY.get(), 100, 2, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 2, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2, false, false));
    }
}

