/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.unique.MercilessSkill;
import com.github.manasmods.tensura.api.magicule.MagiculeAPI;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.pack.GearEPCount;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.event.EnergyRegenerateTickEvent;
import com.github.manasmods.tensura.event.ItemDamageEvent;
import com.github.manasmods.tensura.menu.HumanoidNPCMenu;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WeaponEPHandler {
    @SubscribeEvent
    public static void onGearUseEP(ItemDamageEvent e) {
        ItemStack stack = e.getStack();
        if (stack.m_41741_() > 1) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        double durabilityEP = tag.m_128459_("DurabilityEP");
        int multiplier = 10;
        int regen = (int)Math.min(durabilityEP, (double)(e.getAmount() * multiplier));
        if (regen / multiplier <= 0) {
            return;
        }
        e.setAmount(e.getAmount() - regen / multiplier);
        tag.m_128347_("DurabilityEP", durabilityEP - (double)regen);
    }

    @SubscribeEvent
    public static void onGearRegenerateEP(EnergyRegenerateTickEvent e) {
        LivingEntity user = e.getEntity();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            double EP;
            CompoundTag tag;
            ItemStack stack = user.m_6844_(slot);
            if (stack.m_41741_() > 1 || (tag = stack.m_41783_()) == null || (EP = tag.m_128459_("EP")) <= 0.0 || user.f_20911_ && user instanceof Player && slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) continue;
            int damage = stack.m_41773_();
            double durabilityEP = tag.m_128459_("DurabilityEP");
            int multiplier = 10;
            int regen = (int)Math.min(durabilityEP, (double)(damage * multiplier));
            if (damage > 0 && regen / multiplier > 0) {
                stack.m_41721_(damage - regen / multiplier);
                tag.m_128347_("DurabilityEP", durabilityEP - (double)regen);
            } else if (durabilityEP < EP) {
                tag.m_128347_("DurabilityEP", Math.min(EP, durabilityEP + (double)((int)(MagiculeAPI.getMagicule(user) * 0.01))));
            }
            if (!(user instanceof HumanoidNPCEntity)) continue;
            HumanoidNPCEntity npc = (HumanoidNPCEntity)user;
            int id = HumanoidNPCMenu.getEquipmentSlotId(slot);
            if (!npc.inventory.m_8020_(id).m_150930_(stack.m_41720_())) continue;
            npc.inventory.m_6836_(HumanoidNPCMenu.getEquipmentSlotId(slot), stack);
            npc.inventory.m_6596_();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityKill(LivingDeathEvent e) {
        LivingEntity pTarget = e.getEntity();
        if (e.isCanceled() || pTarget.m_6084_()) {
            return;
        }
        TensuraEffectsCapability.resetEverything(pTarget, true, false);
        Entity pAttacker = e.getSource().m_7639_();
        if (pAttacker instanceof CloneEntity) {
            CloneEntity clone = (CloneEntity)pAttacker;
            pAttacker = clone.m_21826_();
        }
        if (!(pAttacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)pAttacker;
        if (pAttacker == pTarget) {
            return;
        }
        double EP = SkillUtils.getEPGain(pTarget, living, false);
        if (EP <= 0.0) {
            return;
        }
        if (TensuraEPCapability.isSkippingEPDrop(pTarget)) {
            return;
        }
        WeaponEPHandler.entityGetEP(living, pTarget, SkillUtils.getEPGain(pTarget, living, true));
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            WeaponEPHandler.gearGetEP(living, equipmentSlot, EP);
        }
    }

    protected static void entityGetEP(LivingEntity living, LivingEntity target, double totalEP) {
        double maxMP = living.m_9236_().m_46469_().m_46215_(TensuraGameRules.MAX_MP_GAIN);
        double maxAP = living.m_9236_().m_46469_().m_46215_(TensuraGameRules.MAX_AP_GAIN);
        if (living instanceof Player) {
            Player player = (Player)living;
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                Race race;
                if (cap.isDemonLordSeed()) {
                    double souls = SkillUtils.getEPGain(target, living, false) * (Double)TensuraConfig.INSTANCE.awakeningConfig.epToSoulRate.get() / 100.0;
                    souls = Math.min(souls, maxMP + maxAP);
                    cap.setSoulPoints((int)Math.min((double)cap.getSoulPoints() + souls, 2.147483647E9));
                    if (player.m_9236_().m_46469_().m_46207_(TensuraGameRules.RIMURU_MODE) && cap.getSoulPoints() >= 20000000 && SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)UniqueSkills.MERCILESS.get())) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{((MercilessSkill)((Object)((Object)UniqueSkills.MERCILESS.get()))).getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                }
                if ((race = cap.getRace()) == null) {
                    return;
                }
                double MP = Math.min(totalEP * (double)SkillUtils.getMagiculeGain(player, TensuraEPCapability.isMajin(living)), maxMP);
                double AP = Math.min(totalEP * (double)SkillUtils.getAuraGain(player, TensuraEPCapability.isMajin(living)), maxAP);
                cap.setBaseMagicule(cap.getBaseMagicule() + MP, (LivingEntity)player);
                cap.setBaseAura(cap.getBaseAura() + AP, (LivingEntity)player);
                TensuraPlayerCapability.sync(player);
            });
            TensuraEPCapability.updateEP((LivingEntity)player);
        } else if (totalEP * (double)TensuraGameRules.getEPGain(living.f_19853_) >= 1.0) {
            TensuraEPCapability.setLivingEP(living, Math.round(TensuraEPCapability.getEP(living) + Math.min(totalEP * (double)TensuraGameRules.getEPGain(living.f_19853_), maxMP + maxAP)));
            LivingEntity livingEntity = SkillHelper.getSubordinateOwner(living);
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                    if (cap.isDemonLordSeed()) {
                        double newSoul = (double)cap.getSoulPoints() + Math.min(totalEP * (Double)TensuraConfig.INSTANCE.awakeningConfig.epToSoulRate.get() / 100.0, maxMP + maxAP);
                        cap.setSoulPoints((int)Math.min(newSoul, 2.147483647E9));
                        TensuraPlayerCapability.sync(player);
                    }
                });
            }
        }
    }

    private static void gearGetEP(LivingEntity living, EquipmentSlot slot, double totalEP) {
        ItemStack stack = living.m_6844_(slot);
        if (stack.m_41741_() > 1) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        for (GearEPCount gearEPCount : TensuraData.getGearEP()) {
            if (!Objects.equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), gearEPCount.getItem())) continue;
            if (tag.m_128459_("EP") <= (double)gearEPCount.getMinEP()) {
                tag.m_128347_("EP", (double)gearEPCount.getMinEP());
            }
            if (tag.m_128459_("MaxEP") < (double)gearEPCount.getMaxEP()) {
                tag.m_128347_("MaxEP", (double)gearEPCount.getMaxEP());
            }
            double maxEP = tag.m_128459_("MaxEP");
            double gainAmount = Math.round(totalEP * gearEPCount.getGainEP());
            ItemStack evolvingItem = Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(gearEPCount.getEvolvingItem())).m_7968_();
            if (tag.m_128459_("EP") + gainAmount < maxEP) {
                tag.m_128347_("EP", tag.m_128459_("EP") + gainAmount);
                EngravingEnchantment.randomEngraving(living, stack, tag.m_128459_("EP"));
                break;
            }
            if (!evolvingItem.m_150930_(Items.f_41852_)) {
                tag.m_128347_("EP", tag.m_128459_("EP") + gainAmount);
                EngravingEnchantment.randomEngraving(living, stack, tag.m_128459_("EP"));
                if (stack.m_41783_() != null) {
                    evolvingItem.m_41751_(stack.m_41783_().m_6426_());
                }
                WeaponEPHandler.initiateItemEP(evolvingItem);
                living.m_8061_(slot, evolvingItem);
                if (!(living instanceof HumanoidNPCEntity)) break;
                HumanoidNPCEntity npc = (HumanoidNPCEntity)living;
                int id = HumanoidNPCMenu.getEquipmentSlotId(slot);
                if (!npc.inventory.m_8020_(id).m_150930_(stack.m_41720_())) break;
                npc.inventory.m_6836_(HumanoidNPCMenu.getEquipmentSlotId(slot), evolvingItem);
                npc.inventory.m_6596_();
                break;
            }
            if (tag.m_128459_("EP") == maxEP) break;
            tag.m_128347_("EP", maxEP);
            EngravingEnchantment.randomEngraving(living, stack, tag.m_128459_("EP"));
            break;
        }
    }

    private static void initiateItemEP(ItemStack stack) {
        for (GearEPCount gearEPCount : TensuraData.getGearEP()) {
            if (!Objects.equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), gearEPCount.getItem())) continue;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128459_("EP") <= (double)gearEPCount.getMinEP()) {
                tag.m_128347_("EP", (double)gearEPCount.getMinEP());
            }
            if (!(tag.m_128459_("MaxEP") < (double)gearEPCount.getMaxEP())) break;
            tag.m_128347_("MaxEP", (double)gearEPCount.getMaxEP());
            break;
        }
    }
}

