/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler.client;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.core.client.AccessorEntityRenderer;
import com.github.manasmods.tensura.handler.RaceHandler;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.SlimeJumpChargePacket;
import com.github.manasmods.tensura.network.play2server.SlimeJumpReleasedPacket;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.race.slime.SlimeRace;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientRaceHandler {
    public static long jumpChargingTicks = 0L;

    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre e) {
        try {
            Player player = e.getEntity();
            float scale = RaceHelper.getSizeMultiplier((LivingEntity)player);
            if (scale == 1.0f) {
                return;
            }
            e.getPoseStack().m_85836_();
            e.getPoseStack().m_85837_(0.0, player.m_6047_() ? 0.125 - 0.125 * (double)scale : 0.0, 0.0);
            e.getPoseStack().m_85841_(scale, scale, scale);
            AccessorEntityRenderer renderer = (AccessorEntityRenderer)e.getRenderer();
            renderer.setShadowRadius(renderer.getShadowRadius() * 1.0f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post e) {
        try {
            if (RaceHelper.getSizeMultiplier((LivingEntity)e.getEntity()) != 1.0f) {
                e.getPoseStack().m_85849_();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerName(RenderNameTagEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player entity2 = (Player)entity;
        try {
            float scale = RaceHelper.getSizeMultiplier((LivingEntity)entity2);
            e.getPoseStack().m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
            if (e.getEntity().m_6047_() && scale < 0.2f) {
                e.getPoseStack().m_85837_(0.0, -1.0 * (double)scale, 0.0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void checkForSlimeJumpCharge(MovementInputUpdateEvent e) {
        Player player = e.getEntity();
        if (player.m_5833_()) {
            return;
        }
        if (RaceHandler.isInFluid((LivingEntity)player) || !player.m_6047_() || !player.m_20096_() && player.f_19789_ > 1.0f) {
            SlimeJumpChargePacket.chargingPlayers.remove(player.m_20148_());
            jumpChargingTicks = 0L;
            return;
        }
        if (!player.m_20096_()) {
            return;
        }
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.getRace() == null) {
                return;
            }
            if (cap.getRace() instanceof SlimeRace) {
                if (e.getInput().f_108572_) {
                    e.getInput().f_108572_ = false;
                    if (jumpChargingTicks == 0L && player.m_6047_()) {
                        TensuraNetwork.toServer(new SlimeJumpChargePacket());
                    }
                    if (jumpChargingTicks < 100L && player.m_6047_()) {
                        ++jumpChargingTicks;
                    } else if (!player.m_6047_()) {
                        SlimeJumpChargePacket.chargingPlayers.remove(player.m_20148_());
                        jumpChargingTicks = 0L;
                        e.getInput().f_108572_ = false;
                        player.m_6862_(false);
                        player.f_20899_ = false;
                        return;
                    }
                } else if (jumpChargingTicks > 0L) {
                    TensuraNetwork.toServer(new SlimeJumpReleasedPacket());
                    jumpChargingTicks = 0L;
                }
            }
        });
    }
}

