/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler.client;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.api.entity.subclass.ILivingPartEntity;
import com.github.manasmods.tensura.block.entity.CharybdisCoreBlockEntity;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.client.screen.SettingsScreen;
import com.github.manasmods.tensura.config.client.DisplayConfig;
import com.github.manasmods.tensura.config.client.TensuraClientConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class HUDHandler {
    private static final ResourceLocation MAIN_HUD = new ResourceLocation("tensura", "textures/player_hud/main_hud.png");
    private static final ResourceLocation SPECTATOR_HUD = new ResourceLocation("tensura", "textures/player_hud/spectator_hud.png");
    private static final ResourceLocation CREATIVE_HUD = new ResourceLocation("tensura", "textures/player_hud/creative_hud.png");
    private static final ResourceLocation HARDCORE_HUD = new ResourceLocation("tensura", "textures/player_hud/hardcore_hud.png");
    private static final ResourceLocation MAIN_HUD_BARS = new ResourceLocation("tensura", "textures/player_hud/main_hud_bars.png");
    private static final ResourceLocation CREATIVE_HUD_BARS = new ResourceLocation("tensura", "textures/player_hud/creative_hud_bars.png");
    private static final ResourceLocation HARDCORE_HUD_BARS = new ResourceLocation("tensura", "textures/player_hud/hardcore_hud_bars.png");
    private static final ResourceLocation SEVERANCE_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/severance_hp_bar.png");
    private static final ResourceLocation HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/hp_bar.png");
    private static final ResourceLocation INFECTION_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/infection_hp_bar.png");
    private static final ResourceLocation WITHER_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/wither_hp_bar.png");
    private static final ResourceLocation FATAL_POISON_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/fatal_poison_hp_bar.png");
    private static final ResourceLocation CORROSION_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/corrosion_hp_bar.png");
    private static final ResourceLocation POISON_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/poison_hp_bar.png");
    private static final ResourceLocation FROZEN_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/frozen_hp_bar.png");
    private static final ResourceLocation CURSE_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/curse_hp_bar.png");
    private static final ResourceLocation ABSORPTION_HEALTH_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/absorption_hp_bar.png");
    private static final ResourceLocation SPIRITUAL_HP_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/shp_bar.png");
    private static final ResourceLocation SOUL_DRAIN_SPIRITUAL_HP_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/soul_drain_shp_bar.png");
    private static final ResourceLocation INSANITY_SPIRITUAL_HP_BAR = new ResourceLocation("tensura", "textures/player_hud/hp_bars/insanity_shp_bar.png");
    private static final ResourceLocation HEART = new ResourceLocation("tensura", "textures/player_hud/heart.png");
    private static final ResourceLocation SPIRITUAL_HEART = new ResourceLocation("tensura", "textures/player_hud/spiritual_heart.png");
    private static final ResourceLocation MANA_BAR = new ResourceLocation("tensura", "textures/player_hud/mana_bar.png");
    private static final ResourceLocation AURA_BAR = new ResourceLocation("tensura", "textures/player_hud/aura_bar.png");
    private static final ResourceLocation BARRIER = new ResourceLocation("tensura", "textures/player_hud/barrier.png");
    private static final ResourceLocation EMPTY_HUNGER = new ResourceLocation("tensura", "textures/player_hud/food_empty_hunger.png");
    private static final ResourceLocation FULL_HUNGER = new ResourceLocation("tensura", "textures/player_hud/food_full_hunger.png");
    private static final ResourceLocation EMPTY_FOOD = new ResourceLocation("tensura", "textures/player_hud/food_empty.png");
    private static final ResourceLocation EMPTY_ARMOR = new ResourceLocation("tensura", "textures/player_hud/armor_empty.png");
    private static final ResourceLocation FULL_ARMOR = new ResourceLocation("tensura", "textures/player_hud/armor.png");
    private static final ResourceLocation SKILL_OVERLAY = new ResourceLocation("tensura", "textures/player_hud/skill_overlay.png");
    private static final ResourceLocation SKILL_OVERLAY_TEXT_BARS = new ResourceLocation("tensura", "textures/player_hud/skill_overlay_text_bars.png");
    private static final ResourceLocation SKILL_OVERLAY_MASTERY_BAR = new ResourceLocation("tensura", "textures/player_hud/mastery_bar.png");
    private static final ResourceLocation SKILL_OVERLAY_LEARNING_BAR = new ResourceLocation("tensura", "textures/player_hud/learning_bar.png");
    private static final ResourceLocation SKILL_OVERLAY_COOLDOWN_ICON = new ResourceLocation("tensura", "textures/player_hud/cooldown_icon.png");
    private static final ResourceLocation ANALYSIS_OVERLAY = new ResourceLocation("tensura", "textures/player_hud/analysis_overlay.png");
    private static final ResourceLocation ANALYSIS_OVERLAY_BLOCKS = new ResourceLocation("tensura", "textures/player_hud/analysis_overlay_blocks.png");
    private static final ResourceLocation MOUNT_HEART = new ResourceLocation("tensura", "textures/player_hud/mount_heart.png");
    private static final ResourceLocation MOUNT_SPIRITUAL_HEART = new ResourceLocation("tensura", "textures/player_hud/mount_spiritual_heart.png");
    private static DisplayConfig cfg;
    private static boolean leftSideStats;
    private static boolean flippedSkills;
    private static boolean leftSideAnalysis;
    private static int screenX;
    private static int screenY;
    private static int appraisalOpacity;
    private static double size;
    private static LocalPlayer player;
    private static Font font;
    private static PoseStack poseStack;
    public static final int[] hudPositions;
    public static final int[] skillOverlayPositions;
    private static int appraisalPosX;
    private static int slot;
    private static int slotSwitch;

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerBelow(VanillaGuiOverlay.SLEEP_FADE.id(), "tensura_hud", (gui, pPoseStack, partialTick, screenWidth, screenHeight) -> {
            boolean scaled;
            if (!TensuraClientConfig.SPEC.isLoaded()) {
                return;
            }
            if (gui.getMinecraft().f_91074_ == null) {
                return;
            }
            if (TensuraPlayerCapability.getRace((LivingEntity)gui.getMinecraft().f_91074_) == null) {
                return;
            }
            player = gui.getMinecraft().f_91074_;
            if (player.m_5803_() && player.m_21023_((MobEffect)TensuraMobEffects.INSANITY.get())) {
                return;
            }
            int hudVariant = (Integer)TensuraClientConfig.INSTANCE.displayConfig.hudVariant.get();
            if (hudVariant == 0) {
                return;
            }
            gui.setupOverlayRenderState(true, false);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            cfg = TensuraClientConfig.INSTANCE.displayConfig;
            leftSideStats = (Boolean)HUDHandler.cfg.leftSideStats.get();
            flippedSkills = (Boolean)HUDHandler.cfg.leftSideSkills.get();
            size = (Double)HUDHandler.cfg.size.get();
            appraisalOpacity = (Integer)HUDHandler.cfg.appraisalOpacity.get();
            screenX = screenWidth;
            screenY = screenHeight;
            font = gui.m_93082_();
            poseStack = pPoseStack;
            HUDHandler.updatePositions();
            if (poseStack == null) {
                return;
            }
            boolean bl = scaled = size != 1.0;
            if (scaled) {
                poseStack.m_85836_();
                RenderSystem.m_157182_();
                poseStack.m_85837_(leftSideStats ? 0.0 : (double)screenX - (double)screenX * size, 0.0, 0.0);
                poseStack.m_85841_((float)size, (float)size, (float)size);
            }
            if (hudVariant == 3) {
                HUDHandler.mixedHudRendering();
                if (scaled) {
                    poseStack.m_85849_();
                }
                return;
            }
            if (player.m_5833_()) {
                HUDHandler.simpleRenderTexture(SPECTATOR_HUD, 0, 0, 256, 256);
                HUDHandler.renderPlayer();
                if (scaled) {
                    poseStack.m_85849_();
                }
                return;
            }
            if (player.m_7500_()) {
                HUDHandler.simpleRenderTexture(CREATIVE_HUD, 0, 0, 256, 256);
            } else {
                HUDHandler.simpleRenderTexture(player.m_9236_().m_6106_().m_5466_() ? HARDCORE_HUD : MAIN_HUD, 0, 0, 256, 256);
            }
            HUDHandler.renderPlayer();
            HUDHandler.renderHPbars();
            HUDHandler.renderMPandAPbars(false);
            HUDHandler.renderMiscellaneous();
            if (!scaled) {
                HUDHandler.renderSkills();
                return;
            }
            poseStack.m_85849_();
            poseStack.m_85836_();
            RenderSystem.m_157182_();
            poseStack.m_85837_(skillOverlayPositions[0] == screenX - 41 ? (double)screenX - (double)screenX * size : 0.0, 0.0, 0.0);
            poseStack.m_85841_((float)size, (float)size, (float)size);
            HUDHandler.renderSkills();
            poseStack.m_85849_();
            RenderSystem.m_157182_();
        });
        event.registerBelow(VanillaGuiOverlay.SLEEP_FADE.id(), "tensura_analysis", (gui, pPoseStack, partialTick, screenWidth, screenHeight) -> {
            if (player == null || poseStack == null || cfg == null) {
                return;
            }
            int level = TensuraSkillCapability.getAnalysisLevel((Player)player);
            if (level <= 0) {
                appraisalPosX = leftSideAnalysis ? -95 : screenX;
                slot = 0;
                slotSwitch = 0;
                return;
            }
            int distance = TensuraSkillCapability.getAnalysisDistance((Player)player);
            if (distance <= 0) {
                return;
            }
            leftSideAnalysis = (Boolean)HUDHandler.cfg.leftSideAnalysis.get();
            if (size == 1.0) {
                HUDHandler.renderAppraisal(level, distance);
                return;
            }
            poseStack.m_85836_();
            RenderSystem.m_157182_();
            poseStack.m_85837_(leftSideAnalysis ? 0.0 : (double)screenX - (double)screenX * size, (double)screenY / 3.0 - (double)screenY / 3.0 * size, 0.0);
            poseStack.m_85841_((float)size, (float)size, (float)size);
            HUDHandler.renderAppraisal(level, distance);
            poseStack.m_85849_();
            RenderSystem.m_157182_();
        });
    }

    private static void mixedHudRendering() {
        boolean scaled;
        boolean bl = scaled = size != 1.0;
        if (scaled) {
            poseStack.m_85836_();
            RenderSystem.m_157182_();
            poseStack.m_85841_((float)size, (float)size, (float)size);
        }
        HUDHandler.renderMPandAPbars(true);
        if (!scaled) {
            HUDHandler.renderSkills();
            return;
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        RenderSystem.m_157182_();
        poseStack.m_85837_(skillOverlayPositions[0] == screenX - 41 ? (double)screenX - (double)screenX * size : 0.0, 0.0, 0.0);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        HUDHandler.renderSkills();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static void renderPlayer() {
        if (Minecraft.m_91087_().f_91066_.f_92063_) {
            return;
        }
        float sizeMultiplier = RaceHelper.getSizeMultiplier((LivingEntity)player);
        sizeMultiplier = sizeMultiplier > 1.0f ? 1.0f / sizeMultiplier : 1.0f;
        double x = leftSideStats ? 22.0 * size : (double)screenX - 22.0 * size;
        double y = (double)(player.m_5833_() ? 47 : 37) * size;
        float scale = (float)(16.0 * size) * sizeMultiplier;
        float lookAngle = leftSideStats ? -((float)screenX / 2.0f) + 40.0f : (float)screenX / 2.0f;
        TensuraGUIHelper.renderEntityOnScreen(x, y, scale, lookAngle, 0.0f, (LivingEntity)player);
    }

    private static void renderHPbars() {
        int maxHealthPoints = Math.round(player.m_21233_());
        int maxSpiritualHP = (int)Math.round(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
        int healthPoints = (int)Math.ceil(player.m_21223_());
        int spiritualHP = (int)Math.ceil(TensuraEPCapability.getSpiritualHealth((LivingEntity)player));
        ResourceLocation HPbar = HUDHandler.getHealthBarToRender(false);
        ResourceLocation spiritualHPbar = HUDHandler.getHealthBarToRender(true);
        int width = HUDHandler.dynamicResizing(0, 101, healthPoints, maxHealthPoints);
        HUDHandler.renderCutTexture(HPbar, 44, 5, width, 9, 101, 9, 1.0f);
        HUDHandler.renderSeverance();
        width = HUDHandler.dynamicResizing(0, 85, spiritualHP, maxSpiritualHP);
        HUDHandler.renderCutTexture(spiritualHPbar, 44, 19, width, 9, 85, 9, 1.0f);
        int posX = leftSideStats ? 46 : screenX - 147;
        MutableComponent text = Component.m_237113_((String)String.format("%s/%s", healthPoints, maxHealthPoints));
        TensuraGUIHelper.renderScaledCenteredXText(font, poseStack, (Component)text, posX, 6, 101, 10, Color.WHITE, true);
        posX = leftSideStats ? 46 : screenX - 131;
        text = Component.m_237113_((String)String.format("%s/%s", spiritualHP, maxSpiritualHP));
        TensuraGUIHelper.renderScaledCenteredXText(font, poseStack, (Component)text, posX, 20, 85, 10, Color.WHITE, true);
    }

    private static void renderMPandAPbars(boolean mixed) {
        int maxMana = (int)player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
        int maxAura = (int)player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
        int mana = (int)TensuraPlayerCapability.getMagicule((Player)player);
        int aura = (int)TensuraPlayerCapability.getAura((Player)player);
        if (mixed) {
            int hudX = hudPositions[0];
            int hudY = hudPositions[1];
            if (hudX == -1) {
                hudX = screenX / 2 + (leftSideStats ? -173 : 92);
            }
            if (hudY == -1) {
                hudY = screenY - 23;
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (player.m_7500_()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)CREATIVE_HUD_BARS);
            } else if (player.m_9236_().m_6106_().m_5466_()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)HARDCORE_HUD_BARS);
            } else {
                RenderSystem.m_157456_((int)0, (ResourceLocation)MAIN_HUD_BARS);
            }
            GuiComponent.m_93160_((PoseStack)poseStack, (int)hudX, (int)hudY, (int)81, (int)23, (float)0.0f, (float)0.0f, (int)(leftSideStats ? -81 : 81), (int)23, (int)81, (int)23);
            int n = leftSideStats ? 76 : 5;
            int width = HUDHandler.dynamicResizing(0, 67, mana, maxMana);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MANA_BAR);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(leftSideStats ? hudX - width : (hudX += n)), (int)(hudY + 2), (int)width, (int)9, (float)0.0f, (float)0.0f, (int)width, (int)9, (int)67, (int)9);
            width = HUDHandler.dynamicResizing(0, 67, aura, maxAura);
            RenderSystem.m_157456_((int)0, (ResourceLocation)AURA_BAR);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(leftSideStats ? hudX - width : hudX), (int)((hudY += 10) + 2), (int)width, (int)9, (float)0.0f, (float)0.0f, (int)width, (int)9, (int)57, (int)9);
            RenderSystem.m_69461_();
            if (leftSideStats) {
                hudX -= 66;
            }
            MutableComponent text = Component.m_237113_((String)String.format("%s%%", (int)((double)mana / (double)maxMana * 100.0)));
            TensuraGUIHelper.renderScaledCenteredXText(font, poseStack, (Component)text, hudX, (hudY -= 10) + 3, 67, 10, Color.WHITE, true);
            text = Component.m_237113_((String)String.format("%s%%", (int)((double)aura / (double)maxAura * 100.0)));
            TensuraGUIHelper.renderScaledCenteredXText(font, poseStack, (Component)text, hudX, (hudY += 10) + 3, 67, 10, Color.WHITE, true);
            return;
        }
        int width = HUDHandler.dynamicResizing(0, 67, mana, maxMana);
        HUDHandler.renderCutTexture(MANA_BAR, 5, 46, width, 9, 67, 9, 1.0f);
        width = HUDHandler.dynamicResizing(0, 57, aura, maxAura);
        HUDHandler.renderCutTexture(AURA_BAR, 5, 56, width, 9, 57, 9, 1.0f);
        int posX = leftSideStats ? 7 : screenX - 74;
        MutableComponent text = Component.m_237113_((String)String.format("%s%%", (int)((double)mana / (double)maxMana * 100.0)));
        TensuraGUIHelper.renderScaledCenteredXText(font, poseStack, (Component)text, posX, 47, 67, 10, Color.WHITE, true);
        posX = leftSideStats ? 7 : screenX - 64;
        text = Component.m_237113_((String)String.format("%s%%", (int)((double)aura / (double)maxAura * 100.0)));
        TensuraGUIHelper.renderScaledCenteredXText(font, poseStack, (Component)text, posX, 57, 57, 10, Color.WHITE, true);
    }

    private static void renderSkills() {
        int skillOverlayX = skillOverlayPositions[0];
        int skillOverlayY = skillOverlayPositions[1];
        HUDHandler.skillOverlayRendering(SKILL_OVERLAY, skillOverlayX, skillOverlayY, flippedSkills ? -41 : 41, 104, 41, 1.0f);
        TensuraSkillCapability.getFrom((Player)player).ifPresent(cap -> {
            boolean showFullInfo;
            boolean bl = showFullInfo = TensuraKeybinds.NEXT_MODE_CHANGE.m_90857_() || TensuraKeybinds.PREVIOUS_MODE_CHANGE.m_90857_();
            if (showFullInfo) {
                HUDHandler.skillOverlayRendering(SKILL_OVERLAY_TEXT_BARS, flippedSkills ? skillOverlayX - 117 : skillOverlayX + 41, skillOverlayY + 4, flippedSkills ? -256 : 256, 256, 117, 1.0f);
            }
            for (int i = 0; i < 3; ++i) {
                boolean onCooldown;
                ManasSkill skill = cap.getSkillInSlot(i);
                if (skill == null) continue;
                ManasSkillInstance skillInstance = SkillAPI.getSkillsFrom((Entity)player).getSkill(skill).orElse(skill.createDefaultInstance());
                ResourceLocation icon = skill.getSkillIcon();
                if (icon != null) {
                    int x = flippedSkills ? skillOverlayX + 1 : skillOverlayX + 8;
                    int y = skillOverlayY + 1 + i * 35;
                    HUDHandler.skillOverlayRendering(icon, x, y, flippedSkills ? -32 : 32, 32, 32, 1.0f);
                }
                int maxMastery = skill.getMaxMastery();
                int mastery = skillInstance.getMastery();
                boolean isLearning = mastery < 0;
                int masteryBarHeight = HUDHandler.dynamicResizing(0, 22, mastery, maxMastery);
                if (isLearning) {
                    int max = 100;
                    if (skill instanceof ResistSkill) {
                        ResistSkill resistSkill = (ResistSkill)skill;
                        max = resistSkill.pointRequirement();
                    }
                    masteryBarHeight = HUDHandler.dynamicResizing(0, 22, max - Math.abs(mastery), max);
                }
                int masteryBarY = skillOverlayY + 6 + i * 35 + (22 - masteryBarHeight);
                HUDHandler.skillOverlayRendering(isLearning ? SKILL_OVERLAY_LEARNING_BAR : SKILL_OVERLAY_MASTERY_BAR, flippedSkills ? skillOverlayX + 34 : skillOverlayX + 2, masteryBarY, 5, masteryBarHeight, 5, 1.0f);
                boolean bl2 = onCooldown = skillInstance.onCoolDown() && !skillInstance.canIgnoreCoolDown((LivingEntity)player);
                if (onCooldown) {
                    String cooldown = String.valueOf(skillInstance.getCoolDown());
                    int posX1 = flippedSkills ? skillOverlayX - 38 + 41 : skillOverlayX + 10;
                    int posX2 = flippedSkills ? skillOverlayX - 10 + 41 : skillOverlayX + 38;
                    int[] positions = HUDHandler.getCenteredTextPositions(cooldown, posX1, skillOverlayY + 8 + i * 35, posX2, skillOverlayY + 32 + i * 35, 7);
                    FormattedText number = FormattedText.m_130762_((String)cooldown, (Style)Style.f_131099_);
                    int posY = skillOverlayY + 3 + i * 35;
                    HUDHandler.skillOverlayRendering(SKILL_OVERLAY_COOLDOWN_ICON, flippedSkills ? skillOverlayX + 3 : skillOverlayX + 10, posY, flippedSkills ? -28 : 28, 28, 28, 0.9f);
                    TensuraGUIHelper.renderScaledShadowText(poseStack, font, number, positions[0], positions[1], 32.0f, 32.0f, Color.RED.getRGB(), 2.0f, 0.01f);
                }
                if (!showFullInfo) continue;
                int color = Color.GRAY.getRGB();
                String modeName = "tensura.skill.mode.default";
                if (skill instanceof TensuraSkill) {
                    TensuraSkill tensuraSkill = (TensuraSkill)skill;
                    if (!onCooldown && tensuraSkill.getColoredName() != null) {
                        color = tensuraSkill.getColoredName().m_7383_().m_131135_().m_131265_();
                    }
                    modeName = tensuraSkill.getModeName(skillInstance.getMode()).getString();
                }
                String skillName = Component.m_237115_((String)"tensura.race.selection.skills.empty").getString();
                if (skill.getName() != null) {
                    skillName = skill.getName().getString();
                }
                FormattedText nameText = FormattedText.m_130762_((String)skillName, (Style)Style.f_131099_);
                FormattedText modeText = FormattedText.m_130762_((String)modeName, (Style)Style.f_131099_);
                int posX = flippedSkills ? skillOverlayX - 111 : skillOverlayX + 44;
                int posY = skillOverlayY + 8 + i * 35;
                TensuraGUIHelper.renderScaledShadowText(poseStack, font, nameText, posX, posY, 111.0f, 11.0f, color, 2.0f, 0.01f);
                posX = flippedSkills ? skillOverlayX - 97 : skillOverlayX + 44;
                posY = skillOverlayY + 21 + i * 35;
                TensuraGUIHelper.renderScaledShadowText(poseStack, font, modeText, posX, posY, 97.0f, 10.0f, onCooldown ? Color.DARK_GRAY.getRGB() : Color.WHITE.getRGB(), 2.0f, 0.01f);
            }
        });
    }

    private static void renderAppraisal(int level, int distance) {
        int mode = TensuraSkillCapability.getAnalysisMode((Player)player);
        LivingEntity entity = SkillHelper.getTargetingEntity((LivingEntity)player, distance, false, true);
        if ((mode == 0 || mode == 1) && entity != null) {
            HUDHandler.renderMobAnalysis(entity, level);
        } else if (mode == 0 || mode == 2) {
            BlockPos blockPos = SkillHelper.getPlayerPOVHitResult(HUDHandler.player.f_19853_, (Entity)player, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, distance).m_82425_();
            BlockState block = HUDHandler.player.f_19853_.m_8055_(blockPos);
            if (block.m_60795_()) {
                HUDHandler.player.f_19853_.m_8055_(SkillHelper.getPlayerPOVHitResult(HUDHandler.player.f_19853_, (Entity)player, ClipContext.Fluid.SOURCE_ONLY, ClipContext.Block.OUTLINE, distance).m_82425_());
            }
            if (!block.m_60795_()) {
                HUDHandler.renderBlockAnalysis(block, blockPos, HUDHandler.player.f_19853_);
            } else {
                appraisalPosX = leftSideAnalysis ? -95 : screenX;
                slot = 0;
                slotSwitch = 0;
                return;
            }
        }
        if (leftSideAnalysis) {
            if (appraisalPosX < 0) {
                appraisalPosX += 4;
            } else if (appraisalPosX != 0) {
                appraisalPosX = 0;
            }
        } else if (appraisalPosX > screenX - 95) {
            appraisalPosX -= 4;
        } else if (appraisalPosX != screenX - 95) {
            appraisalPosX = screenX - 95;
        }
    }

    private static void renderMobAnalysis(LivingEntity target, int level) {
        Player playerTarget;
        Player playerTarget2;
        Race race;
        if (target instanceof ILivingPartEntity) {
            ILivingPartEntity part = (ILivingPartEntity)target;
            if (part.getHeadId() != null) {
                List list = target.m_9236_().m_6443_(LivingEntity.class, target.m_20191_().m_82400_(15.0), entity -> Objects.equals(part.getHeadId(), entity.m_20148_()));
                if (list.isEmpty()) {
                    return;
                }
                target = (LivingEntity)list.get(0);
            } else {
                return;
            }
        }
        Component name = target.m_7755_();
        int health = (int)Math.ceil(target.m_21223_());
        int spiritual = (int)Math.ceil(TensuraEPCapability.getSpiritualHealth(target));
        int armor = target.m_21230_();
        int left = appraisalPosX;
        int top = screenY / 4;
        int textY = top + 30;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ANALYSIS_OVERLAY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)appraisalOpacity / 100.0f));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)95, (int)156, (int)95, (int)156);
        int color = TensuraEPCapability.isChaos(target) ? Color.RED.getRGB() : (TensuraEPCapability.isMajin(target) ? Color.YELLOW.getRGB() : Color.WHITE.getRGB());
        TensuraGUIHelper.renderScaledShadowText(poseStack, font, (FormattedText)Component.m_237113_((String)name.getString()), left + 8, top + 12, 79.0f, 9.0f, color, 1.0f, 0.01f);
        if (target instanceof Player && (race = TensuraPlayerCapability.getRace((LivingEntity)(playerTarget2 = (Player)target))) != null) {
            String raceName = race.getName() != null ? race.getName().getString() : String.valueOf(race.getName());
            textY = TensuraGUIHelper.renderCenteredWrappedText(poseStack, font, FormattedText.m_130775_((String)raceName), left + 7, textY, 81, color, 1) + 1;
        }
        Object text = Component.m_237115_((String)"tensura.vanilla_attribute.health.shortened_name").getString() + ": " + health;
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
        int textureX = HUDHandler.getTexturePositionX((String)text, left + 7) - 4;
        RenderSystem.m_157456_((int)0, (ResourceLocation)HEART);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)textureX, (int)(textY - 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
        text = Component.m_237115_((String)"tensura.attribute.spiritual_health.shortened_name").getString() + ": " + spiritual;
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        textureX = HUDHandler.getTexturePositionX((String)text, left + 7) - 4;
        RenderSystem.m_157456_((int)0, (ResourceLocation)SPIRITUAL_HEART);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)textureX, (int)(textY - 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
        text = Component.m_237115_((String)"attribute.name.generic.armor").getString() + ": " + armor;
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        textureX = HUDHandler.getTexturePositionX((String)text, left + 7) - 4;
        RenderSystem.m_157456_((int)0, (ResourceLocation)FULL_ARMOR);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)textureX, (int)(textY - 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
        textY += 10;
        float epDifference = 1.0f + (float)level * 0.5f;
        if (TensuraEPCapability.getEP(target) >= (double)epDifference * TensuraEPCapability.getEP((LivingEntity)player)) {
            return;
        }
        if (target instanceof Player) {
            playerTarget = (Player)target;
            int mana = (int)Math.floor(TensuraPlayerCapability.getMagicule(playerTarget));
            text = Component.m_237115_((String)"tensura.attribute.magicule.shortened_name").getString() + ": " + TensuraGUIHelper.shortenNumberComponent(mana).getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
            int aura = (int)Math.floor(TensuraPlayerCapability.getAura(playerTarget));
            text = Component.m_237115_((String)"tensura.attribute.aura.shortened_name").getString() + ": " + TensuraGUIHelper.shortenNumberComponent(aura).getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
            text = Component.m_237115_((String)"tensura.attribute.existence_points.shortened_name").getString() + ": " + TensuraGUIHelper.shortenNumberComponent((int)Math.ceil(TensuraEPCapability.getEP(target))).getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        } else {
            text = Component.m_237115_((String)"tensura.attribute.existence_points.shortened_name").getString() + ": " + TensuraGUIHelper.shortenNumberComponent((int)Math.ceil(TensuraEPCapability.getCurrentEP(target))).getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
        }
        if (target instanceof Player) {
            playerTarget = (Player)target;
            if (level >= 1) {
                Skill skill1;
                ChatFormatting f;
                textY = top + 121;
                if (!Minecraft.m_91087_().m_91104_()) {
                    ++slotSwitch;
                }
                if (slotSwitch >= 100) {
                    slot = (slot + 1) % 3;
                    slotSwitch = 0;
                }
                ManasSkill skill = null;
                for (int i = 0; i < 3 && (skill = TensuraSkillCapability.getSkillInSlot((LivingEntity)playerTarget, slot)) == null; ++i) {
                    slot = (slot + 1) % 3;
                }
                if (skill == null) {
                    return;
                }
                Optional instance = SkillAPI.getSkillsFrom((Entity)playerTarget).getSkill(skill);
                if (instance.isEmpty() || ((ManasSkillInstance)instance.get()).isMastered((LivingEntity)playerTarget)) {
                    return;
                }
                MutableComponent skillName = skill.getName();
                text = skillName == null ? String.valueOf(skill.getRegistryName()) : skillName.getString();
                int skillColor = Color.WHITE.getRGB();
                if (skill instanceof Skill && (f = (skill1 = (Skill)skill).getType().getChatFormatting()).m_126665_() != null) {
                    skillColor = f.m_126665_();
                }
                TensuraGUIHelper.renderCenteredWrappedText(poseStack, font, FormattedText.m_130775_((String)text), left + 8, textY, 80, skillColor, 1);
            }
        }
    }

    private static void renderBlockAnalysis(BlockState blockState, BlockPos blockPos, Level level) {
        int left = appraisalPosX;
        int top = screenY / 4;
        int textY = top + 30;
        Block block = blockState.m_60734_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ANALYSIS_OVERLAY_BLOCKS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)appraisalOpacity / 100.0f));
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)95, (int)156, (int)95, (int)156);
        Object text = block.m_49954_().getString();
        TensuraGUIHelper.renderScaledShadowText(poseStack, font, (FormattedText)Component.m_237113_((String)text), left + 8, top + 12, 79.0f, 9.0f, Color.WHITE.getRGB(), 1.0f, 0.01f);
        text = Component.m_237115_((String)"tensura.attribute.block.hardness.name").getString();
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
        float hardness = block.m_155943_();
        text = hardness < 0.0f ? "-> " + Component.m_237115_((String)"item.unbreakable").getString() : "-> " + hardness;
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), hardness < 0.0f ? Color.RED.getRGB() : Color.WHITE.getRGB());
        boolean correct = ForgeHooks.isCorrectToolForDrops((BlockState)blockState, (Player)player);
        text = Component.m_237115_((String)"tensura.attribute.block.correct_tool.name").getString();
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        text = correct ? "-> " + Component.m_237115_((String)"gui.yes").getString() : "-> " + Component.m_237115_((String)"gui.no").getString();
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), correct ? Color.GREEN.getRGB() : Color.RED.getRGB());
        text = Component.m_237115_((String)"tensura.attribute.block.explosion_resistance.name").getString();
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        text = "-> " + block.m_7325_();
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        text = Component.m_237115_((String)"tensura.attribute.block.light_level.name").getString();
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        text = "-> " + HUDHandler.player.f_19853_.m_7146_(blockPos);
        font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
        textY += 10;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof CharybdisCoreBlockEntity) {
            CharybdisCoreBlockEntity core = (CharybdisCoreBlockEntity)blockEntity;
            double EP = (int)core.getEP();
            text = Component.m_237115_((String)"tensura.attribute.existence_points.name").getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
            text = "-> " + EP;
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
            textY += 10;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61426_)) {
            int power = (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61426_);
            text = Component.m_237115_((String)"tensura.attribute.block.redstone_strength.name").getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
            text = "-> " + power;
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
            textY += 10;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61416_)) {
            int value = (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61416_);
            text = Component.m_237115_((String)"tensura.attribute.block.egg_hatch.name").getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
            text = String.format("-> %s/%s", value, 2);
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)(textY += 10), Color.WHITE.getRGB());
            textY += 10;
        }
        int maxAge = HUDHandler.getAgeForCrop(blockState, true);
        int age = HUDHandler.getAgeForCrop(blockState, false);
        if (maxAge != -1 && age != -1) {
            int color;
            text = Component.m_237115_((String)"tensura.attribute.block.age.name").getString();
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, Color.WHITE.getRGB());
            textY += 10;
            if (blockState.m_60713_((Block)TensuraBlocks.HIPOKUTE_GRASS.get()) && (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61407_) == 2) {
                text = String.format("-> %s", Component.m_237115_((String)"tensura.failed_hipokute_grass").getString());
                color = Color.RED.getRGB();
            } else {
                text = String.format("-> %s/%s", age, maxAge);
                color = maxAge == age ? Color.GREEN.getRGB() : Color.WHITE.getRGB();
            }
            font.m_92883_(poseStack, (String)text, (float)(left + 7), (float)textY, color);
        }
    }

    private static int getAgeForCrop(BlockState state, boolean maxAge) {
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return maxAge ? crop.m_7419_() : ((Integer)state.m_61143_((Property)crop.m_7959_())).intValue();
        }
        Optional<Property> age = state.m_61147_().stream().filter(property -> property.m_61708_().equals("age") && property instanceof IntegerProperty).findFirst();
        if (age.isEmpty()) {
            return -1;
        }
        if (maxAge) {
            List property2 = age.get().m_6908_().stream().toList();
            return (Integer)property2.get(property2.size() - 1);
        }
        return (Integer)state.m_61143_((Property)((IntegerProperty)age.get()));
    }

    private static int getTexturePositionX(String text, int x) {
        int textWidth = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (i + 1 >= text.length()) {
                textWidth += 5;
                continue;
            }
            textWidth += 6;
        }
        return x + textWidth;
    }

    private static void renderMiscellaneous() {
        Entity entity;
        boolean hasMount;
        int airSupply = Math.max(0, (int)((float)player.m_20146_() / (float)player.m_6062_() * 20.0f));
        int foodLevel = Math.max(0, player.m_36324_().m_38702_());
        int armorValue = player.m_21230_();
        int barrierPoints = (int)player.m_21133_((Attribute)TensuraAttributeRegistry.BARRIER.get());
        boolean bl = hasMount = player.m_20202_() != null;
        if (player.m_21023_(MobEffects.f_19612_)) {
            if (foodLevel == 0) {
                HUDHandler.simpleRenderTexture(EMPTY_HUNGER, 64, 34, 9, 9);
            } else {
                HUDHandler.simpleRenderTexture(FULL_HUNGER, 64, 34, 9, 9);
            }
        } else if (foodLevel == 0) {
            HUDHandler.simpleRenderTexture(EMPTY_FOOD, 64, 34, 9, 9);
        }
        if (armorValue <= 0) {
            HUDHandler.simpleRenderTexture(EMPTY_ARMOR, 93, 34, 9, 9);
        }
        if (barrierPoints > 0) {
            HUDHandler.renderBarrierPoints(String.valueOf(barrierPoints));
        }
        int posX = leftSideStats ? 62 : screenX - 62;
        int foodPosition = HUDHandler.dynamicNumberStringPosition(String.valueOf(foodLevel), posX, 5, leftSideStats)[0];
        posX = leftSideStats ? 91 : screenX - 91;
        int armorPosition = HUDHandler.dynamicNumberStringPosition(String.valueOf(armorValue), posX, 5, leftSideStats)[0];
        posX = leftSideStats ? 120 : screenX - 120;
        int airPosition = HUDHandler.dynamicNumberStringPosition(String.valueOf(airSupply), posX, 5, leftSideStats)[0];
        if (hasMount && (entity = player.m_20202_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int healthPoints = (int)Math.ceil(living.m_21223_());
            int spiritualHP = (int)Math.ceil(TensuraEPCapability.getSpiritualHealth(living));
            HUDHandler.simpleRenderTexture(MOUNT_HEART, 109, 46, 9, 9);
            HUDHandler.simpleRenderTexture(MOUNT_SPIRITUAL_HEART, 141, 46, 9, 9);
            posX = leftSideStats ? 107 : screenX - 107;
            int healthPosition = HUDHandler.dynamicNumberStringPosition(String.valueOf(healthPoints), posX, 5, leftSideStats)[0];
            posX = leftSideStats ? 139 : screenX - 139;
            int spiritualPosition = HUDHandler.dynamicNumberStringPosition(String.valueOf(spiritualHP), posX, 5, leftSideStats)[0];
            font.m_92883_(poseStack, String.valueOf(healthPoints), (float)healthPosition, 47.0f, Color.WHITE.getRGB());
            font.m_92883_(poseStack, String.valueOf(spiritualHP), (float)spiritualPosition, 47.0f, Color.WHITE.getRGB());
        }
        font.m_92883_(poseStack, String.valueOf(foodLevel), (float)foodPosition, 35.0f, Color.WHITE.getRGB());
        font.m_92883_(poseStack, String.valueOf(armorValue), (float)armorPosition, 35.0f, Color.WHITE.getRGB());
        font.m_92883_(poseStack, String.valueOf(airSupply), (float)airPosition, 35.0f, Color.WHITE.getRGB());
    }

    private static void renderBarrierPoints(String points) {
        int textWidth = 0;
        for (int i = 0; i < points.length(); ++i) {
            if (i + 1 >= points.length()) {
                textWidth += 5;
                continue;
            }
            textWidth += 6;
        }
        int x = leftSideStats ? 86 : screenX - 85 - textWidth;
        int iconPos = leftSideStats ? x + textWidth + 2 : x - 11;
        RenderSystem.m_157456_((int)0, (ResourceLocation)BARRIER);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)iconPos, (int)47, (int)9, (int)9, (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.m_92883_(poseStack, points, (float)x, 47.0f, Color.WHITE.getRGB());
    }

    private static void skillOverlayRendering(ResourceLocation texture, int x, int y, int width, int height, int visibleWidth, float alpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (width > 0) {
            GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        } else {
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(x + width + visibleWidth), (int)y, (int)(-width), (int)height, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)(-width), (int)height);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void simpleRenderTexture(ResourceLocation texture, int x, int y, int width, int height) {
        HUDHandler.simpleRenderTexture(texture, x, y, width, height, 1.0f);
    }

    private static void simpleRenderTexture(ResourceLocation texture, int x, int y, int width, int height, float alpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (!leftSideStats) {
            x = screenX - x - width;
        }
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)(leftSideStats ? width : -width), (int)height, (int)width, (int)height);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderSeverance() {
        double severance = TensuraEffectsCapability.getSeverance((LivingEntity)player);
        if (severance <= 0.0) {
            return;
        }
        int width = 1 + HUDHandler.dynamicResizing(0, 101, severance, player.m_21233_());
        int x = 145 - width;
        int y = 5;
        int height = 9;
        if (!leftSideStats) {
            x = screenX - x - width;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)SEVERANCE_BAR);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)101, (int)9);
    }

    private static void renderCutTexture(ResourceLocation texture, int x, int y, int width, int height, int maxWidth, int maxHeight, float alpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (!leftSideStats) {
            x = screenX - x - width;
        }
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)(leftSideStats ? width : -width), (int)height, (int)maxWidth, (int)maxHeight);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderTheCutTexture(ResourceLocation texture, int x, int y, int width, int height, int maxWidth, int maxHeight, float alpha) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (leftSideStats) {
            x = screenX - x - width;
        }
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)(leftSideStats ? width : -width), (int)height, (int)maxWidth, (int)maxHeight);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static int dynamicResizing(int minSize, int maxSize, double currentValue, double maxValue) {
        return Math.min(Math.max(minSize, (int)((double)maxSize * currentValue / maxValue)), maxSize);
    }

    private static ResourceLocation getHealthBarToRender(boolean spiritual) {
        if (spiritual) {
            if (player.m_21023_((MobEffect)TensuraMobEffects.SOUL_DRAIN.get())) {
                return SOUL_DRAIN_SPIRITUAL_HP_BAR;
            }
            if (player.m_21023_((MobEffect)TensuraMobEffects.INSANITY.get())) {
                return INSANITY_SPIRITUAL_HP_BAR;
            }
            return SPIRITUAL_HP_BAR;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.INFECTION.get())) {
            return INFECTION_HEALTH_BAR;
        }
        if (player.m_21023_(MobEffects.f_19615_)) {
            return WITHER_HEALTH_BAR;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.FATAL_POISON.get())) {
            return FATAL_POISON_HEALTH_BAR;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.CORROSION.get())) {
            return CORROSION_HEALTH_BAR;
        }
        if (player.m_21023_(MobEffects.f_19614_)) {
            return POISON_HEALTH_BAR;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.FROST.get()) || player.m_21023_((MobEffect)TensuraMobEffects.CHILL.get()) || player.m_146890_()) {
            return FROZEN_HEALTH_BAR;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.CURSE.get())) {
            return CURSE_HEALTH_BAR;
        }
        if (player.m_21023_(MobEffects.f_19617_)) {
            return ABSORPTION_HEALTH_BAR;
        }
        return HEALTH_BAR;
    }

    private static int[] dynamicNumberStringPosition(String string, int startValue, int digitWidth, boolean reverse) {
        int number;
        int[] values = new int[2];
        int text = startValue;
        int texture = startValue;
        int length = string.length();
        int n = number = reverse ? -digitWidth : digitWidth;
        if (reverse) {
            for (i = 0; i < length; ++i) {
                text += number;
                if (i >= length - 1) continue;
                --text;
            }
        } else {
            for (i = 0; i < length; ++i) {
                texture += number;
                if (i >= length - 1) continue;
                ++texture;
            }
        }
        values[0] = text;
        values[1] = texture += 2;
        return values;
    }

    private static int[] getCenteredTextPositions(String string, int minWidth, int minHeight, int maxWidth, int maxHeight, int textHeightInPixels) {
        int[] values = new int[2];
        int textWidth = font.m_92895_(string);
        int centerX = minWidth + (maxWidth - minWidth) / 2 - textWidth / 2;
        int centerY = minHeight + (maxHeight - minHeight) / 2 - textHeightInPixels;
        values[0] = centerX;
        values[1] = centerY;
        return values;
    }

    private static void updatePositions() {
        int y1;
        int x1;
        int y;
        int x;
        boolean updateStats = false;
        boolean updateSkills = false;
        if (SettingsScreen.isEditingStatPositions()) {
            x = SettingsScreen.getHudX();
            y = SettingsScreen.getHudY();
        } else {
            x = (Integer)HUDHandler.cfg.hudX.get();
            y = (Integer)HUDHandler.cfg.hudY.get();
        }
        if (SettingsScreen.isEditingSkillPositions()) {
            x1 = SettingsScreen.getSkillsX();
            y1 = SettingsScreen.getSkillsY();
        } else {
            x1 = (Integer)HUDHandler.cfg.skillsX.get();
            y1 = (Integer)HUDHandler.cfg.skillsY.get();
        }
        if (x == -1 || y == -1) {
            updateStats = true;
        }
        if (x1 == -1 || y1 == -1 || x1 == -2 || y1 == -2) {
            updateSkills = true;
        }
        if (x == -1) {
            x = 0;
        }
        if (y == -1) {
            y = 0;
        }
        if (x1 == -1) {
            x1 = 0;
        } else if (x1 == -2) {
            x1 = screenX - 41;
        }
        if (y1 == -1) {
            y1 = screenY / 3;
        } else if (y1 == -2) {
            y1 = screenY - 104;
        }
        HUDHandler.hudPositions[0] = x;
        HUDHandler.hudPositions[1] = y;
        HUDHandler.skillOverlayPositions[0] = x1;
        HUDHandler.skillOverlayPositions[1] = y1;
        if (updateStats) {
            HUDHandler.cfg.hudX.set((Object)x);
            HUDHandler.cfg.hudY.set((Object)y);
        }
        if (updateSkills) {
            HUDHandler.cfg.skillsX.set((Object)x1);
            HUDHandler.cfg.skillsY.set((Object)y1);
        }
    }

    public static int getScreenX() {
        return screenX;
    }

    public static int getScreenY() {
        return screenY;
    }

    public static int getAppraisalOpacity() {
        return appraisalOpacity;
    }

    static {
        hudPositions = new int[2];
        skillOverlayPositions = new int[2];
        appraisalPosX = screenX;
        slot = 0;
        slotSwitch = 0;
    }
}

