/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler.client;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillClientUtils;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.effect.InsanityEffect;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.RequestRaceAndMountPacket;
import com.github.manasmods.tensura.network.play2server.skill.RequestChangeModeButtonPacket;
import com.github.manasmods.tensura.network.play2server.skill.RequestSkillNumberKeyPressPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class KeyInputHandler {
    @SubscribeEvent
    public static void checkKeybindings(InputEvent.Key e) {
        if (e.getAction() != 1) {
            return;
        }
        int key = e.getKey();
        if (key < 48 || key > 57) {
            return;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                ArrayList<ResourceLocation> packetSkills = new ArrayList<ResourceLocation>();
                for (ManasSkillInstance instance : SkillAPI.getSkillsFrom((Entity)player).getLearnedSkills()) {
                    if (!SkillClientUtils.isSkillHeldClient((LivingEntity)player, instance.getSkill())) continue;
                    packetSkills.add(instance.getSkillId());
                }
                int numberKey = key - 48;
                if (!packetSkills.isEmpty()) {
                    TensuraNetwork.INSTANCE.sendToServer((Object)new RequestSkillNumberKeyPressPacket(packetSkills, numberKey));
                } else if (TensuraKeybinds.NEXT_MODE_CHANGE.m_90857_()) {
                    TensuraNetwork.INSTANCE.sendToServer((Object)new RequestChangeModeButtonPacket((double)numberKey, false));
                }
            }
        });
    }

    @SubscribeEvent
    public static void clientMouseScrolled(InputEvent.MouseScrollingEvent event) {
        ITensuraMount mount;
        Entity entity;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (TensuraKeybinds.NEXT_MODE_CHANGE.m_90857_()) {
            TensuraNetwork.INSTANCE.sendToServer((Object)new RequestChangeModeButtonPacket(event.getScrollDelta(), true));
            event.setCanceled(true);
        } else if (minecraft.f_91066_.f_92091_.m_90857_() && (entity = player.m_20202_()) instanceof ITensuraMount && (mount = (ITensuraMount)entity).hasScrollAbility()) {
            TensuraNetwork.INSTANCE.sendToServer((Object)new RequestRaceAndMountPacket(event.getScrollDelta()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void movementInputUpdateEvent(MovementInputUpdateEvent event) {
        Player player = event.getEntity();
        boolean cannotJump = KeyInputHandler.cannotJump(player);
        if (!cannotJump) {
            return;
        }
        event.getInput().f_108572_ = false;
        event.getInput().f_108573_ = false;
    }

    private static boolean cannotJump(Player player) {
        if (InsanityEffect.havingNightmare((LivingEntity)player)) {
            return true;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.WEBBED.get())) {
            return true;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.FROST.get())) {
            return true;
        }
        MobEffectInstance paralysis = player.m_21124_((MobEffect)TensuraMobEffects.PARALYSIS.get());
        if (paralysis != null && paralysis.m_19564_() >= 2) {
            return true;
        }
        MobEffectInstance effect = player.m_21124_((MobEffect)TensuraMobEffects.MOVEMENT_INTERFERENCE.get());
        if (effect != null && effect.m_19564_() >= 5) {
            return true;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.LUST_EMBRACEMENT.get())) {
            return true;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
            return true;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.REST.get())) {
            return true;
        }
        return player.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get());
    }
}

