/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.client.TensuraClient;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestTotemDisplayPacket;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BattlewillManualItem
extends Item {
    public BattlewillManualItem() {
        super(new Item.Properties().m_41491_(TensuraCreativeTab.MISCELLANEOUS).m_41497_(TensuraRarity.UNIQUE).m_41486_().m_41487_(1));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.battlewill_manual").m_130940_(ChatFormatting.RED));
        if (((Boolean)DistExecutor.unsafeRunForDist(() -> TensuraClient::shiftDown, () -> () -> false)).booleanValue()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.battlewill_manual.description").m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.press.shift").m_130940_(ChatFormatting.GRAY));
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 10000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        if (player.m_36335_().m_41519_(stack.m_41720_()) && !player.m_150110_().f_35937_) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)pLivingEntity, (ParticleOptions)ParticleTypes.f_175830_);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level level, @NotNull LivingEntity entity, int pTimeLeft) {
        if (level.m_5776_()) {
            return;
        }
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (useTicks < 10) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.FORBIDDEN_MANUAL);
            if (!level.m_46469_().m_46207_(TensuraGameRules.EXPERIMENTAL_FEATURE)) {
                player.m_5661_((Component)Component.m_237110_((String)"tensura.item.scroll_not_allowed", (Object[])new Object[]{pStack.m_41786_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                pStack.m_41774_(1);
                return;
            }
            if (!player.m_150110_().f_35937_) {
                player.m_36335_().m_41524_(pStack.m_41720_(), 200);
                pStack.m_41774_(1);
            }
            BattlewillManualItem.randomBattlewill((Player)player);
            TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestTotemDisplayPacket(this.m_7968_()));
        }
    }

    public static void randomBattlewill(Player player) {
        List<ManasSkill> collection = BattlewillManualItem.getBattlewill();
        if (collection.isEmpty()) {
            return;
        }
        ManasSkill manasSkill = collection.get(player.m_217043_().m_188503_(collection.size()));
        TensuraSkillInstance instance = new TensuraSkillInstance(manasSkill);
        instance.setMastery(-100);
        if (SkillAPI.getSkillsFrom((Entity)player).learnSkill((ManasSkillInstance)instance)) {
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
            return;
        }
        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.already_have", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12507_, SoundSource.PLAYERS, 2.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
    }

    private static List<ManasSkill> getBattlewill() {
        return ((List)TensuraConfig.INSTANCE.artsConfig.battlewillManualList.get()).stream().map(skill -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill))).filter(Objects::nonNull).toList();
    }
}

