/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.client.DragonKnuckleItemRenderer;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DragonKnuckleItem
extends TieredItem
implements IAnimatable {
    private static final List<Enchantment> enchantmentList = ImmutableSet.of((Object)Enchantments.f_44978_, (Object)Enchantments.f_44979_, (Object)Enchantments.f_44981_, (Object)Enchantments.f_44980_, (Object)Enchantments.f_44977_, (Object)Enchantments.f_44982_, (Object[])new Enchantment[]{Enchantments.f_44984_, Enchantments.f_44987_, Enchantments.f_44985_}).asList();
    protected static final UUID DRAGON_KNUCKLES_DAMAGE_UUID = UUID.fromString("21739a26-a39a-11ed-a8fc-0242ac120002");
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public DragonKnuckleItem() {
        super(TensuraToolTiers.HIGH_MAGISTEEL, new Item.Properties().m_41497_(TensuraRarity.UNIQUE).m_41491_(TensuraCreativeTab.GEAR).m_41503_(4000).m_41486_());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        if (pEquipmentSlot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.builder().put((Object)Attributes.f_22281_, (Object)new AttributeModifier(DRAGON_KNUCKLES_DAMAGE_UUID, "Dragon Knuckle Modifier", -0.9, AttributeModifier.Operation.MULTIPLY_TOTAL)).put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -3.0, AttributeModifier.Operation.ADDITION)).build();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantmentList.contains(enchantment)) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return 20.0f;
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)entity;
            if (entity.f_19853_.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = new BlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (target.isShearable(stack, entity.f_19853_, pos)) {
                List drops = target.onSheared(playerIn, stack, entity.f_19853_, pos, this.getEnchantmentLevel(stack, Enchantments.f_44987_));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    if (ent == null) {
                        return;
                    }
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                entity.f_19853_.m_5594_(playerIn, pos, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                stack.m_41622_(1, (LivingEntity)playerIn, e -> e.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        ItemStack itemstack = pContext.m_43722_();
        Optional<BlockState> optionalTrigger = this.getToolAction(pContext, ToolActions.AXE_STRIP, SoundEvents.f_11688_);
        if (optionalTrigger.isEmpty() && (optionalTrigger = this.getToolAction(pContext, ToolActions.AXE_SCRAPE, SoundEvents.f_144059_)).isEmpty() && (optionalTrigger = this.getToolAction(pContext, ToolActions.AXE_WAX_OFF, SoundEvents.f_144060_)).isEmpty() && (optionalTrigger = this.getToolAction(pContext, ToolActions.SHOVEL_FLATTEN, SoundEvents.f_12406_)).isEmpty()) {
            optionalTrigger = this.getToolAction(pContext, ToolActions.SHEARS_CARVE, SoundEvents.f_12296_);
        }
        if (optionalTrigger.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, optionalTrigger.get(), 11);
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, pPlayer -> pPlayer.m_21190_(pContext.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private Optional<BlockState> getToolAction(UseOnContext pContext, ToolAction toolAction, SoundEvent soundEvent) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (Optional.ofNullable(blockstate.getToolModifiedState(pContext, toolAction, false)).isPresent()) {
            level.m_5594_(player, blockpos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            return Optional.ofNullable(blockstate.getToolModifiedState(pContext, toolAction, false));
        }
        return Optional.empty();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction)) {
            return true;
        }
        if (ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction)) {
            return true;
        }
        if (ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction)) {
            return true;
        }
        if (ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction)) {
            return true;
        }
        if (ToolActions.HOE_DIG.equals(toolAction)) {
            return true;
        }
        return ToolActions.SHEARS_CARVE.equals(toolAction);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)state);
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (!pLevel.f_46443_ && pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(1, pEntityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public void registerControllers(AnimationData data) {
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final DragonKnuckleItemRenderer renderer = new DragonKnuckleItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

