/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.api.item.dispensing.TensuraDispenseBehaviors;
import com.github.manasmods.tensura.entity.projectile.KunaiProjectile;
import com.github.manasmods.tensura.item.templates.custom.TensuraLongSword;
import com.google.common.collect.ImmutableSet;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class KunaiItem
extends TensuraLongSword {
    protected static final List<Enchantment> addedEnchantmentList = ImmutableSet.of((Object)Enchantments.f_44961_, (Object)Enchantments.f_44956_, (Object)Enchantments.f_44989_, (Object)Enchantments.f_44959_, (Object)Enchantments.f_44986_, (Object)Enchantments.f_44962_, (Object[])new Enchantment[]{Enchantments.f_44963_, Enchantments.f_44955_}).asList();
    protected static final List<Enchantment> removedEnchantmentList = ImmutableSet.of((Object)Enchantments.f_44983_, (Object)Enchantments.f_44980_, (Object)Enchantments.f_44982_).asList();
    protected float baseProjectileDamage;

    public KunaiItem(Tier pTier, float baseProjectileDamage, Item.Properties pProperties) {
        super(pTier, 1, -2.3f, -1.0, 0.0, 0.5, pProperties);
        this.baseProjectileDamage = baseProjectileDamage;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)TensuraDispenseBehaviors.DISPENSE_KUNAI_BEHAVIOR);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.getEnchantmentLevel(Enchantments.f_44955_) > 0 && enchantment.equals(Enchantments.f_44959_)) {
            return false;
        }
        if (stack.getEnchantmentLevel(Enchantments.f_44959_) > 0 && enchantment.equals(Enchantments.f_44955_)) {
            return false;
        }
        if (removedEnchantmentList.contains(enchantment)) {
            return false;
        }
        if (addedEnchantmentList.contains(enchantment)) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ToolAction toolAction) {
        if (ToolActions.SWORD_SWEEP.equals(toolAction)) {
            return false;
        }
        if (ToolActions.SHEARS_CARVE.equals(toolAction)) {
            return true;
        }
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack pStack) {
        return 10000;
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLiving, int pTimeLeft) {
        if (!(pLiving instanceof Player)) {
            return;
        }
        Player player = (Player)pLiving;
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (useTicks < 7) {
            return;
        }
        if (!pLevel.f_46443_) {
            boolean left = player.m_7655_() == InteractionHand.OFF_HAND && player.m_5737_() == HumanoidArm.RIGHT || player.m_7655_() == InteractionHand.MAIN_HAND && player.m_5737_() == HumanoidArm.LEFT;
            this.kunaiShooting(pLevel, player, pStack, !left, 0, false);
            int multishotLevel = pStack.getEnchantmentLevel(Enchantments.f_44959_);
            for (int i = 0; i < multishotLevel; ++i) {
                this.kunaiShooting(pLevel, player, pStack, !left, i + 1, false);
                this.kunaiShooting(pLevel, player, pStack, !left, i + 1, true);
            }
            pLevel.m_6269_(null, (Entity)player, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                pStack.m_41774_(1);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public void kunaiShooting(Level pLevel, Player player, ItemStack pStack, boolean right, int multishotLevel, boolean negativeAngle) {
        KunaiProjectile kunai = new KunaiProjectile(pLevel, (LivingEntity)player, pStack, right);
        Vector3f vector3f = new Vector3f(player.m_20252_(2.0f));
        if (multishotLevel > 0) {
            vector3f.m_122251_(new Quaternion(new Vector3f(player.m_20289_(1.0f)), negativeAngle ? -10.0f * (float)multishotLevel : 10.0f * (float)multishotLevel, true));
            kunai.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            kunai.setMultishot(Boolean.TRUE);
        } else if (player.m_150110_().f_35937_) {
            kunai.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        kunai.getSourceItem().m_41764_(1);
        kunai.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 2.2f, 0.0f);
        player.m_6674_(player.m_7655_());
        pLevel.m_7967_((Entity)kunai);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public float getBaseProjectileDamage() {
        return this.baseProjectileDamage;
    }
}

