/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.api.item.dispensing.TensuraDispenseBehaviors;
import com.github.manasmods.tensura.entity.projectile.KunaiProjectile;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.custom.KunaiItem;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.google.common.collect.ImmutableSet;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.jetbrains.annotations.NotNull;

public class MagisteelKunaiItem
extends KunaiItem {
    protected static final List<Enchantment> addedEnchantmentList = ImmutableSet.of((Object)Enchantments.f_44961_, (Object)Enchantments.f_44956_, (Object)Enchantments.f_44989_, (Object)Enchantments.f_44959_, (Object)Enchantments.f_44986_, (Object)Enchantments.f_44962_, (Object[])new Enchantment[]{Enchantments.f_44963_}).asList();

    public MagisteelKunaiItem(Tier pTier, float baseProjectileDamage, int durability) {
        super(pTier, baseProjectileDamage, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41503_(durability).m_41497_(TensuraRarity.UNIQUE).m_41486_());
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)TensuraDispenseBehaviors.DISPENSE_MAGISTEEL_KUNAI_BEHAVIOR);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (removedEnchantmentList.contains(enchantment)) {
            return false;
        }
        if (addedEnchantmentList.contains(enchantment)) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @Override
    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLiving, int pTimeLeft) {
        if (!(pLiving instanceof Player)) {
            return;
        }
        Player player = (Player)pLiving;
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (useTicks < 7) {
            return;
        }
        if (!pLevel.f_46443_) {
            boolean left = player.m_7655_() == InteractionHand.OFF_HAND && player.m_5737_() == HumanoidArm.RIGHT || player.m_7655_() == InteractionHand.MAIN_HAND && player.m_5737_() == HumanoidArm.LEFT;
            this.magisteelKunaiShooting(pLevel, player, pStack, !left, 0, false);
            int multishotLevel = pStack.getEnchantmentLevel(Enchantments.f_44959_);
            for (int i = 0; i < multishotLevel; ++i) {
                this.magisteelKunaiShooting(pLevel, player, pStack, !left, i + 1, false);
                this.magisteelKunaiShooting(pLevel, player, pStack, !left, i + 1, true);
            }
            pStack.m_41622_(10, (LivingEntity)player, pPlayer -> pPlayer.m_21190_(player.m_7655_()));
            pLevel.m_6269_(null, (Entity)player, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public void magisteelKunaiShooting(Level pLevel, Player player, ItemStack pStack, boolean right, int multishotLevel, boolean negativeAngle) {
        KunaiProjectile kunai = new KunaiProjectile(pLevel, (LivingEntity)player, pStack, right);
        Vector3f vector3f = new Vector3f(player.m_20252_(2.0f));
        kunai.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        kunai.setMultishot(Boolean.TRUE);
        if (multishotLevel > 0) {
            vector3f.m_122251_(new Quaternion(new Vector3f(player.m_20289_(1.0f)), negativeAngle ? -10.0f * (float)multishotLevel : 10.0f * (float)multishotLevel, true));
        } else if (player.m_150110_().f_35937_) {
            kunai.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        kunai.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 2.2f, 0.0f);
        player.m_6674_(player.m_7655_());
        pLevel.m_7967_((Entity)kunai);
    }
}

