/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.misc.ChaosEaterProjectile;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MeatCrusherItem
extends TwoHandedLongSword {
    public MeatCrusherItem() {
        super(TensuraToolTiers.HIGH_MAGISTEEL, 9, -3.0f, 0.5, 0.0, 0.0, 7, -3.2f, 50.0, 25.0, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41486_().m_41497_(TensuraRarity.UNIQUE));
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack pStack) {
        return 10000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (stack.getEnchantmentLevel((Enchantment)TensuraEnchantments.SOUL_EATER.get()) > 0 && SkillUtils.isSkillToggled((Entity)player, (ManasSkill)UniqueSkills.STARVED.get())) {
            this.summonChaosEater((LivingEntity)player, 4, 1.0f);
            player.m_21011_(player.m_7655_(), true);
            if (this.isStarvedMastered(player, stack)) {
                player.m_36335_().m_41524_(stack.m_41720_(), 100);
            } else {
                player.m_36335_().m_41524_(stack.m_41720_(), 40);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        player.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level level, @NotNull LivingEntity entity, int pTimeLeft) {
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (useTicks < 7) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_(pStack.m_41720_(), 40);
            if (!player.m_150110_().f_35937_) {
                pStack.m_41622_(10, (LivingEntity)player, pPlayer -> pPlayer.m_21190_(pPlayer.m_7655_()));
            }
        }
        entity.m_21011_(entity.m_7655_(), true);
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(2.0));
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        Vec3 sourceToTarget = target.m_82546_(source);
        Vec3 normalizes = sourceToTarget.m_82541_();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215778_, SoundSource.PLAYERS, 1.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)sourceToTarget.m_82553_()); ++particleIndex) {
            AABB aabb;
            List list;
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            TensuraParticleHelper.spawnParticlesLikeServer(level, (ParticleOptions)ParticleTypes.f_123813_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, false);
            if (TensuraGameRules.canSkillGrief(level)) {
                SkillHelper.launchBlock((Entity)entity, particlePos, 2, 1, 0.3f, 0.2f, blockState -> {
                    if (entity.m_217043_().m_188503_(2) != 1) {
                        return false;
                    }
                    return blockState.m_204336_(TensuraTags.Blocks.EARTH_MANIPULATING);
                }, pos -> !pos.equals((Object)entity.m_20097_()) && !pos.equals((Object)entity.m_20097_().m_7495_()));
            }
            if ((list = level.m_6443_(LivingEntity.class, aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(3.0), entityData -> !entityData.m_7306_((Entity)entity))).isEmpty()) continue;
            for (LivingEntity living : list) {
                TensuraDamageSource damageSource;
                if (!living.m_6469_((DamageSource)(damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)entity), 200.0, null)), (float)entity.m_21133_(Attributes.f_22281_))) continue;
                SkillHelper.checkThenAddEffectSource(living, (Entity)entity, (MobEffect)TensuraMobEffects.CORROSION.get(), 60, 1);
                TensuraParticleHelper.spawnServerGroundSlamParticle(living, 10, 2.0f);
                living.m_20184_().m_82520_(0.0, 0.3, 0.0);
            }
        }
    }

    private boolean isStarvedMastered(Player player, ItemStack stack) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        stack.m_41622_(10, (LivingEntity)player, pPlayer -> pPlayer.m_21190_(pPlayer.m_7655_()));
        return SkillUtils.isSkillMastered((LivingEntity)player, (ManasSkill)UniqueSkills.STARVED.get());
    }

    private void summonChaosEater(LivingEntity entity, int amount, float distance) {
        int rot = 360 / amount;
        for (int i = 0; i < amount; ++i) {
            List<LivingEntity> list;
            Vec3 offset = new Vec3(0.0, (double)distance, 0.0).m_82535_(((float)(rot * i) - (float)rot / 2.0f) * ((float)Math.PI / 180)).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            Vec3 offPos = entity.m_146892_().m_82549_(offset);
            ChaosEaterProjectile chaosEater = new ChaosEaterProjectile(entity.m_9236_(), entity);
            chaosEater.m_146884_(offPos);
            chaosEater.setUpStartPos(amount, i, distance);
            LivingEntity target = SkillHelper.getTargetingEntity(entity, 20.0, false);
            if (entity.m_6144_() && !(list = this.getTargetList(entity)).isEmpty()) {
                target = list.get(entity.m_217043_().m_188503_(list.size()));
            }
            chaosEater.setTarget(target);
            chaosEater.setSpeed(1.0f);
            chaosEater.shootFromRot(entity.m_20154_());
            chaosEater.setLife(300);
            chaosEater.setDamage((float)entity.m_21133_(Attributes.f_22281_));
            chaosEater.setMobEffect(new MobEffectInstance((MobEffect)TensuraMobEffects.CORROSION.get(), 200, 1, false, false, false));
            chaosEater.setEffectRange(1.5f);
            chaosEater.setMpCost(100.0);
            chaosEater.setSkill(SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)UniqueSkills.STARVED.get()));
            entity.m_9236_().m_7967_((Entity)chaosEater);
        }
    }

    private List<LivingEntity> getTargetList(LivingEntity owner) {
        AABB box = owner.m_20191_().m_82400_(20.0);
        return owner.m_9236_().m_6443_(LivingEntity.class, box, entity -> this.shouldAttack((LivingEntity)entity, owner));
    }

    protected boolean shouldAttack(LivingEntity entity, LivingEntity owner) {
        Player player;
        if (entity.m_7307_((Entity)owner) || owner.m_7307_((Entity)entity)) {
            return false;
        }
        return !(entity instanceof Player) || !(player = (Player)entity).m_7500_() && !player.m_5833_();
    }
}

