/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.RemoveSkillEvent;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.Magic;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.ability.skill.unique.CookSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.capability.smithing.ISmithingCapability;
import com.github.manasmods.tensura.capability.smithing.SmithingCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.menu.RaceSelectionMenu;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestTotemDisplayPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.TensuraStats;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.github.manasmods.tensura.world.savedata.UniqueSkillSaveData;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResetScrollItem
extends Item {
    private final ResetType resetType;

    public ResetScrollItem(ResetType resetType) {
        super(new Item.Properties().m_41491_(TensuraCreativeTab.MISCELLANEOUS).m_41497_(TensuraRarity.UNIQUE).m_41487_(1));
        this.resetType = resetType;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)this.getResetType().tooltip).m_130940_(ChatFormatting.DARK_AQUA));
        if (this.getResetType().equals((Object)ResetType.RESET_SKILL)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.reset_scroll.skill_warning").m_130940_(ChatFormatting.RED));
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 10000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        if (player.m_36335_().m_41519_(stack.m_41720_()) && !player.m_150110_().f_35937_) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)pLivingEntity, (ParticleOptions)ParticleTypes.f_123809_);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level level, @NotNull LivingEntity entity, int pTimeLeft) {
        if (level.m_5776_()) {
            return;
        }
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (useTicks < 10) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (level.m_46472_().equals(TensuraDimensions.LABYRINTH) || level.m_46472_().equals(TensuraDimensions.HELL)) {
                player.m_5661_((Component)Component.m_237110_((String)"tooltip.tensura.reset_scroll.not_safe", (Object[])new Object[]{pStack.m_41786_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            if (!player.m_150110_().f_35937_) {
                if (this.isNotAllowed()) {
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.item.scroll_not_allowed", (Object[])new Object[]{pStack.m_41786_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    return;
                }
                player.m_36335_().m_41524_(pStack.m_41720_(), 2400);
                pStack.m_41774_(1);
            }
            if (ResetScrollItem.isFullReset(player)) {
                int penalty;
                if (this.getResetType().equals((Object)ResetType.RESET_ALL)) {
                    TensuraPlayerCapability.increaseResetCounter((Player)player, 1);
                } else if (((Boolean)TensuraConfig.INSTANCE.skillsConfig.counterPenaltyNonCharScroll.get()).booleanValue() && (penalty = level.m_46469_().m_46215_(TensuraGameRules.RESET_INCOMPLETE_PENALTY)) > 0) {
                    TensuraPlayerCapability.increaseResetCounter((Player)player, penalty * -1);
                }
            } else {
                int penalty = level.m_46469_().m_46215_(TensuraGameRules.RESET_INCOMPLETE_PENALTY);
                if (penalty > 0) {
                    TensuraPlayerCapability.increaseResetCounter((Player)player, penalty * -1);
                }
            }
            this.getResetType().contextConsumer.accept(player);
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.REWIND_TIME);
            TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestTotemDisplayPacket(this.m_7968_()));
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123767_, 1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
        }
    }

    private boolean isNotAllowed() {
        List<Item> list = ((List)TensuraConfig.INSTANCE.itemsConfig.allowedScrolls.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(Objects::nonNull).toList();
        return !list.contains((Object)this);
    }

    public static void resetFlight(Player player) {
        if ((player.m_150110_().f_35935_ || player.m_150110_().f_35936_) && !SkillUtils.canFlyLegit(player)) {
            player.m_150110_().f_35935_ = false;
            player.m_150110_().f_35936_ = false;
            player.m_6885_();
        }
    }

    public static void resetRaceFailsafe(Player player) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.getRace() == null) {
                return;
            }
            cap.setRace((LivingEntity)player, (Race)TensuraRaces.HUMAN.get(), true);
        });
    }

    public static void resetEverything(ServerPlayer player) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Iterator iterator = storage.getLearnedSkills().iterator();
        while (iterator.hasNext()) {
            TensuraSkillInstance instance;
            Object e = iterator.next();
            if (!(e instanceof TensuraSkillInstance) || MinecraftForge.EVENT_BUS.post((Event)new RemoveSkillEvent((ManasSkillInstance)(instance = (TensuraSkillInstance)((Object)e)), (Entity)player))) continue;
            iterator.remove();
            if (player.f_19853_.m_7654_() == null) continue;
            UniqueSkillSaveData saveData = UniqueSkillSaveData.get(player.f_19853_.m_7654_().m_129783_());
            if (instance.getSkill().getRegistryName() == null || !saveData.hasSkill(instance.getSkill().getRegistryName())) continue;
            saveData.removeSkill(instance.getSkill().getRegistryName());
        }
        storage.syncAll();
        CookSkill.removeCookedHP((LivingEntity)player, null);
        TensuraPlayerCapability.resetEverything((Player)player);
        TensuraEPCapability.resetEverything((LivingEntity)player);
        TensuraSkillCapability.resetEverything((Player)player, true, true);
        TensuraEffectsCapability.resetEverything((LivingEntity)player, true, true);
        MinecraftServer server = player.m_20194_();
        if (server != null) {
            ServerStatsCounter stats = server.m_6846_().m_11239_((Player)player);
            stats.m_12850_();
            for (Stat stat : stats.m_12851_()) {
                stats.m_6085_((Player)player, stat, 0);
            }
        }
        SmithingCapability.getFrom((Player)player).ifPresent(ISmithingCapability::clearSchematics);
        SmithingCapability.sync((Player)player);
        TensuraAdvancementsHelper.revokeAllTensuraAdvancements(player);
        player.m_9158_(Level.f_46428_, null, 0.0f, false, false);
        ResetScrollItem.resetRaceFailsafe((Player)player);
        if (player.m_9236_().m_46469_().m_46207_(TensuraGameRules.RIMURU_MODE)) {
            RaceSelectionMenu.reincarnateAsRimuru((Player)player);
        } else {
            player.m_20331_(true);
            List<ResourceLocation> races = TensuraPlayerCapability.loadRaces();
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider(RaceSelectionMenu::new, (Component)Component.m_237115_((String)"tensura.race.selection")), buf -> {
                buf.writeBoolean(false);
                buf.m_236828_((Collection)races, FriendlyByteBuf::m_130085_);
            });
            if (player.m_9236_().m_46469_().m_46207_(TensuraGameRules.SKILL_BEFORE_RACE)) {
                RaceSelectionMenu.grantUniqueSkill((Player)player);
            }
        }
        RaceSelectionMenu.grantLearningResistance((LivingEntity)player);
        ResetScrollItem.resetFlight((Player)player);
    }

    public static void resetRace(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server != null) {
            ServerStatsCounter stats = server.m_6846_().m_11239_((Player)player);
            stats.m_12850_();
            for (Stat stat : stats.m_12851_()) {
                stats.m_6085_((Player)player, stat, 0);
            }
        }
        ResetScrollItem.resetRaceFailsafe((Player)player);
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            if (cap.getRace() != null) {
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                Iterator iterator = storage.getLearnedSkills().iterator();
                while (iterator.hasNext()) {
                    Object patt12668$temp = iterator.next();
                    if (!(patt12668$temp instanceof TensuraSkillInstance)) continue;
                    TensuraSkillInstance instance = (TensuraSkillInstance)((Object)((Object)patt12668$temp));
                    if (!ResetScrollItem.isIntrinsicSkills((Player)player, cap, cap.getRace(), instance) && !(instance.getSkill() instanceof Magic) && !(instance.getSkill() instanceof ResistSkill) || MinecraftForge.EVENT_BUS.post((Event)new RemoveSkillEvent((ManasSkillInstance)instance, (Entity)player))) continue;
                    iterator.remove();
                }
                storage.syncAll();
            }
            cap.clearIntrinsicSkills();
            TensuraPlayerCapability.resetEverything((Player)player);
            if (SkillUtils.hasSkill((Entity)player, (ManasSkill)UniqueSkills.CHOSEN_ONE.get())) {
                cap.setBlessed(true);
                TensuraPlayerCapability.sync((Player)player);
            }
        });
        CookSkill.removeCookedHP((LivingEntity)player, null);
        TensuraEPCapability.resetEverything((LivingEntity)player);
        TensuraSkillCapability.resetEverything((Player)player, false, true);
        TensuraEffectsCapability.resetEverything((LivingEntity)player, true, true);
        player.m_9158_(Level.f_46428_, null, 0.0f, false, false);
        List<ResourceLocation> races = TensuraPlayerCapability.loadRaces();
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider(RaceSelectionMenu::new, (Component)Component.m_237115_((String)"tensura.race.selection")), buf -> {
            buf.writeBoolean(true);
            buf.m_236828_((Collection)races, FriendlyByteBuf::m_130085_);
        });
        RaceSelectionMenu.grantLearningResistance((LivingEntity)player);
        ResetScrollItem.resetFlight((Player)player);
    }

    public static void resetSkill(ServerPlayer player) {
        ResetScrollItem.resetSkill(player, false);
    }

    public static void resetSkill(ServerPlayer player, boolean coverEP) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Iterator iterator = storage.getLearnedSkills().iterator();
        while (iterator.hasNext()) {
            Race race;
            Object e = iterator.next();
            if (!(e instanceof TensuraSkillInstance)) continue;
            TensuraSkillInstance instance = (TensuraSkillInstance)((Object)e);
            ManasSkill skill = instance.getSkill();
            if (instance.getSkill() instanceof Magic || (race = TensuraPlayerCapability.getRace((LivingEntity)player)) != null && race.isIntrinsicSkill((Player)player, skill) || TensuraPlayerCapability.getIntrinsicList((Player)player).contains(SkillUtils.getSkillId(skill)) || MinecraftForge.EVENT_BUS.post((Event)new RemoveSkillEvent((ManasSkillInstance)instance, (Entity)player))) continue;
            iterator.remove();
            if (player.f_19853_.m_7654_() == null) continue;
            UniqueSkillSaveData saveData = UniqueSkillSaveData.get(player.f_19853_.m_7654_().m_129783_());
            if (skill.getRegistryName() == null || !saveData.hasSkill(skill.getRegistryName())) continue;
            saveData.removeSkill(skill.getRegistryName());
        }
        storage.syncAll();
        TensuraSkillCapability.resetEverything((Player)player, true, false);
        RaceSelectionMenu.randomUniqueSkill((Player)player, coverEP);
        RaceSelectionMenu.grantLearningResistance((LivingEntity)player);
        ResetScrollItem.resetFlight((Player)player);
        TensuraSkillCapability.getFrom((Player)player).ifPresent(cap -> {
            cap.setWaterPoint(0.0);
            cap.setLavaPoint(0.0);
            cap.clearAllWarp();
        });
        TensuraSkillCapability.sync((Player)player);
    }

    public static boolean isIntrinsicSkills(Player player, @Nullable ITensuraPlayerCapability cap, @Nullable Race race, ManasSkillInstance skill) {
        if (skill.isTemporarySkill()) {
            return true;
        }
        if (race == null) {
            return false;
        }
        if (race.isIntrinsicSkill(player, skill.getSkill())) {
            return true;
        }
        return cap != null && cap.getIntrinsicSkills().contains(SkillUtils.getSkillId(skill.getSkill()));
    }

    public static boolean isFullReset(ServerPlayer player) {
        Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (race == null) {
            return false;
        }
        if (!race.getNextEvolutions((Player)player).isEmpty()) {
            return false;
        }
        if (player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.ORC_DISASTER.get()))) <= 0) {
            return false;
        }
        if (player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.IFRIT.get()))) <= 0) {
            return false;
        }
        if (player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.CHARYBDIS.get()))) <= 0) {
            return false;
        }
        if (player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.ELEMENTAL_COLOSSUS.get()))) <= 0) {
            return false;
        }
        if (player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)TensuraEntityTypes.HINATA_SAKAGUCHI.get()))) <= 0) {
            return false;
        }
        return TensuraPlayerCapability.isTrueHero((LivingEntity)player) || TensuraPlayerCapability.isTrueDemonLord((Player)player);
    }

    public ResetType getResetType() {
        return this.resetType;
    }

    public static enum ResetType {
        RESET_RACE(ResetScrollItem::resetRace, "tooltip.tensura.reset_scroll.race"),
        RESET_SKILL(ResetScrollItem::resetSkill, "tooltip.tensura.reset_scroll.skill"),
        RESET_ALL(ResetScrollItem::resetEverything, "tooltip.tensura.reset_scroll.character");

        private final Consumer<ServerPlayer> contextConsumer;
        private final String tooltip;

        private ResetType(Consumer<ServerPlayer> contextConsumer, String tooltip) {
            this.contextConsumer = contextConsumer;
            this.tooltip = tooltip;
        }
    }

    public static enum ResetCounterType {
        COPPER(1, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/copper_reset_medal.png")),
        IRON(2, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/iron_reset_medal.png")),
        GOLD(3, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/gold_reset_medal.png")),
        DIAMOND(4, Color.BLACK, new ResourceLocation("tensura", "textures/gui/reset_medals/diamond_reset_medal.png")),
        MITHRIL(5, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/mithril_reset_medal.png")),
        ORICHALCUM(6, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/orichalcum_reset_medal.png")),
        MAGISTEEL(7, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/magisteel_reset_medal.png")),
        ADAMANTITE(8, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/adamantite_reset_medal.png")),
        HIHIIROKANE(9, Color.WHITE, new ResourceLocation("tensura", "textures/gui/reset_medals/hihiirokane_reset_medal.png"));

        private final int level;
        private final Color textColor;
        private final ResourceLocation textureLocation;

        public static ResetCounterType get(int point) {
            if (point >= 64) {
                return HIHIIROKANE;
            }
            if (point >= 50) {
                return ADAMANTITE;
            }
            if (point >= 40) {
                return MAGISTEEL;
            }
            if (point >= 30) {
                return ORICHALCUM;
            }
            if (point >= 20) {
                return MITHRIL;
            }
            if (point >= 10) {
                return DIAMOND;
            }
            if (point >= 5) {
                return GOLD;
            }
            if (point >= 3) {
                return IRON;
            }
            return COPPER;
        }

        public int getLevel() {
            return this.level;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }

        private ResetCounterType(int level, Color textColor, ResourceLocation textureLocation) {
            this.level = level;
            this.textColor = textColor;
            this.textureLocation = textureLocation;
        }
    }
}

