/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.entity.SlimeEntity;
import com.github.manasmods.tensura.entity.variant.SlimeType;
import com.github.manasmods.tensura.entity.variant.SlimeVariant;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.WandItem;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SlimeStaffItem
extends WandItem {
    public SlimeStaffItem() {
        super(TensuraToolTiers.HIGH_MAGISTEEL, 2, -3.0f, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41503_(2552).m_41497_(Rarity.EPIC));
    }

    @Override
    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pTarget.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 30, 0, false, false, false), (Entity)pAttacker);
        pTarget.m_5496_(SoundEvents.f_12384_, 1.0f, 1.0f);
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        Level level = context.m_43725_();
        double xPos = context.m_43720_().f_82479_;
        double yPos = context.m_43720_().f_82480_;
        double zPos = context.m_43720_().f_82481_;
        if (player.m_36341_()) {
            if (!level.m_5776_()) {
                List list = level.m_6443_(SlimeEntity.class, player.m_20191_().m_82400_(25.0), entity -> entity.m_21830_((LivingEntity)player) && !entity.m_21827_());
                if (list.isEmpty()) {
                    return super.m_6225_(context);
                }
                context.m_43722_().m_41622_(100, (LivingEntity)player, p -> {});
                for (SlimeEntity slime : list) {
                    slime.m_19877_();
                    slime.m_6027_(xPos, yPos, zPos);
                    player.m_5496_(SoundEvents.f_11757_, 0.8f, 0.8f);
                }
            }
        } else if (player.m_150110_().f_35937_ || !player.m_36335_().m_41519_((Item)this)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                context.m_43722_().m_41622_(200, (LivingEntity)player, p -> {});
                SlimeEntity slime = new SlimeEntity((EntityType<? extends SlimeEntity>)((EntityType)TensuraEntityTypes.SLIME.get()), level);
                slime.m_6034_(xPos, yPos, zPos);
                slime.m_6518_((ServerLevelAccessor)serverlevel, serverlevel.m_6436_(slime.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                Random r = new Random();
                int variant = r.nextInt(4);
                slime.setVariant(SlimeVariant.byId(variant));
                slime.setSize(3, true);
                slime.setType(SlimeType.byId(2));
                slime.m_21828_(player);
                level.m_7967_((Entity)slime);
                slime.m_5496_(SoundEvents.f_12418_, 0.8f, 0.8f);
                slime.slimeProduceTime = 3600;
            }
            if (!player.m_150110_().f_35937_) {
                player.m_36335_().m_41524_((Item)this, 20);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, xPos + 0.5, yPos + 0.5, zPos + 0.5, 0.0, 0.05, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, xPos - 0.5, yPos + 0.5, zPos + 0.5, 0.0, 0.05, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, xPos - 0.5, yPos + 0.5, zPos - 0.5, 0.0, 0.05, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, xPos + 0.5, yPos + 0.5, zPos - 0.5, 0.0, 0.05, 0.0);
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        BlockHitResult hitresult = SlimeStaffItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (!hitresult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
            if (pPlayer.m_36341_()) {
                List list = pLevel.m_6443_(SlimeEntity.class, pPlayer.m_20191_().m_82400_(25.0), entity -> entity.m_21830_((LivingEntity)pPlayer));
                if (list.isEmpty()) {
                    return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
                }
                CompoundTag tag = pPlayer.m_21120_(pUsedHand).m_41783_();
                if (tag != null) {
                    tag.m_128379_("Sit", !tag.m_128471_("Sit"));
                    for (SlimeEntity slime : list) {
                        slime.m_21839_(tag.m_128471_("Sit"));
                        if (!slime.m_21827_()) continue;
                        slime.f_20899_ = false;
                        slime.m_21573_().m_26573_();
                        slime.m_6710_(null);
                    }
                    if (tag.m_128471_("Sit")) {
                        pPlayer.m_5661_((Component)Component.m_237115_((String)"tensura.message.slime_staff.sit"), true);
                    } else {
                        pPlayer.m_5661_((Component)Component.m_237115_((String)"tensura.message.slime_staff.follow"), true);
                    }
                    pPlayer.m_5496_(SoundEvents.f_11887_, 0.8f, 0.8f);
                    pPlayer.m_21120_(pUsedHand).m_41622_(1, (LivingEntity)Objects.requireNonNull(pPlayer), player -> {});
                    pPlayer.m_6674_(pUsedHand);
                }
            } else {
                Player player2;
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)pPlayer, 32.0, true, false);
                if (target == null) {
                    return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
                }
                if (target instanceof Player && ((player2 = (Player)target).m_7500_() || player2.m_5833_())) {
                    return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
                }
                List list = pLevel.m_6443_(SlimeEntity.class, pPlayer.m_20191_().m_82400_(25.0), entity -> entity.m_21830_((LivingEntity)pPlayer));
                if (list.isEmpty()) {
                    return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
                }
                for (SlimeEntity slime : list) {
                    slime.m_21839_(Boolean.FALSE);
                    slime.m_6710_(target);
                }
                pPlayer.m_5496_(SoundEvents.f_11887_, 0.8f, 0.8f);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 0, false, false, false));
                pPlayer.m_21120_(pUsedHand).m_41622_(1, (LivingEntity)Objects.requireNonNull(pPlayer), player -> {});
                pPlayer.m_6674_(pUsedHand);
                return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pUsedHand));
            }
        }
        return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pUsedHand));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == TensuraMobDropItems.SLIME_CHUNK.get();
    }
}

