/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.client.TensuraClient;
import com.github.manasmods.tensura.enchantment.SlottingEnchantment;
import com.github.manasmods.tensura.entity.projectile.SevererBladeProjectile;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TensuraSword;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpatialBladeItem
extends TensuraSword {
    private final Random random = new Random();
    private static final List<Enchantment> enchantmentList = ImmutableSet.of((Object)Enchantments.f_44961_, (Object)Enchantments.f_44956_, (Object)Enchantments.f_44958_).asList();

    public SpatialBladeItem() {
        super(TensuraToolTiers.HIGH_MAGISTEEL, -4, -2.4f, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41503_(2500).m_41497_(Rarity.RARE).m_41486_());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (((Boolean)DistExecutor.unsafeRunForDist(() -> TensuraClient::shiftDown, () -> () -> false)).booleanValue()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.spatial_blade.tooltip.blade").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.spatial_blade.tooltip.hilt").m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.press.shift").m_130940_(ChatFormatting.GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                return super.getAttributeModifiers(slot, stack);
            }
            if (!tag.m_128471_("hilt_mode")) {
                return ImmutableMultimap.builder().put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 9.0, AttributeModifier.Operation.ADDITION)).put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION)).build();
            }
            if (tag.m_128471_("hilt_mode")) {
                return ImmutableMultimap.builder().put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 1.0, AttributeModifier.Operation.ADDITION)).put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION)).put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(UUID.fromString("60882508-a398-11ed-a8fc-0242ac120002"), "Weapon modifier", -1.0, AttributeModifier.Operation.ADDITION)).build();
            }
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public ItemStack findAmmo(Player entity) {
        if (entity.m_7500_()) {
            return new ItemStack((ItemLike)TensuraToolItems.SEVERER_BLADE.get());
        }
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)UniqueSkills.SEVERER.get()) && !SkillHelper.outOfMagicule((LivingEntity)entity, 20.0)) {
            return new ItemStack((ItemLike)TensuraToolItems.SEVERER_BLADE.get());
        }
        for (int i = 0; i < entity.m_150109_().m_6643_(); ++i) {
            ItemStack stack = entity.m_150109_().m_8020_(i);
            if (!stack.m_150930_((Item)TensuraToolItems.SEVERER_BLADE.get())) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantmentList.contains(enchantment) || enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ToolAction toolAction) {
        if (ToolActions.SWORD_SWEEP.equals(toolAction)) {
            return !stack.m_41784_().m_128471_("hilt_mode");
        }
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (SlottingEnchantment.getContentWeight(stack) > 0 && !player.m_36341_()) {
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_("dummy") && SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)UniqueSkills.SEVERER.get()).isEmpty()) {
            stack.m_41622_(stack.m_41776_(), (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ItemStack ammo = this.findAmmo(player);
        if (!level.f_46443_ && !tag.m_128471_("hilt_mode")) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 0.4f + (this.random.nextFloat() * 0.4f + 0.8f));
            boolean left = hand == InteractionHand.OFF_HAND && player.m_5737_() == HumanoidArm.RIGHT || hand == InteractionHand.MAIN_HAND && player.m_5737_() == HumanoidArm.LEFT;
            SevererBladeProjectile blade = new SevererBladeProjectile(level, (LivingEntity)player, !left, stack);
            if (EnchantmentHelper.m_44914_((LivingEntity)player) > 0) {
                blade.m_20254_(600);
            }
            Vector3f vector3f = new Vector3f(player.m_20252_(1.0f));
            blade.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 3.0f, 0.0f);
            level.m_7967_((Entity)blade);
            stack.m_41622_(20, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            tag.m_128379_("hilt_mode", true);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        if (tag.m_128471_("hilt_mode") && !ammo.m_41619_()) {
            tag.m_128379_("hilt_mode", false);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11677_, SoundSource.PLAYERS, 0.5f, 0.4f + (this.random.nextFloat() * 0.4f + 0.8f));
            ammo.m_41774_(1);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity pEntity) {
        CompoundTag tag = itemstack.m_41784_();
        if (tag.m_128471_("dummy") && SkillAPI.getSkillsFrom((Entity)pEntity).getSkill((ManasSkill)UniqueSkills.SEVERER.get()).isEmpty()) {
            itemstack.m_41622_(itemstack.m_41776_(), pEntity, player -> player.m_21190_(pEntity.m_7655_()));
            return false;
        }
        return super.onEntitySwing(itemstack, pEntity);
    }
}

