/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VortexSpearItem
extends TwoHandedLongSword {
    public VortexSpearItem() {
        super(TensuraToolTiers.PURE_MAGISTEEL, 3, -2.6f, 1.0, 0.0, 0.0, 2, -2.8f, 0.0, 0.0, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41486_().m_41497_(TensuraRarity.UNIQUE));
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.f_44957_)) {
            return true;
        }
        if (enchantment.equals(Enchantments.f_44956_)) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        Player player;
        if (pEntityLiving instanceof Player && !this.outOfEP(pStack, player = (Player)pEntityLiving)) {
            int i = this.m_8105_(pStack) - pTimeLeft;
            if (i < 10) {
                return;
            }
            if (!pLevel.f_46443_) {
                pStack.m_41622_(1, (LivingEntity)player, pPlayer -> pPlayer.m_21190_(pEntityLiving.m_7655_()));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                CompoundTag tag = pStack.m_41784_();
                double cost = 200 + EnchantmentHelper.m_44932_((ItemStack)pStack) * 100;
                tag.m_128347_("DurabilityEP", tag.m_128459_("DurabilityEP") - cost);
            }
            int j = 3 + EnchantmentHelper.m_44932_((ItemStack)pStack);
            float f7 = player.m_146908_();
            float f = player.m_146909_();
            float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
            float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
            float f5 = 0.75f * (float)j;
            player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
            player.m_204079_(20);
            if (player.m_20096_()) {
                player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            pLevel.m_6269_(null, (Entity)player, SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        ItemStack itemstack = player.m_21120_(pHand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (this.outOfEP(itemstack, player)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    private boolean outOfEP(ItemStack stack, Player player) {
        double cost = 200 + EnchantmentHelper.m_44932_((ItemStack)stack) * 100;
        return !player.m_150110_().f_35937_ && stack.m_41784_().m_128459_("DurabilityEP") < cost;
    }

    public static boolean onHit(LivingEntity attacker, @Nullable LivingEntity target, Vec3 position) {
        AABB aabb;
        List list;
        if (!attacker.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)TensuraToolItems.VORTEX_SPEAR.get()) && !attacker.m_6844_(EquipmentSlot.OFFHAND).m_150930_((Item)TensuraToolItems.VORTEX_SPEAR.get())) {
            return false;
        }
        if (!attacker.m_21209_()) {
            return false;
        }
        attacker.m_183634_();
        if (TensuraGameRules.canSkillGrief(attacker.m_9236_())) {
            SkillHelper.launchBlock((Entity)attacker, position, 4, 2, 0.25f, 0.25f, blockState -> {
                if (attacker.m_217043_().m_188503_(3) != 1) {
                    return false;
                }
                return blockState.m_204336_(TensuraTags.Blocks.EARTH_DOMINATING);
            }, blockPos -> true);
        }
        if (!(list = attacker.f_19853_.m_6443_(LivingEntity.class, aabb = attacker.m_20191_().m_82400_(2.0), living -> !living.m_7306_((Entity)attacker) && living != target)).isEmpty()) {
            for (LivingEntity living2 : list) {
                if (!living2.m_6469_(DamageSource.m_19370_((LivingEntity)attacker), (float)attacker.m_21133_(Attributes.f_22281_))) continue;
                TensuraParticleHelper.spawnServerGroundSlamParticle(living2, 10, 2.0f);
                living2.m_20184_().m_82520_(0.0, 0.1, 0.0);
            }
        }
        return true;
    }
}

