/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.entity.projectile.WebBulletProjectile;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.custom.WebCartridgeItem;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.google.common.collect.ImmutableSet;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class WebGunItem
extends TieredItem
implements Vanishable {
    private static final List<Enchantment> enchantmentList = ImmutableSet.of((Object)Enchantments.f_44986_, (Object)Enchantments.f_44962_, (Object)Enchantments.f_44963_, (Object)Enchantments.f_44960_).asList();
    private static final Random random = new Random();

    public WebGunItem() {
        super((Tier)Tiers.IRON, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41503_(340).m_41497_(TensuraRarity.UNIQUE));
    }

    public int m_8105_(ItemStack pStack) {
        return WebGunItem.getChargeDuration(pStack) + 3;
    }

    public static int getChargeDuration(ItemStack pGun) {
        int i = pGun.getEnchantmentLevel(Enchantments.f_44960_);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public boolean m_41463_(ItemStack pStack) {
        return pStack.m_150930_((Item)this);
    }

    public static boolean isCharged(ItemStack pGun) {
        CompoundTag compoundtag = pGun.m_41783_();
        if (compoundtag == null) {
            return false;
        }
        if (compoundtag.m_128423_("ammo") == null) {
            return false;
        }
        return compoundtag.m_128471_("Charged");
    }

    public static void setCharged(ItemStack pGun, @Nullable ItemStack ammo, boolean pIsCharged) {
        CompoundTag compoundtag = pGun.m_41784_();
        compoundtag.m_128379_("Charged", pIsCharged);
        if (ammo != null) {
            compoundtag.m_128365_("ammo", (Tag)ammo.m_41739_(new CompoundTag()));
        }
    }

    public static ItemStack getAmmo(ItemStack pGun) {
        CompoundTag compound = pGun.m_41783_();
        if (compound != null && compound.m_128425_("ammo", 10)) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_("ammo"));
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (WebGunItem.isCharged(pStack)) {
            ItemStack itemstack = WebGunItem.getAmmo(pStack);
            pTooltip.add((Component)Component.m_237115_((String)"tooltip.tensura.web_gun.projectile").m_130946_(" ").m_7220_(itemstack.m_41611_()).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantmentList.contains(enchantment) || enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public ItemStack findAmmo(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return ItemStack.f_41583_;
        }
        Player player = (Player)entity;
        if (player.m_21206_().m_41720_() instanceof WebCartridgeItem) {
            return player.m_21206_();
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof WebCartridgeItem)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (WebGunItem.isCharged(itemstack)) {
            this.performShooting(pLevel, (LivingEntity)pPlayer, pHand, itemstack);
            WebGunItem.setCharged(itemstack, null, false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!this.findAmmo((LivingEntity)pPlayer).m_41619_() || pPlayer.m_7500_()) {
            if (!WebGunItem.isCharged(itemstack)) {
                pPlayer.m_6672_(pHand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5929_(Level pLevel, LivingEntity pEntityLiving, ItemStack pStack, int pCount) {
        if (pLevel.f_46443_) {
            return;
        }
        if (!(pEntityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)pEntityLiving;
        float f = (float)(pStack.m_41779_() - pCount) / (float)WebGunItem.getChargeDuration(pStack);
        ItemStack ammo = this.findAmmo(pEntityLiving);
        if (player.m_7500_() && ammo.m_41619_()) {
            ammo = ((Item)TensuraToolItems.STICKY_WEB_CARTRIDGE.get()).m_7968_();
        }
        if (f >= 1.0f && !WebGunItem.isCharged(pStack) && !ammo.m_41619_()) {
            if (!player.m_7500_()) {
                ammo.m_41774_(1);
            }
            WebGunItem.setCharged(pStack, ammo, true);
            pLevel.m_6263_(null, pEntityLiving.m_20185_(), pEntityLiving.m_20186_(), pEntityLiving.m_20189_(), SoundEvents.f_11673_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public void performShooting(Level worldIn, LivingEntity livingEntity, InteractionHand handIn, ItemStack sourceItem) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (worldIn.f_46443_) {
            return;
        }
        worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 0.5f, 0.4f + (random.nextFloat() * 0.4f + 0.8f));
        boolean left = handIn == InteractionHand.OFF_HAND && player.m_5737_() == HumanoidArm.RIGHT || handIn == InteractionHand.MAIN_HAND && player.m_5737_() == HumanoidArm.LEFT;
        this.bulletShooting(worldIn, player, sourceItem, WebGunItem.getAmmo(sourceItem), !left);
        sourceItem.m_41622_(1, (LivingEntity)player, pPlayer -> player.m_21190_(player.m_7655_()));
        player.m_6674_(handIn);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public void bulletShooting(Level pLevel, Player player, ItemStack sourceItem, ItemStack ammo, boolean right) {
        WebBulletProjectile bullet = new WebBulletProjectile(pLevel, (LivingEntity)player, right, sourceItem, ammo);
        Vector3f vector3f = new Vector3f(player.m_20252_(1.0f));
        bullet.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 1.0f, 0.0f);
        player.m_6674_(player.m_7655_());
        pLevel.m_7967_((Entity)bullet);
    }
}

