/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.food;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.entity.projectile.ThrownHealingPotion;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.items.TensuraConsumableItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class HealingPotionItem
extends PotionItem {
    private final float healingPercentage;
    private final float magiculePercentage;

    public HealingPotionItem(int nutrition, float saturationModifier, float healingPercentage, float magiculePercentage) {
        super(new Item.Properties().m_41491_(TensuraCreativeTab.CONSUMABLES).m_41487_(1).m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturationModifier).m_38767_()));
        this.healingPercentage = healingPercentage;
        this.magiculePercentage = magiculePercentage;
    }

    public ItemStack m_7968_() {
        return new ItemStack((ItemLike)this);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
    }

    public String m_5671_(ItemStack pStack) {
        return this.m_5524_();
    }

    public boolean m_5812_(ItemStack pStack) {
        return pStack.m_41793_();
    }

    public void m_6787_(CreativeModeTab pGroup, NonNullList<ItemStack> pItems) {
        if (this.m_220152_(pGroup)) {
            pItems.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 16;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (!pPlayer.m_6047_()) {
            return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
        }
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!pLevel.f_46443_) {
            ThrownHealingPotion potion = new ThrownHealingPotion(pLevel, (LivingEntity)pPlayer);
            potion.m_37446_(itemstack);
            potion.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), -20.0f, 0.75f, 1.0f);
            pLevel.m_7967_((Entity)potion);
        }
        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!pPlayer.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        Player pPlayer;
        Player player;
        Player player2 = player = pEntityLiving instanceof Player ? (pPlayer = (Player)pEntityLiving) : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, pStack);
        }
        if (player != null) {
            this.healEntity((LivingEntity)player, 1.0f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                pStack.m_41774_(1);
            }
        }
        if (player == null || !player.m_150110_().f_35937_) {
            if (pStack.m_41619_()) {
                return new ItemStack((ItemLike)TensuraConsumableItems.MAGIC_BOTTLE.get());
            }
            if (player != null) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)TensuraConsumableItems.MAGIC_BOTTLE.get()));
            }
        }
        pEntityLiving.m_146850_(GameEvent.f_223704_);
        return pStack;
    }

    public InteractionResult m_6880_(ItemStack pStack, Player player, LivingEntity pTarget, InteractionHand pHand) {
        if (pTarget.m_6084_()) {
            if (!player.m_150110_().f_35937_) {
                ItemStack bottle = new ItemStack((ItemLike)TensuraConsumableItems.MAGIC_BOTTLE.get());
                if (!player.m_150109_().m_36054_(bottle)) {
                    player.m_36176_(bottle, false);
                }
            }
            pTarget.m_5584_(player.m_9236_(), pStack);
            this.healEntity(pTarget, 1.0f);
            pTarget.f_19853_.m_6269_(player, (Entity)pTarget, SoundEvents.f_11911_, SoundSource.PLAYERS, 1.0f, 1.0f);
            pTarget.f_19853_.m_6269_(player, (Entity)pTarget, SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        return InteractionResult.PASS;
    }

    public void healEntity(LivingEntity living, float multiplier) {
        if (!living.m_6084_()) {
            return;
        }
        if (this.healingPercentage > 0.0f) {
            living.m_5634_(living.m_21233_() * this.healingPercentage * multiplier);
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            if (this.magiculePercentage > 0.0f) {
                double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                TensuraPlayerCapability.getFrom(player).ifPresent(cap -> cap.setMagicule(Math.min(maxMP, cap.getMagicule() + maxMP * (double)this.magiculePercentage * (double)multiplier)));
                TensuraPlayerCapability.sync(player);
            }
        }
    }

    public float getHealingPercentage() {
        return this.healingPercentage;
    }

    public float getMagiculePercentage() {
        return this.magiculePercentage;
    }
}

