/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.menu;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.menu.TensuraMenuTypes;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.github.manasmods.tensura.world.savedata.UniqueSkillSaveData;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RaceSelectionMenu
extends AbstractContainerMenu {
    private static final Logger log = LogManager.getLogger(RaceSelectionMenu.class);
    public final DataSlot selectedRaceIndex = DataSlot.m_39401_();
    public List<Race> registeredRaces;
    public static final int SUBMIT_BUTTON_ID = -1;
    public static final int RACE_ONLY_SUBMIT_ID = -2;
    private final Player player;
    private boolean raceOnly = false;
    public static final List<TensuraSkill> rimuruSkills = List.of((TensuraSkill)((Object)UniqueSkills.PREDATOR.get()), (TensuraSkill)((Object)UniqueSkills.GREAT_SAGE.get()), (TensuraSkill)((Object)ResistanceSkills.THERMAL_FLUCTUATION_RESISTANCE.get()), (TensuraSkill)((Object)ResistanceSkills.ELECTRICITY_RESISTANCE.get()), (TensuraSkill)((Object)ResistanceSkills.PIERCE_RESISTANCE.get()), (TensuraSkill)((Object)ResistanceSkills.PAIN_NULLIFICATION.get()), (TensuraSkill)((Object)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get()));

    public RaceSelectionMenu(int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        this(pContainerId, inventory, inventory.f_35978_);
        this.raceOnly = buf.readBoolean();
        this.registeredRaces = buf.m_236845_(FriendlyByteBuf::m_130281_).stream().map(resourceLocation -> (Race)TensuraRaces.RACE_REGISTRY.get().getValue(resourceLocation)).filter(Objects::nonNull).toList();
    }

    public RaceSelectionMenu(int pContainerId, Inventory inventory, Player player) {
        super((MenuType)TensuraMenuTypes.RACE_SELECTION.get(), pContainerId);
        this.player = player;
        this.m_38895_(this.selectedRaceIndex).m_6422_(0);
        this.registeredRaces = TensuraPlayerCapability.loadRaces().stream().map(resourceLocation -> (Race)TensuraRaces.RACE_REGISTRY.get().getValue(resourceLocation)).filter(Objects::nonNull).toList();
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRaceIndex(pId)) {
            this.selectedRaceIndex.m_6422_(pId);
            return true;
        }
        if (pId == -1) {
            try {
                Race race = this.registeredRaces.get(this.selectedRaceIndex.m_6501_());
                RaceSelectionMenu.setRace(pPlayer, race, true, !pPlayer.m_9236_().m_46469_().m_46207_(TensuraGameRules.SKILL_BEFORE_RACE));
                return true;
            }
            catch (IndexOutOfBoundsException | NoClassDefFoundError | NullPointerException ex) {
                log.error((Object)ex);
            }
        } else if (pId == -2) {
            try {
                RaceSelectionMenu.setRace(pPlayer, this.registeredRaces.get(this.selectedRaceIndex.m_6501_()), true, false);
                return true;
            }
            catch (IndexOutOfBoundsException | NoClassDefFoundError | NullPointerException ex) {
                log.error((Object)ex);
            }
        }
        return super.m_6366_(pPlayer, pId);
    }

    public static void setRace(Player pPlayer, Race race, boolean resetEP, boolean grantUnique) {
        if (pPlayer.m_9236_().m_5776_()) {
            return;
        }
        TensuraPlayerCapability.getFrom(pPlayer).ifPresent(cap -> {
            cap.setRace((LivingEntity)pPlayer, race, resetEP);
            cap.setTrackedEvolution(pPlayer, null);
            cap.setSpiritualForm(MobEffectHelper.inSpiritualWorld(race.getRespawnDimension()));
            RaceSelectionMenu.applySpiritBlessingChance(pPlayer, cap);
            if (!race.getIntrinsicSkills(pPlayer).isEmpty()) {
                for (ManasSkill manasSkill : race.getIntrinsicSkills(pPlayer)) {
                    TensuraSkillInstance instance = new TensuraSkillInstance(manasSkill);
                    if (!SkillUtils.learnSkill((LivingEntity)pPlayer, instance)) continue;
                    cap.addIntrinsicSkill(instance.getSkill());
                    pPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    if (!instance.canBeToggled((LivingEntity)pPlayer)) continue;
                    instance.setToggled(true);
                    instance.onToggleOn((LivingEntity)pPlayer);
                }
            }
            if (grantUnique) {
                RaceSelectionMenu.grantUniqueSkill(pPlayer);
            }
        });
        TensuraPlayerCapability.sync(pPlayer);
        TensuraEPCapability.updateEP((LivingEntity)pPlayer);
        pPlayer.m_20331_(false);
        pPlayer.m_6210_();
        Pose pose = pPlayer.m_20089_();
        pPlayer.m_20124_(Pose.CROUCHING);
        pPlayer.m_20124_(pose);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pPlayer;
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.REINCARNATED);
        }
        RaceHelper.handleRespawnDimension(pPlayer, race);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    private boolean isValidRaceIndex(int pId) {
        if (pId < 0) {
            return false;
        }
        return pId < this.registeredRaces.size();
    }

    public static void grantUniqueSkill(Player player) {
        if (player.m_9236_().m_46469_().m_46207_(TensuraGameRules.NO_UNIQUE_START)) {
            int skills = (Integer)TensuraConfig.INSTANCE.skillsConfig.skillNumber.get();
            double cost = (double)(10000 * skills * player.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST)) / 100.0;
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player);
                cap.setBaseAura(cap.getBaseAura() + cost, (LivingEntity)player);
                TensuraPlayerCapability.sync(player);
            });
            return;
        }
        RaceSelectionMenu.randomUniqueSkill(player, true);
    }

    public static void randomUniqueSkill(Player player, boolean coverEP) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        int skills = (Integer)TensuraConfig.INSTANCE.skillsConfig.skillNumber.get();
        int counterGamerule = level2.m_46469_().m_46215_(TensuraGameRules.RESET_COUNTER_BONUS_UNIQUE);
        int bonusReset = counterGamerule <= 0 ? 0 : Math.min(TensuraPlayerCapability.getResetCounter(player) / counterGamerule, (Integer)TensuraConfig.INSTANCE.skillsConfig.maxCounterBonus.get());
        for (int i = 1; !(i > skills + bonusReset || i >= bonusReset + 2 && (double)player.m_217043_().m_188503_(100) > (Double)TensuraConfig.INSTANCE.skillsConfig.additionalUniqueChance.get()); ++i) {
            List<ManasSkill> collection = RaceSelectionMenu.getReincarnationSkills(level2, false, player);
            if (skills == 2 && i == bonusReset + 2) {
                collection = RaceSelectionMenu.getSecondReincarnationSkills(level2, false);
            }
            if (collection.isEmpty()) continue;
            ManasSkill manasSkill = collection.get(player.m_217043_().m_188503_(collection.size()));
            TensuraSkillInstance instance = new TensuraSkillInstance(manasSkill);
            if (coverEP) {
                instance.getOrCreateTag().m_128379_("NoMagiculeCost", true);
            }
            if (!SkillAPI.getSkillsFrom((Entity)player).learnSkill((ManasSkillInstance)instance)) continue;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            UniqueSkillSaveData.get(level2.m_7654_().m_129783_()).addSkill(manasSkill.getRegistryName(), player.m_20148_());
        }
    }

    public static List<ManasSkill> getReincarnationSkills(ServerLevel level, boolean ignoreGameRule, @Nullable Player roller) {
        return ((List)TensuraConfig.INSTANCE.skillsConfig.reincarnationSkills.get()).stream().filter(skill -> {
            if (ignoreGameRule) {
                return true;
            }
            if (!level.m_46469_().m_46207_(TensuraGameRules.TRULY_UNIQUE)) {
                return true;
            }
            return !UniqueSkillSaveData.get(level.m_7654_().m_129783_()).hasSkill(new ResourceLocation(skill));
        }).map(skill -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill))).filter(skill -> {
            if (skill == null) {
                return false;
            }
            return roller == null || !SkillUtils.hasSkill((Entity)roller, skill);
        }).toList();
    }

    public static List<ManasSkill> getSecondReincarnationSkills(ServerLevel level, boolean ignoreGameRule) {
        return ((List)TensuraConfig.INSTANCE.skillsConfig.secondSkills.get()).stream().filter(manasSkill -> {
            if (!ignoreGameRule && !level.m_46469_().m_46207_(TensuraGameRules.TRULY_UNIQUE)) {
                return true;
            }
            return !UniqueSkillSaveData.get(level.m_7654_().m_129783_()).hasSkill(new ResourceLocation(manasSkill));
        }).map(skill -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(new ResourceLocation(skill))).filter(Objects::nonNull).toList();
    }

    public static void reincarnateAsRimuru(Player pPlayer) {
        TensuraPlayerCapability.getFrom(pPlayer).ifPresent(cap -> {
            Race race = (Race)TensuraRaces.SLIME.get();
            cap.setRace((LivingEntity)pPlayer, race, true);
            cap.setTrackedEvolution(pPlayer, null);
            if (!race.getIntrinsicSkills(pPlayer).isEmpty()) {
                for (ManasSkill manasSkill : race.getIntrinsicSkills(pPlayer)) {
                    TensuraSkillInstance instance = new TensuraSkillInstance(manasSkill);
                    if (!SkillUtils.learnSkill((LivingEntity)pPlayer, instance)) continue;
                    cap.addIntrinsicSkill(instance.getSkill());
                    pPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    if (!instance.canBeToggled((LivingEntity)pPlayer)) continue;
                    instance.setToggled(true);
                    instance.onToggleOn((LivingEntity)pPlayer);
                }
            }
        });
        TensuraPlayerCapability.sync(pPlayer);
        TensuraEPCapability.updateEP((LivingEntity)pPlayer);
        if (!pPlayer.m_9236_().m_5776_()) {
            for (ManasSkill manasSkill : rimuruSkills) {
                TensuraSkillInstance instance = new TensuraSkillInstance(manasSkill);
                instance.getOrCreateTag().m_128379_("NoMagiculeCost", true);
                if (!SkillUtils.learnSkill((LivingEntity)pPlayer, instance)) continue;
                pPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pPlayer;
            TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.REINCARNATED);
        }
    }

    public static void applySpiritBlessingChance(Player player, ITensuraPlayerCapability cap) {
        if (cap.getRace() != null && cap.getRace().isMajin()) {
            return;
        }
        if ((double)(player.m_217043_().m_188501_() * 100.0f) <= (Double)TensuraConfig.INSTANCE.awakeningConfig.blessedPercentage.get()) {
            cap.setBlessed(true);
            TensuraPlayerCapability.sync(player);
        }
    }

    public static void grantLearningResistance(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        for (ManasSkill skill : SkillAPI.getSkillRegistry().getValues()) {
            ResistSkill resist;
            if (storage.getSkill(skill).isPresent() || !(skill instanceof ResistSkill) || (resist = (ResistSkill)skill).getResistType().equals((Object)ResistSkill.ResistType.NULLIFICATION) || resist.pointRequirement() == -1) continue;
            TensuraSkillInstance instance = new TensuraSkillInstance(skill);
            instance.setMastery(resist.pointRequirement() * -1);
            storage.learnSkill((ManasSkillInstance)instance);
            storage.syncChanges();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isRaceOnly() {
        return this.raceOnly;
    }
}

