/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.menu;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.menu.slot.spatial.LavaStorageInputSlot;
import com.github.manasmods.tensura.menu.slot.spatial.SpatialSlot;
import com.github.manasmods.tensura.menu.slot.spatial.WaterStorageInputSlot;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SpatialStorageMenu
extends AbstractContainerMenu {
    private static final Logger log = LogManager.getLogger(SpatialStorageMenu.class);
    private final ManasSkill skill;
    private final Player player;
    private final SimpleContainer container;
    private final DataSlot startIndex = DataSlot.m_39401_();
    private final Container liquidInputSlots = new SimpleContainer(2);
    public final ResultContainer waterStorageOutput = new ResultContainer();
    public final ResultContainer lavaStorageOutput = new ResultContainer();

    public SpatialStorageMenu(int id, Inventory inv, Player player, SimpleContainer container, ManasSkill skill) {
        super(null, id);
        this.skill = skill;
        this.player = player;
        this.container = container;
        this.container.m_19164_(arg_0 -> ((SpatialStorageMenu)this).m_6199_(arg_0));
        SpatialStorageMenu.m_38869_((Container)container, (int)this.getStorageSize());
        this.m_38895_(this.startIndex).m_6422_(0);
        container.m_5856_(player);
        this.addSpatialSlots();
        this.addLiquidStorageSlots();
        this.addPlayerInventory(inv);
        this.addPlayerHotBar(inv);
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.startIndex.m_6422_(pId);
            this.container.m_6596_();
            this.m_6199_((Container)this.container);
            this.f_38839_.forEach(Slot::m_6654_);
            return true;
        }
        return super.m_6366_(pPlayer, pId);
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.getStorageSize();
    }

    public int getStartIndex() {
        return this.startIndex.m_6501_();
    }

    public int getStorageSize() {
        return this.container.m_6643_();
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int slot = 0; slot < 9; ++slot) {
                this.m_38897_(new Slot((Container)inventory, slot + row * 9 + 9, 8 + slot * 18, 86 + row * 18));
            }
        }
    }

    private void addPlayerHotBar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 144));
        }
    }

    private void addSpatialSlots() {
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new SpatialSlot(this, (Container)this.container, k + j * 9, 2 + k * 18, 19 + j * 18));
            }
        }
    }

    private void addLiquidStorageSlots() {
        this.m_38897_(new Slot((Container)this.waterStorageOutput, 0, -22, 145){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }
        });
        this.m_38897_(new Slot((Container)this.lavaStorageOutput, 0, 182, 145){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }
        });
        this.m_38897_(new WaterStorageInputSlot(this, this.liquidInputSlots, -22, 1));
        this.m_38897_(new LavaStorageInputSlot(this, this.liquidInputSlots, 182, 1));
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    @Nullable
    private ManasSkillInstance getSkillInstance(Player player) {
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(this.skill);
        return optional.orElse(null);
    }

    public void m_6877_(Player pPlayer) {
        SimpleContainer simpleContainer;
        ManasSkillInstance instance = this.getSkillInstance(pPlayer);
        if (instance != null && (simpleContainer = this.container) instanceof SpatialStorageContainer) {
            SpatialStorageContainer storageContainer = (SpatialStorageContainer)simpleContainer;
            simpleContainer = instance.getSkill();
            if (simpleContainer instanceof ISpatialStorage) {
                ISpatialStorage spatialStorage = (ISpatialStorage)simpleContainer;
                spatialStorage.saveContainer(instance, (LivingEntity)pPlayer, storageContainer);
            }
        }
        this.container.m_5785_(pPlayer);
        this.m_150411_(pPlayer, this.liquidInputSlots);
        this.m_150411_(pPlayer, (Container)this.waterStorageOutput);
        this.m_150411_(pPlayer, (Container)this.lavaStorageOutput);
        super.m_6877_(pPlayer);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex < 31 ? !this.m_38903_(itemstack1, 31, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 31, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.m_41753_()) {
            while (!pStack.m_41619_() && !(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && slot.m_5857_(pStack) && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + pStack.m_41613_();
                    int n = maxSize = i < 27 ? this.container.m_6893_() : Math.min(itemstack.m_41741_(), slot.m_6641_());
                    if (j <= maxSize) {
                        pStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        pStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot pSlot = (Slot)this.f_38839_.get(i);
                ItemStack stack = pSlot.m_7993_();
                if (stack.m_41619_() && pSlot.m_5857_(pStack)) {
                    if (pStack.m_41613_() > pSlot.m_6641_()) {
                        pSlot.m_5852_(pStack.m_41620_(pSlot.m_6641_()));
                    } else {
                        pSlot.m_5852_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    pSlot.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ManasSkill getSkill() {
        return this.skill;
    }

    public Player getPlayer() {
        return this.player;
    }
}

