/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.menu.container;

import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.menu.DegenerateCraftingMenu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DecraftingContainer
implements Container {
    private final NonNullList<ItemStack> itemStacks;
    private final int width;
    private final int height;
    private final DegenerateCraftingMenu menu;

    public DecraftingContainer(DegenerateCraftingMenu pMenu, int pWidth, int pHeight) {
        this.itemStacks = NonNullList.m_122780_((int)(pWidth * pHeight), (Object)ItemStack.f_41583_);
        this.menu = pMenu;
        this.width = pWidth;
        this.height = pHeight;
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7983_() {
        ItemStack itemStack;
        Iterator iterator = this.itemStacks.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)iterator.next()).m_41619_());
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int pIndex) {
        return pIndex >= this.m_6643_() ? ItemStack.f_41583_ : (ItemStack)this.itemStacks.get(pIndex);
    }

    @NotNull
    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.itemStacks, (int)pIndex);
    }

    @NotNull
    public ItemStack m_7407_(int pIndex, int pCount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.itemStacks, (int)pIndex, (int)pCount);
        if (!itemStack.m_41619_()) {
            this.menu.m_6199_(this);
        }
        return itemStack;
    }

    public void m_6836_(int pIndex, @NotNull ItemStack pStack) {
        this.itemStacks.set(pIndex, (Object)pStack);
        this.menu.m_6199_(this);
    }

    public void m_6596_() {
    }

    public void updateSlots(ItemStack itemStack, Level level) {
        this.m_6211_();
        this.fillOutputSlots(itemStack, level);
        this.menu.m_6199_(this);
    }

    private void fillOutputSlots(ItemStack inputStack, Level level) {
        if (level.m_5776_()) {
            return;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        Recipe<?> recipe = this.searchRecipe(inputStack, server.m_129894_());
        if (recipe == null) {
            return;
        }
        List list = this.convertTo3x3(recipe).stream().collect(ArrayList::new, (accumulator, ingredient) -> accumulator.add(ingredient.m_43947_() ? ItemStack.f_41583_ : ingredient.m_43908_()[0]), ArrayList::addAll);
        int index = 0;
        if (list.isEmpty()) {
            return;
        }
        for (ItemStack ingredient2 : list) {
            this.m_6836_(index, ingredient2.m_41777_());
            ++index;
        }
    }

    private List<Ingredient> convertTo3x3(Recipe<?> recipe) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
        if (recipe instanceof IShapedRecipe) {
            int width = ((IShapedRecipe)recipe).getRecipeWidth();
            if (width == 2) {
                ingredients.add(Ingredient.f_43901_);
                ingredients.add(Ingredient.f_43901_);
                ingredients.add(Ingredient.f_43901_);
                ingredients.add(4, Ingredient.f_43901_);
                ingredients.add(2, Ingredient.f_43901_);
            } else if (width == 1) {
                ingredients.add(Ingredient.f_43901_);
                ingredients.add(Ingredient.f_43901_);
                ingredients.add(2, Ingredient.f_43901_);
                ingredients.add(2, Ingredient.f_43901_);
                ingredients.add(1, Ingredient.f_43901_);
                ingredients.add(1, Ingredient.f_43901_);
                ingredients.add(0, Ingredient.f_43901_);
            }
        }
        while (ingredients.size() > 9) {
            ingredients.remove(ingredients.size() - 1);
        }
        return ingredients;
    }

    @Nullable
    private Recipe<?> searchRecipe(ItemStack input, RecipeManager recipeManager) {
        BlockItem blockItem;
        Item inputItem = input.m_41720_();
        if (input.m_204117_(TensuraTags.Items.NO_DECRAFT)) {
            return null;
        }
        if (input.m_41768_() || input.m_41793_()) {
            return null;
        }
        if (inputItem instanceof BlockItem && (blockItem = (BlockItem)inputItem).m_40614_() instanceof ShulkerBoxBlock) {
            return null;
        }
        Optional<Recipe> optionalRecipe = recipeManager.m_44051_().stream().filter(recipe -> {
            if (!recipe.m_6671_().equals(RecipeType.f_44107_)) {
                return false;
            }
            if (recipe.m_8043_().m_41613_() > 1) {
                return false;
            }
            if (recipe.m_8043_().m_41720_() != inputItem) {
                return false;
            }
            return !recipe.m_7527_().isEmpty();
        }).findFirst();
        return optionalRecipe.orElse(null);
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return true;
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean m_7013_(int pIndex, @NotNull ItemStack pStack) {
        return false;
    }
}

