/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2client;

import com.github.manasmods.tensura.network.play2client.ClientAccess;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSpatialStorageOpenPacket {
    protected final int userId;
    protected final int containerId;
    protected final int size;
    protected final int stackSize;
    protected final ResourceLocation skill;
    protected final byte containerType;

    public ClientboundSpatialStorageOpenPacket(int userId, int containerId, int size, int stackSize, ResourceLocation skill) {
        this.userId = userId;
        this.containerId = containerId;
        this.size = size;
        this.stackSize = stackSize;
        this.skill = skill;
        this.containerType = 0;
    }

    public ClientboundSpatialStorageOpenPacket(int userId, int containerId, int size, int stackSize, ResourceLocation skill, byte type) {
        this.userId = userId;
        this.containerId = containerId;
        this.size = size;
        this.stackSize = stackSize;
        this.skill = skill;
        this.containerType = type;
    }

    public ClientboundSpatialStorageOpenPacket(FriendlyByteBuf buffer) {
        this.userId = buffer.readInt();
        this.containerId = buffer.readByte();
        this.size = buffer.m_130242_();
        this.stackSize = buffer.readInt();
        this.skill = buffer.m_130281_();
        this.containerType = buffer.readByte();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.userId);
        buffer.writeByte(this.containerId);
        buffer.m_130130_(this.size);
        buffer.writeInt(this.stackSize);
        buffer.m_130085_(this.skill);
        buffer.writeByte((int)this.containerType);
    }

    public static void handle(ClientboundSpatialStorageOpenPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientboundSpatialStorageOpenPacket.lambda$handle$1(message, (Supplier)context)));
        context.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$1(ClientboundSpatialStorageOpenPacket message, Supplier context) {
        return () -> ClientboundSpatialStorageOpenPacket.lambda$handle$0(message, (Supplier)context);
    }

    private static /* synthetic */ void lambda$handle$0(ClientboundSpatialStorageOpenPacket message, Supplier context) {
        switch (message.containerType) {
            default: {
                ClientAccess.handleClientboundSpatialStorageOpenPacket(message, context);
                break;
            }
            case 1: {
                ClientAccess.handleClientboundSpatialCraftingOpenPacket(message, context);
                break;
            }
            case 2: {
                ClientAccess.handleClientboundSpatialRefiningOpenPacket(message, context);
                break;
            }
            case 3: {
                ClientAccess.handleClientboundResearcherStorageOpenPacket(message, context);
            }
        }
    }
}

