/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2client;

import com.github.manasmods.tensura.network.play2client.ClientAccess;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncSmithingCapabilityPacket {
    private final CompoundTag data;
    private final int entityId;

    public SyncSmithingCapabilityPacket(FriendlyByteBuf buf) {
        this.data = buf.m_130261_();
        this.entityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.data);
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientAccess.updateSmithingCapability(this.entityId, this.data)));
        ctx.get().setPacketHandled(true);
    }

    public SyncSmithingCapabilityPacket(CompoundTag data, int entityId) {
        this.data = data;
        this.entityId = entityId;
    }
}

