/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestAwakeningPacket {
    private final boolean trueHero;

    public RequestAwakeningPacket(FriendlyByteBuf buf) {
        this.trueHero = buf.readBoolean();
    }

    public RequestAwakeningPacket(boolean trueHero) {
        this.trueHero = trueHero;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.trueHero);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (RaceHelper.shouldNamingStopAwakening((Player)player)) {
                return;
            }
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                if (cap.isTrueDemonLord()) {
                    return;
                }
                if (cap.isTrueHero()) {
                    return;
                }
                if (this.trueHero) {
                    if (!cap.isHeroEgg()) {
                        return;
                    }
                    if (cap.getRace() != null && cap.getRace().isMajin()) {
                        return;
                    }
                    if (!RaceHelper.fightingBossForHero((Player)player)) {
                        return;
                    }
                    cap.setTrueHero(true);
                    TensuraPlayerCapability.sync((Player)player);
                    RaceHelper.awakening((Player)player, true);
                } else {
                    if (!cap.isDemonLordSeed()) {
                        return;
                    }
                    int requirement = player.m_9236_().m_6106_().m_5470_().m_46215_(TensuraGameRules.DEMON_LORD_AWAKEN);
                    if (cap.getSoulPoints() < requirement * 1000) {
                        return;
                    }
                    cap.setSoulPoints(cap.getSoulPoints() - requirement * 1000);
                    cap.setTrueDemonLord(true);
                    TensuraPlayerCapability.sync((Player)player);
                    RaceHelper.awakening((Player)player, false);
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

