/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server;

import com.github.manasmods.tensura.handler.RaceHandler;
import com.github.manasmods.tensura.handler.client.ClientRaceHandler;
import com.github.manasmods.tensura.network.play2server.SlimeJumpChargePacket;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SlimeJumpReleasedPacket {
    public static final Map<UUID, Float> jumpChargeData = new ConcurrentHashMap<UUID, Float>();

    public SlimeJumpReleasedPacket() {
    }

    public SlimeJumpReleasedPacket(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (RaceHandler.isInFluid((LivingEntity)player) || !player.m_6047_() || !player.m_20096_() && player.f_19789_ > 1.0f) {
                SlimeJumpChargePacket.chargingPlayers.remove(player.m_20148_());
                ClientRaceHandler.jumpChargingTicks = 0L;
                jumpChargeData.remove(player.m_20148_());
                return;
            }
            if (!player.m_20096_()) {
                return;
            }
            if (!SlimeJumpChargePacket.chargingPlayers.containsKey(player.m_20148_())) {
                return;
            }
            long startedCharging = SlimeJumpChargePacket.chargingPlayers.get(player.m_20148_());
            long totalChargeMills = System.currentTimeMillis() - startedCharging;
            float chargeInPercent = 0.33333334f * (float)Math.min(TimeUnit.MILLISECONDS.toSeconds(totalChargeMills), 3L);
            jumpChargeData.put(player.m_20148_(), Float.valueOf(chargeInPercent));
            SlimeJumpChargePacket.chargingPlayers.remove(player.m_20148_());
            player.m_6135_();
        });
        ctx.get().setPacketHandled(true);
    }
}

