/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server.skill;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestChangeModeButtonPacket {
    public final double presetChange;
    public final int slot;
    public boolean alternative;

    public RequestChangeModeButtonPacket(FriendlyByteBuf buf) {
        this.presetChange = buf.readDouble();
        this.slot = buf.readInt();
        this.alternative = buf.readBoolean();
    }

    public RequestChangeModeButtonPacket(double presetChange, boolean scroll) {
        this.presetChange = presetChange;
        this.slot = -1;
        this.alternative = scroll;
    }

    public RequestChangeModeButtonPacket(int slot, boolean reverse) {
        this.presetChange = 0.0;
        this.slot = slot;
        this.alternative = reverse;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.presetChange);
        buf.writeInt(this.slot);
        buf.writeBoolean(this.alternative);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                if (this.slot == -1) {
                    this.changePreset((Player)player);
                } else {
                    this.changeMode((Player)player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void changeMode(Player player) {
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
            for (ManasSkillInstance instance : storage.getLearnedSkills()) {
                TensuraSkillInstance skillInstance;
                if (!cap.isSkillInSpecificSlot(instance.getSkill(), this.slot) || !(instance instanceof TensuraSkillInstance) || !(skillInstance = (TensuraSkillInstance)instance).canInteractSkill((LivingEntity)player)) continue;
                TensuraSkill skill = (TensuraSkill)skillInstance.getSkill();
                if (skill.modes() > 1) {
                    int nextMode = skill.nextMode((LivingEntity)player, skillInstance, this.alternative);
                    if (nextMode == 0) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.cannot_change", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                        continue;
                    }
                    skillInstance.setMode(nextMode);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.changed", (Object[])new Object[]{skill.getName(), skill.getModeName(nextMode)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    storage.syncChanges();
                    continue;
                }
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.no_mode", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
        });
    }

    public void changePreset(Player player) {
        if (this.alternative) {
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                int activePreset = cap.getActivePreset();
                int newPreset = activePreset + (int)this.presetChange;
                if (newPreset > 8) {
                    newPreset = 0;
                }
                if (newPreset < 0) {
                    newPreset = 8;
                }
                if (activePreset != newPreset) {
                    cap.setActivePreset(newPreset);
                    TensuraSkillCapability.sync(player);
                }
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.preset.changed", (Object[])new Object[]{cap.getPresetName(newPreset)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
            });
        } else if (this.presetChange < 10.0 && this.presetChange > 0.0) {
            int key = (int)this.presetChange - 1;
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                if (cap.getActivePreset() != key) {
                    cap.setActivePreset(key);
                    TensuraSkillCapability.sync(player);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.preset.changed", (Object[])new Object[]{cap.getPresetName(key)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.preset.no_change", (Object[])new Object[]{cap.getPresetName(key)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
            });
        }
    }
}

