/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class RequestFalsifierItemPacket {
    private final int slot;
    private final ItemStack item;

    public RequestFalsifierItemPacket(FriendlyByteBuf buf) {
        this.slot = buf.readInt();
        this.item = buf.m_130267_();
    }

    public RequestFalsifierItemPacket(ItemStack item, EquipmentSlot slot) {
        this.slot = slot.m_20750_();
        this.item = item;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slot);
        buf.m_130055_(this.item);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
            Optional optional = storage.getSkill((ManasSkill)UniqueSkills.FALSIFIER.get());
            if (optional.isEmpty()) {
                return;
            }
            ManasSkillInstance instance = (ManasSkillInstance)optional.get();
            CompoundTag tag = instance.getOrCreateTag();
            EquipmentSlot equipmentSlot = this.getEquipmentSlot();
            tag.m_128365_(equipmentSlot.m_20751_(), (Tag)this.item.serializeNBT());
            instance.markDirty();
            storage.syncChanges();
        });
        ctx.get().setPacketHandled(true);
    }

    private EquipmentSlot getEquipmentSlot() {
        if (this.slot == 0) {
            return EquipmentSlot.MAINHAND;
        }
        if (this.slot == 5) {
            return EquipmentSlot.OFFHAND;
        }
        return EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(this.slot - 1));
    }

    public static ItemStack getFalsifierItem(LivingEntity pLivingEntity, EquipmentSlot slot) {
        ItemStack stack = RequestFalsifierItemPacket.getFalsifierItem(pLivingEntity, pLivingEntity.m_6844_(slot), slot);
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Empty") ? RequestFalsifierItemPacket.getEmptyStack() : stack;
    }

    public static ItemStack getFalsifierItem(LivingEntity pLivingEntity, ItemStack original, EquipmentSlot slot) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)pLivingEntity);
        Optional optional = storage.getSkill((ManasSkill)UniqueSkills.FALSIFIER.get());
        if (optional.isEmpty()) {
            return original;
        }
        CompoundTag tag = ((ManasSkillInstance)optional.get()).getTag();
        if (tag == null || !tag.m_128441_(slot.m_20751_())) {
            return original;
        }
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(slot.m_20751_()));
        if (itemStack.m_41619_()) {
            return original;
        }
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128471_("Empty")) {
            ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
            stack.m_41784_().m_128379_("Empty", true);
            return stack;
        }
        return itemStack;
    }

    public static ItemStack getEmptyStack() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42127_);
        stack.m_41784_().m_128379_("Empty", true);
        return stack;
    }
}

