/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.network.play2server.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.unique.AntiSkill;
import com.github.manasmods.tensura.ability.skill.unique.CreatorSkill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillCreationPacket {
    private final ResourceLocation skill;

    public RequestSkillCreationPacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
    }

    public RequestSkillCreationPacket(ResourceLocation skill) {
        this.skill = skill;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                this.createSkill(player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void createSkill(ServerPlayer player) {
        ManasSkill manasSkill;
        Optional createdInstance;
        ManasSkill createdSkill;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalCreator = storage.getSkill((ManasSkill)UniqueSkills.CREATOR.get());
        if (optionalCreator.isEmpty()) {
            return;
        }
        ManasSkillInstance creator = (ManasSkillInstance)optionalCreator.get();
        if (creator.onCoolDown()) {
            return;
        }
        ((CreatorSkill)((Object)UniqueSkills.CREATOR.get())).addMasteryPoint(creator, (LivingEntity)player, 5 + SkillUtils.getBonusMasteryPoint(creator, (LivingEntity)player, 5));
        creator.setCoolDown(1200);
        CompoundTag tag = creator.getOrCreateTag();
        ResourceLocation createdLocation = new ResourceLocation(tag.m_128461_("created_skill"));
        if (createdLocation.equals((Object)this.skill)) {
            ManasSkill oldSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill);
            if (oldSkill == null) {
                return;
            }
            Optional optional = storage.getSkill(oldSkill);
            if (optional.isPresent() && ((ManasSkillInstance)optional.get()).isTemporarySkill()) {
                if (creator.isMastered((LivingEntity)player) && oldSkill.equals(UniqueSkills.ANTI_SKILL.get())) {
                    ((AntiSkill)((Object)UniqueSkills.ANTI_SKILL.get())).addMasteryPoint((ManasSkillInstance)optional.get(), (LivingEntity)player, oldSkill.getMaxMastery());
                }
                ((ManasSkillInstance)optional.get()).setRemoveTime(1200);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                creator.markDirty();
                storage.syncChanges();
                return;
            }
        }
        if ((createdSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(createdLocation)) != null && (createdInstance = storage.getSkill(createdSkill)).isPresent() && ((ManasSkillInstance)createdInstance.get()).isTemporarySkill()) {
            storage.forgetSkill(createdSkill);
        }
        if ((manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill)) == null) {
            return;
        }
        tag.m_128359_("created_skill", String.valueOf(manasSkill.getRegistryName()));
        TensuraSkillInstance skillInstance = new TensuraSkillInstance(manasSkill);
        if (creator.isMastered((LivingEntity)player) && manasSkill.equals(UniqueSkills.ANTI_SKILL.get())) {
            ((AntiSkill)((Object)UniqueSkills.ANTI_SKILL.get())).addMasteryPoint(skillInstance, (LivingEntity)player, manasSkill.getMaxMastery());
        }
        skillInstance.setRemoveTime(1200);
        skillInstance.getOrCreateTag().m_128379_("CreatorSkill", true);
        if (storage.learnSkill((ManasSkillInstance)skillInstance)) {
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraSkillCapability.getFrom((Player)player).ifPresent(cap -> {
                if (cap.getSkillInSlot(0) == null) {
                    cap.setInstanceInSlot(skillInstance, 0);
                } else if (cap.getSkillInSlot(1) == null) {
                    cap.setInstanceInSlot(skillInstance, 1);
                } else if (cap.getSkillInSlot(2) == null) {
                    cap.setInstanceInSlot(skillInstance, 2);
                }
                TensuraSkillCapability.sync((Player)player);
            });
        }
        creator.markDirty();
        storage.syncChanges();
        player.m_6915_();
    }
}

