/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race;

import com.github.manasmods.manascore.api.attribute.AttributeModifierHelper;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.data.pack.EntityEPCount;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.handler.CapabilityHandler;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.vampire.GhoulRace;
import com.github.manasmods.tensura.race.wight.WightRace;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.dimensions.HellTeleporter;
import com.github.manasmods.tensura.registry.dimensions.LabyrinthTeleporter;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.attribute.TensuraAttributeModifierIds;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class RaceHelper {
    public static boolean isSpiritual(LivingEntity entity) {
        return entity.m_6095_().m_204039_(TensuraTags.EntityTypes.SPIRITUAL);
    }

    public static boolean isSpiritualLifeForm(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
            if (race != null && race.isSpiritual()) {
                return true;
            }
            if (TensuraPlayerCapability.isSpiritualForm(player)) {
                return true;
            }
        }
        return RaceHelper.isSpiritual(entity);
    }

    public static float spiritualReducePhysicalDamage(DamageSource damageSource) {
        if (!DamageSourceHelper.isPhysicalAttack(damageSource)) {
            return 1.0f;
        }
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            MobEffectInstance instance = entity2.m_21124_((MobEffect)TensuraMobEffects.HAKI_COAT.get());
            if (instance != null) {
                if (instance.m_19564_() >= 1) {
                    return 1.0f;
                }
                if (instance.m_19564_() >= 0) {
                    return 0.5f;
                }
            }
            if (entity2.m_21023_((MobEffect)TensuraMobEffects.MAGIC_AURA.get())) {
                return 0.5f;
            }
            if (!TensuraSkillCapability.isSkillInSlot(entity2, (ManasSkill)UniqueSkills.COOK.get())) {
                return 0.5f;
            }
        }
        return 0.001f;
    }

    public static boolean isAffectedByHolyCoat(Entity entity) {
        LivingEntity target;
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
            return true;
        }
        if (entity instanceof LivingEntity && TensuraEPCapability.isMajin(target = (LivingEntity)entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !TensuraEPCapability.isChaos((LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    public static boolean isUndead(Entity entity) {
        Mob mob;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (TensuraEPCapability.isChaos((LivingEntity)player)) {
                return false;
            }
            Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
            if (race instanceof WightRace) {
                return true;
            }
            return race instanceof GhoulRace;
        }
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.UNDEAD)) {
            return true;
        }
        return entity instanceof Mob && (mob = (Mob)entity).m_6336_().equals(MobType.f_21641_);
    }

    public static boolean hasNoBlood(LivingEntity entity) {
        Player player;
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_BLOOD)) {
            return true;
        }
        if (entity instanceof Player && TensuraPlayerCapability.isSpiritualForm(player = (Player)entity)) {
            return true;
        }
        return RaceHelper.isUndead((Entity)entity);
    }

    public static float getSizeMultiplier(LivingEntity entity) {
        return RaceHelper.getRaceSizeMultiplier(entity) * RaceHelper.getSkillSizeMultiplier(entity) * TensuraEffectsCapability.getHeight(entity);
    }

    public static float getRaceSizeMultiplier(LivingEntity entity) {
        if (entity instanceof CloneEntity) {
            CloneEntity clone = (CloneEntity)entity;
            return clone.getHeight();
        }
        Race race = TensuraPlayerCapability.getRace(entity);
        return RaceHelper.getRaceSize(race);
    }

    public static float getRaceSize(@Nullable Race race) {
        float size = 1.0f;
        if (race != null) {
            size *= race.getPlayerSize() / 2.0f;
        }
        return (float)Math.max((double)size, (Double)TensuraConfig.INSTANCE.attributeConfig.minimumSize.get());
    }

    public static float getSkillSizeMultiplier(LivingEntity entity) {
        AttributeInstance instance;
        float size = 1.0f;
        if (entity.m_21204_() != null && (instance = entity.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get())) != null) {
            size *= (float)instance.m_22135_();
        }
        return size;
    }

    public static void handleRespawnDimension(Player player, Race race) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ResourceKey<Level> dimension = race.getRespawnDimension();
        ResourceKey respawnDimension = serverPlayer.m_8963_();
        if (dimension == respawnDimension) {
            return;
        }
        ResourceKey currentDimension = player.m_9236_().m_46472_();
        if (dimension == currentDimension) {
            return;
        }
        ServerLevel serverLevel = player.m_9236_().m_7654_().m_129880_(dimension);
        if (serverLevel == null) {
            return;
        }
        if (dimension == TensuraDimensions.HELL) {
            player.changeDimension(serverLevel, (ITeleporter)new HellTeleporter(true));
        } else if (dimension == TensuraDimensions.LABYRINTH) {
            player.changeDimension(serverLevel, (ITeleporter)new LabyrinthTeleporter());
        } else {
            player.m_5489_(serverLevel);
        }
    }

    public static void applyMajinChance(Player player) {
        double chance;
        double d = chance = SkillUtils.hasSkill((Entity)player, (ManasSkill)UniqueSkills.VILLAIN.get()) ? 100.0 : (Double)TensuraConfig.INSTANCE.awakeningConfig.majinPercentage.get();
        if ((double)(player.m_217043_().m_188501_() * 100.0f) <= chance) {
            TensuraEPCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
                if (cap.isMajin()) {
                    return;
                }
                cap.setMajin(true);
                TensuraEPCapability.sync((LivingEntity)player);
            });
        }
    }

    public static boolean evolveRace(Player player) {
        Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (race == null) {
            return false;
        }
        Race evo = race.getDefaultEvolution(player);
        if (evo == null) {
            return false;
        }
        return RaceHelper.evolveRace(player, evo, true);
    }

    public static boolean evolveRace(Player player, Race race, boolean triggerRewards) {
        return RaceHelper.evolveRace(player, race, triggerRewards, false);
    }

    public static boolean evolveRace(Player player, Race race, boolean triggerRewards, boolean skipNextEvo) {
        if (player.m_9236_().m_5776_()) {
            return false;
        }
        Race originalRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (originalRace == null) {
            return false;
        }
        if (!skipNextEvo && !originalRace.getNextEvolutions(player).contains(race)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.GROWTH_SPURT);
        }
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            boolean isMajin = TensuraEPCapability.isMajin((LivingEntity)player);
            cap.setRace((LivingEntity)player, race, false);
            if (isMajin || race.isMajin()) {
                TensuraEPCapability.setMajin((LivingEntity)player, true);
            }
            if (triggerRewards) {
                race.triggerEvolutionRewards(player);
            }
            if (!race.getIntrinsicSkills(player).isEmpty()) {
                for (ManasSkill manasSkill : race.getIntrinsicSkills(player)) {
                    if (!SkillUtils.learnSkill((LivingEntity)player, new TensuraSkillInstance(manasSkill))) continue;
                    cap.addIntrinsicSkill(manasSkill);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
            }
            if (cap.isHeroEgg() && race.isMajin() && !TensuraEPCapability.isChaos((LivingEntity)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"tensura.evolve.hero.egg_lost.evolution").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        });
        TensuraPlayerCapability.sync(player);
        return originalRace != race;
    }

    public static boolean canAwaken(Player player, boolean isHero, int souls) {
        if (RaceHelper.shouldNamingStopAwakening(player)) {
            return false;
        }
        ITensuraPlayerCapability cap = CapabilityHandler.getCapability((Entity)player, TensuraPlayerCapability.CAPABILITY);
        if (cap == null) {
            return false;
        }
        if (cap.isTrueDemonLord()) {
            return false;
        }
        if (cap.isTrueHero()) {
            return false;
        }
        if (isHero) {
            if (!cap.isHeroEgg()) {
                return false;
            }
            if (cap.getRace() != null && cap.getRace().isMajin()) {
                return false;
            }
            return RaceHelper.fightingBossForHero(player);
        }
        return cap.isDemonLordSeed() && cap.getSoulPoints() >= souls * 1000;
    }

    public static void awakening(Player player, boolean isHero) {
        Level level = player.m_9236_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.HIGHER_FORM);
        }
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            float multiplier = isHero ? 3.0f : 2.5f;
            cap.setBaseMagicule(cap.getBaseMagicule() * (double)multiplier, (LivingEntity)player);
            cap.setBaseAura(cap.getBaseAura() * (double)multiplier, (LivingEntity)player);
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
            for (ManasSkillInstance instance : List.copyOf(storage.getLearnedSkills())) {
                ManasSkill patt12472$temp = instance.getSkill();
                if (!(patt12472$temp instanceof ResistSkill)) continue;
                ResistSkill resistSkill = (ResistSkill)patt12472$temp;
                storage.getSkill((ManasSkill)resistSkill).ifPresent(skillInstance -> resistSkill.evolveToNullification((ManasSkillInstance)skillInstance, (LivingEntity)player));
            }
            if (cap.getRace() != null && cap.getRace().getAwakeningEvolution(player) != null) {
                RaceHelper.evolveRace(player, cap.getRace().getAwakeningEvolution(player), false, true);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
            if (isHero) {
                for (Player everyone : level.m_6907_()) {
                    everyone.m_5661_((Component)Component.m_237110_((String)"tensura.evolve.hero.success", (Object[])new Object[]{player.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                ManasSkill skill = (ManasSkill)IntrinsicSkills.UNPREDICTABILITY.get();
                if (SkillUtils.learnSkill((LivingEntity)player, skill)) {
                    cap.addIntrinsicSkill(skill);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                TensuraPlayerCapability.sync(player);
                return;
            }
            for (Player everyone : level.m_6907_()) {
                Race race;
                everyone.m_5661_((Component)Component.m_237110_((String)"tensura.evolve.demon_lord.success", (Object[])new Object[]{player.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                if (!Objects.equals(TensuraEPCapability.getPermanentOwner((LivingEntity)everyone), player.m_20148_()) || (race = TensuraPlayerCapability.getRace((LivingEntity)player)) == null || race.getHarvestFestivalEvolution(player) == null) continue;
                everyone.m_5661_((Component)Component.m_237115_((String)"tensura.evolve.demon_lord.subordinate_evolve").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                RaceHelper.evolveRace(everyone, race.getHarvestFestivalEvolution(player), true);
            }
            List list = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(30.0), living -> !(living instanceof Player) && living.m_6084_());
            if (!list.isEmpty()) {
                for (LivingEntity sub : list) {
                    if (!Objects.equals(TensuraEPCapability.getPermanentOwner(sub), player.m_20148_())) continue;
                    TensuraEPCapability.getFrom(sub).ifPresent(epCap -> {
                        if (!epCap.isHarvestGift()) {
                            epCap.setHarvestGift(true);
                            epCap.setEP(sub, epCap.getEP() * 2.0);
                            RaceHelper.evolveMobs(sub);
                            TensuraEPCapability.sync(sub);
                        }
                    });
                }
            }
        });
        TensuraPlayerCapability.sync(player);
    }

    public static boolean shouldNamingStopAwakening(Player player) {
        if (!player.m_9236_().m_46469_().m_46207_(TensuraGameRules.HARDCORE_RACE)) {
            return false;
        }
        return TensuraEPCapability.getName((LivingEntity)player) != null && TensuraEPCapability.getPermanentOwner((LivingEntity)player) != null;
    }

    public static boolean fightingBossForHero(Player player) {
        LivingEntity lastHurtBy = player.m_21188_();
        if (lastHurtBy != null && lastHurtBy.m_6095_().m_204039_(TensuraTags.EntityTypes.HERO_BOSS) && SkillHelper.getSubordinateOwner(lastHurtBy) == null && lastHurtBy.m_21223_() < lastHurtBy.m_21233_() / 2.0f && TensuraEPCapability.getEP(lastHurtBy) >= 400000.0) {
            return true;
        }
        LivingEntity lastHurt = player.m_21214_();
        if (lastHurt == null) {
            return false;
        }
        if (!lastHurt.m_6095_().m_204039_(TensuraTags.EntityTypes.HERO_BOSS)) {
            return false;
        }
        if (SkillHelper.getSubordinateOwner(lastHurt) != null) {
            return false;
        }
        if (lastHurt.m_21223_() >= lastHurt.m_21233_() / 2.0f) {
            return false;
        }
        return TensuraEPCapability.getEP(lastHurt) >= 400000.0;
    }

    public static void applyBaseAttribute(EntityType<? extends LivingEntity> type, LivingEntity entity) {
        RaceHelper.applyBaseAttribute(DefaultAttributes.m_22297_(type), entity);
    }

    public static void applyBaseAttribute(AttributeSupplier supplier, LivingEntity entity) {
        RaceHelper.applyBaseAttribute(supplier, entity, false);
    }

    public static void applyBaseAttribute(AttributeSupplier supplier, LivingEntity entity, boolean totalReset) {
        for (AttributeInstance attribute : supplier.f_22241_.values()) {
            AttributeInstance attributeInstance = entity.m_21051_(attribute.m_22099_());
            if (attributeInstance == null) continue;
            double base = attribute.m_22115_();
            if (!totalReset && !(attributeInstance.m_22115_() < base)) continue;
            attributeInstance.m_22100_(base);
        }
    }

    public static void evolveMobs(LivingEntity sub) {
        if (sub instanceof IRanking) {
            IRanking ranking = (IRanking)sub;
            ranking.evolve();
        }
        for (EntityEPCount entityEP : TensuraData.getEntityEP()) {
            Optional optional;
            if (!entityEP.getEntity().equals((Object)EntityType.m_20613_((EntityType)sub.m_6095_())) || (optional = EntityType.m_20632_((String)entityEP.getEvolution().toString())).isEmpty()) continue;
            Level level = sub.m_9236_();
            CompoundTag tag = sub.serializeNBT();
            sub.m_146870_();
            Entity entity = ((EntityType)optional.get()).m_20615_(level);
            if (entity == null) continue;
            entity.m_20258_(tag);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    mob.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(mob.m_20183_()), MobSpawnType.CONVERSION, null, null);
                }
            }
            level.m_7967_(entity);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            RaceHelper.applyBaseAttribute((EntityType<? extends LivingEntity>)((EntityType)optional.get()), living);
            living.m_21153_(living.m_21233_());
            RaceHelper.updateSpiritualHP(living);
            RaceHelper.updateEntityEPCount(living, entityEP.getEvolution());
        }
    }

    public static void updateSpiritualHP(LivingEntity living) {
        double maxSHP = living.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        if ((double)(living.m_21233_() * 2.0f) > maxSHP) {
            AttributeModifierHelper.setModifier((LivingEntity)living, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_SPIRITUAL_HEALTH_MODIFIER_ID, "tensura:race_base_spiritual_health", (double)(living.m_21233_() * 2.0f) - maxSHP, AttributeModifier.Operation.ADDITION));
        }
        TensuraEPCapability.setSpiritualHealth(living, living.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
    }

    public static void updateEntityEPCount(LivingEntity living) {
        RaceHelper.updateEntityEPCount(living, EntityType.m_20613_((EntityType)living.m_6095_()));
    }

    public static void updateEntityEPCount(LivingEntity living, ResourceLocation location) {
        for (EntityEPCount evolvedEPCount : TensuraData.getEntityEP()) {
            if (!evolvedEPCount.getEntity().equals((Object)location)) continue;
            TensuraEPCapability.getFrom(living).ifPresent(cap -> {
                int minEP = evolvedEPCount.getMinEP();
                if (cap.getEP() < (double)minEP) {
                    int maxEP = evolvedEPCount.getMaxEP() + 1;
                    if (maxEP <= minEP) {
                        maxEP = minEP + 1;
                    }
                    cap.setEP(living, living.m_217043_().m_216339_(minEP, maxEP));
                }
            });
            for (ResourceLocation skillID : evolvedEPCount.getSkills()) {
                ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillID);
                if (skill == null) continue;
                TensuraSkillInstance instance = new TensuraSkillInstance(skill);
                SkillAPI.getSkillsFrom((Entity)living).learnSkill((ManasSkillInstance)instance);
                if (!instance.canBeToggled(living)) continue;
                instance.setToggled(true);
            }
        }
    }
}

