/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.daemon;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.daemon.ArchDaemonRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DaemonLordRace
extends ArchDaemonRace {
    public DaemonLordRace() {
        super(Race.Difficulty.EASY);
    }

    public DaemonLordRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 800.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.5;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.8;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(2.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100000.0, (Object)300000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)200000.0, (Object)500000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.DEVIL_LORD.get();
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 50.0;
    }

    @Override
    public ResourceKey<Level> getRespawnDimension() {
        return Level.f_46428_;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DEVIL_LORD.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ARCH_DAEMON.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double percentage = 0.0;
        if (TensuraEPCapability.getName((LivingEntity)player) != null) {
            percentage += 50.0;
        }
        if (!TensuraPlayerCapability.isSpiritualForm(player)) {
            percentage += 50.0;
        }
        if (TensuraPlayerCapability.isTrueDemonLord(player) || TensuraPlayerCapability.isTrueHero((LivingEntity)player)) {
            percentage += 50.0;
        }
        return percentage;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.name_requirement"));
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.physical_body_requirement"));
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.awaken_requirement", (Object[])new Object[]{Component.m_237115_((String)"tensura.attribute.true_demon_lord.name").m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237115_((String)"tensura.attribute.true_hero.name").m_130940_(ChatFormatting.GOLD)}));
        return list;
    }
}

