/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.daemon;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LesserDaemonRace
extends Race {
    public LesserDaemonRace() {
        super(Race.Difficulty.EASY);
    }

    public LesserDaemonRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 40.0;
    }

    @Override
    public float getPlayerSize() {
        return 3.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.4;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 3.5;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.1;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public double getSprintSpeed() {
        return 0.2;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)2000.0, (Object)3000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)5000.0, (Object)6000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.GREATER_DAEMON.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.DAEMON_LORD.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.GREATER_DAEMON.get();
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 20.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 2.5;
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public boolean isSpiritual() {
        return true;
    }

    @Override
    public ResourceKey<Level> getRespawnDimension() {
        return TensuraDimensions.HELL;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)ResistanceSkills.MAGIC_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)IntrinsicSkills.POSSESSION.get()));
        return list;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.GREATER_DAEMON.get());
        return list;
    }

    @Override
    public void raceAbility(Player entity) {
        if (entity.m_5833_() || entity.m_7500_()) {
            return;
        }
        Level level = entity.m_9236_();
        if (entity.m_150110_().f_35936_) {
            entity.m_150110_().f_35936_ = false;
            entity.m_150110_().f_35935_ = false;
            entity.m_6885_();
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            entity.m_150110_().f_35936_ = true;
            entity.m_150110_().f_35935_ = true;
            entity.m_6885_();
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

