/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.elf;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ElfRace
extends Race {
    public ElfRace() {
        super(Race.Difficulty.INTERMEDIATE);
    }

    public ElfRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 20.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.1;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.12;
    }

    @Override
    public double getSprintSpeed() {
        return 0.156;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)600.0, (Object)800.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)300.0, (Object)600.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_ELF.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.ELF_SAINT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_ELF.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ENLIGHTENED_ELF.get());
        return list;
    }

    @Override
    public boolean hasGuaranteeElemental() {
        return true;
    }

    @Override
    public double getElementalSpiritsChance(MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        if (elemental.equals((Object)MagicElemental.WIND)) {
            if (level.equals((Object)SpiritualMagic.SpiritLevel.LESSER)) {
                return 100.0;
            }
            return super.getElementalSpiritsChance(elemental, level) * 2.0;
        }
        return super.getElementalSpiritsChance(elemental, level);
    }
}

