/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.goblin;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.goblin.HobgoblinRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EnlightenedHobgoblinRace
extends HobgoblinRace {
    public EnlightenedHobgoblinRace() {
        super(Race.Difficulty.EASY);
    }

    @Override
    public double getBaseHealth() {
        return 120.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 2.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.3;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(1.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.5;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 30.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 2.5;
    }

    @Override
    public double getManaEvolutionReward() {
        return 30000.0;
    }

    @Override
    public double getAuraEvolutionReward() {
        return 70000.0;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.HOBGOBLIN_SAINT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.HOBGOBLIN_SAINT.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraEPCapability.getEP((LivingEntity)player) * 100.0 / (Double)TensuraConfig.INSTANCE.racesConfig.epToEnlightened.get();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }
}

