/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.goblin;

import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.goblin.GoblinRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class HobgoblinRace
extends GoblinRace {
    public HobgoblinRace() {
        super(Race.Difficulty.INTERMEDIATE);
    }

    public HobgoblinRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 24.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public double getSprintSpeed() {
        return this.getMovementSpeed() * 1.3;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)600.0, (Object)600.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)1400.0, (Object)1400.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_HOBGOBLIN.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_HOBGOBLIN.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ENLIGHTENED_HOBGOBLIN.get());
        list.add((Race)TensuraRaces.OGRE.get());
        return list;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }
}

