/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.human;

import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class HumanRace
extends Race {
    public HumanRace() {
        super(Race.Difficulty.HARD);
    }

    public HumanRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 20.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public double getSprintSpeed() {
        return 0.13;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)760.0, (Object)1140.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)50.0, (Object)70.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_HUMAN.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.HUMAN_SAINT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_HUMAN.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ENLIGHTENED_HUMAN.get());
        list.add((Race)TensuraRaces.VAMPIRE.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        MobEffectInstance absorption;
        MobEffectInstance regeneration;
        int chance = 0;
        if (player.m_21023_(MobEffects.f_19613_)) {
            chance += 20;
        }
        if (player.m_21023_(MobEffects.f_19606_)) {
            chance += 20;
        }
        if (player.m_21023_(MobEffects.f_19607_)) {
            chance += 20;
        }
        if ((regeneration = player.m_21124_(MobEffects.f_19605_)) != null && regeneration.m_19564_() >= 1) {
            chance += 20;
        }
        if ((absorption = player.m_21124_(MobEffects.f_19617_)) != null && absorption.m_19564_() >= 3) {
            chance += 20;
        }
        return chance;
    }
}

