/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.lizardman;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.lizardman.LizardmanRace;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class DragonewtRace
extends LizardmanRace {
    public DragonewtRace() {
        super(Race.Difficulty.EASY);
    }

    @Override
    public double getBaseHealth() {
        return 54.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 2.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.3;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(0.5);
    }

    @Override
    public double getSprintSpeed() {
        return 0.5;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)6000.0, (Object)6000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)4000.0, (Object)4000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 30.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 2.5;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)((Object)IntrinsicSkills.DRAGON_EYE.get()));
        list.add((TensuraSkill)((Object)IntrinsicSkills.DRAGON_EAR.get()));
        list.add((TensuraSkill)((Object)IntrinsicSkills.DRAGON_MODE.get()));
        switch (RandomSource.m_216327_().m_216332_(1, 3)) {
            case 1: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.FLAME_BREATH.get()));
                break;
            }
            case 2: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.THUNDER_BREATH.get()));
                break;
            }
            case 3: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.FLAME_BREATH.get()));
                list.add((TensuraSkill)((Object)IntrinsicSkills.THUNDER_BREATH.get()));
            }
        }
        list.add((TensuraSkill)((Object)ResistanceSkills.MAGIC_RESISTANCE.get()));
        return list;
    }

    @Override
    public boolean isIntrinsicSkill(Player player, ManasSkill skill) {
        if (skill == IntrinsicSkills.FLAME_BREATH.get()) {
            return true;
        }
        if (skill == IntrinsicSkills.THUNDER_BREATH.get()) {
            return true;
        }
        return super.isIntrinsicSkill(player, skill);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.TRUE_DRAGONEWT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.TRUE_DRAGONEWT.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.LIZARDMAN.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double essence = 0.0;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            essence = localPlayer.m_108630_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.DRAGON_ESSENCE.get())));
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            essence = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.DRAGON_ESSENCE.get())));
        }
        return essence * 100.0 / (double)((Integer)TensuraConfig.INSTANCE.racesConfig.essenceForDragonewt.get()).intValue();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.consume_requirement", (Object[])new Object[]{((Item)TensuraMobDropItems.DRAGON_ESSENCE.get()).m_7968_().m_41611_()}));
        return list;
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public void raceAbility(Player player) {
        if (player.m_36324_().m_38702_() > 0 || player.m_150110_().f_35934_) {
            if (!player.m_150110_().f_35934_) {
                player.m_36324_().m_38703_(2.0f);
            }
            if (player.m_20096_()) {
                Vec3 delta = player.m_20184_();
                double dy = delta.f_82480_ <= 0.0 ? 0.5 : delta.f_82480_ + 0.5;
                player.m_20256_(new Vec3(delta.m_7096_(), dy, delta.m_7094_()));
            }
            SkillHelper.riptidePush((LivingEntity)player, 0.25f);
            player.f_19864_ = true;
            player.f_19812_ = true;
            player.m_36320_();
        }
    }

    @Override
    public void raceTick(Player player) {
        if (!player.f_19853_.m_46469_().m_46207_(TensuraGameRules.HARDCORE_RACE)) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (!player.f_19853_.m_204166_(player.m_20097_()).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD)) {
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 0, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 0, false, false, false));
    }
}

