/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.lizardman;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class LizardmanRace
extends Race {
    public LizardmanRace() {
        super(Race.Difficulty.INTERMEDIATE);
    }

    public LizardmanRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 24.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.2;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public double getSprintSpeed() {
        return 0.13;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)600.0, (Object)800.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)100.0, (Object)200.0);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)IntrinsicSkills.SCALE_ARMOR.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.DRAGONEWT.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.TRUE_DRAGONEWT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.DRAGONEWT.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DRAGONEWT.get());
        return list;
    }

    @Override
    public void raceTick(Player player) {
        if (!player.f_19853_.m_46469_().m_46207_(TensuraGameRules.HARDCORE_RACE)) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (!player.f_19853_.m_204166_(player.m_20097_()).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD)) {
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 0, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 1, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1, false, false, false));
    }
}

