/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.merfolk;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class MerfolkRace
extends Race {
    public MerfolkRace() {
        super(Race.Difficulty.INTERMEDIATE);
    }

    @Override
    public double getBaseHealth() {
        return 24.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.2;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public double getSprintSpeed() {
        return 0.13;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)500.0, (Object)600.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)400.0, (Object)600.0);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)CommonSkills.HYDRAULIC_PROPULSION.get()));
        list.add((TensuraSkill)((Object)IntrinsicSkills.WATER_BREATHING.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_MERFOLK.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.MERFOLK_SAINT.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.ENLIGHTENED_MERFOLK.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ENLIGHTENED_MERFOLK.get());
        return list;
    }

    @Override
    public void raceTick(Player player) {
        if (player.m_20146_() >= player.m_6062_() && MerfolkRace.shouldLoseMoistness((LivingEntity)player, this)) {
            player.m_20301_(player.m_6062_() - 1);
        }
    }

    public static boolean shouldLoseMoistness(LivingEntity entity, @Nullable Race race) {
        Player player;
        if (!entity.f_19853_.m_46469_().m_46207_(TensuraGameRules.HARDCORE_RACE)) {
            return false;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        if (entity.m_5833_()) {
            return false;
        }
        if (race == null) {
            return false;
        }
        if (race.isSpiritual()) {
            return false;
        }
        if (entity.m_6844_(EquipmentSlot.HEAD).getEnchantmentLevel((Enchantment)TensuraEnchantments.BREATHING_SUPPORT.get()) >= 1) {
            return false;
        }
        return !entity.m_20071_();
    }

    @Override
    public boolean hasGuaranteeElemental() {
        return true;
    }

    @Override
    public double getElementalSpiritsChance(MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        if (elemental.equals((Object)MagicElemental.WATER)) {
            if (level.equals((Object)SpiritualMagic.SpiritLevel.LESSER)) {
                return 100.0;
            }
            return super.getElementalSpiritsChance(elemental, level) * 2.0;
        }
        return super.getElementalSpiritsChance(elemental, level);
    }
}

