/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.ogre;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.ogre.OgreRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class KijinRace
extends OgreRace {
    public KijinRace() {
        super(Race.Difficulty.EASY);
    }

    @Override
    public double getBaseHealth() {
        return 30.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.2;
    }

    @Override
    public double getSprintSpeed() {
        return 0.2;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)5000.0, (Object)5000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)5000.0, (Object)5000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 20.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 2.5;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.MYSTIC_ONI.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.MYSTIC_ONI.get();
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        switch (RandomSource.m_216327_().m_188503_(7)) {
            case 0: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.DARKNESS_TRANSFORM.get()));
                break;
            }
            case 1: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.EARTH_TRANSFORM.get()));
                break;
            }
            case 2: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.FLAME_TRANSFORM.get()));
                break;
            }
            case 3: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.LIGHT_TRANSFORM.get()));
                break;
            }
            case 4: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.SPACE_TRANSFORM.get()));
                break;
            }
            case 5: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.WATER_TRANSFORM.get()));
                break;
            }
            case 6: {
                list.add((TensuraSkill)((Object)IntrinsicSkills.WIND_TRANSFORM.get()));
            }
        }
        return list;
    }

    @Override
    public boolean isIntrinsicSkill(Player player, ManasSkill skill) {
        if (skill == IntrinsicSkills.DARKNESS_TRANSFORM.get()) {
            return true;
        }
        if (skill == IntrinsicSkills.EARTH_TRANSFORM.get()) {
            return true;
        }
        if (skill == IntrinsicSkills.FLAME_TRANSFORM.get()) {
            return true;
        }
        if (skill == IntrinsicSkills.LIGHT_TRANSFORM.get()) {
            return true;
        }
        if (skill == IntrinsicSkills.SPACE_TRANSFORM.get()) {
            return true;
        }
        if (skill == IntrinsicSkills.WATER_TRANSFORM.get()) {
            return true;
        }
        if (skill == IntrinsicSkills.WIND_TRANSFORM.get()) {
            return true;
        }
        return super.isIntrinsicSkill(player, skill);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.MYSTIC_ONI.get());
        list.add((Race)TensuraRaces.WICKED_ONI.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.OGRE.get());
        return list;
    }

    @Override
    public double getAuraEvolutionReward() {
        return 2500.0;
    }

    @Override
    public double getManaEvolutionReward() {
        return 2500.0;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        for (MagicElemental elemental : MagicElemental.values()) {
            if (TensuraSkillCapability.getSpiritLevel(player, elemental.getId()) <= 0) continue;
            return 100.0;
        }
        return 0.0;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.spirit_requirement"));
        return list;
    }
}

